/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class DoubleByteEncoder
extends CharsetEncoder {
    private short[] index1;
    private String[] index2;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected int encodeDouble(char c) {
        int n = this.index1[(c & 0xFF00) >> 8] << 8;
        return this.index2[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
    }

    protected int encodeSingle(char c) {
        if (c < '\u0080') {
            return (byte)(c & 0x7F);
        }
        return -1;
    }

    public boolean canEncode(char c) {
        return this.encodeSingle(c) != -1 || this.encodeDouble(c) != 0 && c != '\u0000';
    }

    protected DoubleByteEncoder(Charset charset, short[] sArray, String[] stringArray) {
        super(charset, 2.0f, 2.0f);
        this.index1 = sArray;
        this.index2 = stringArray;
    }

    protected DoubleByteEncoder(Charset charset, short[] sArray, String[] stringArray, float f, float f2) {
        super(charset, f, f2);
        this.index1 = sArray;
        this.index2 = stringArray;
    }

    protected DoubleByteEncoder(Charset charset, short[] sArray, String[] stringArray, byte[] byArray) {
        super(charset, 2.0f, 2.0f, byArray);
        this.index1 = sArray;
        this.index2 = stringArray;
    }

    protected DoubleByteEncoder(Charset charset, short[] sArray, String[] stringArray, byte[] byArray, float f, float f2) {
        super(charset, f, f2, byArray);
        this.index1 = sArray;
        this.index2 = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        boolean bl = false;
        try {
            while (n < n2) {
                char c = cArray[n];
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n5 = this.encodeSingle(c);
                if (n5 != -1) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)n5;
                    ++n;
                    continue;
                }
                int n6 = this.encodeDouble(c);
                if (n6 != 0 && c != '\u0000') {
                    if (n4 - n3 < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)((n6 & 0xFF00) >> 8);
                    byArray[n3++] = (byte)(n6 & 0xFF);
                    ++n;
                    continue;
                }
                CoderResult coderResult = CoderResult.unmappableForLength(1);
                return coderResult;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block11: {
            CoderResult coderResult2;
            block16: {
                CoderResult coderResult3;
                block15: {
                    CoderResult coderResult4;
                    block14: {
                        CoderResult coderResult5;
                        block13: {
                            CoderResult coderResult6;
                            block12: {
                                n = charBuffer.position();
                                boolean bl = false;
                                try {
                                    while (true) {
                                        if (!charBuffer.hasRemaining()) {
                                            coderResult = CoderResult.UNDERFLOW;
                                            break block11;
                                        }
                                        char c = charBuffer.get();
                                        if (Surrogate.is(c)) {
                                            if (this.sgp.parse(c, charBuffer) < 0) {
                                                CoderResult coderResult7 = this.sgp.error();
                                                Object var11_13 = null;
                                                charBuffer.position(n);
                                                return coderResult7;
                                            }
                                            coderResult6 = this.sgp.unmappableResult();
                                            break block12;
                                        }
                                        if (c >= '\ufffe') {
                                            coderResult5 = CoderResult.unmappableForLength(1);
                                            break block13;
                                        }
                                        int n2 = this.encodeSingle(c);
                                        if (n2 != -1) {
                                            if (byteBuffer.remaining() < 1) {
                                                coderResult4 = CoderResult.OVERFLOW;
                                                break block14;
                                            } else {
                                                ++n;
                                                byteBuffer.put((byte)n2);
                                                continue;
                                            }
                                        }
                                        int n3 = this.encodeDouble(c);
                                        if (n3 == 0 || c == '\u0000') break;
                                        if (byteBuffer.remaining() < 2) {
                                            coderResult3 = CoderResult.OVERFLOW;
                                            break block15;
                                        }
                                        ++n;
                                        byteBuffer.put((byte)((n3 & 0xFF00) >> 8));
                                        byteBuffer.put((byte)n3);
                                    }
                                    coderResult2 = CoderResult.unmappableForLength(1);
                                    break block16;
                                }
                                catch (Throwable throwable) {
                                    Object var11_20 = null;
                                    charBuffer.position(n);
                                    throw throwable;
                                }
                            }
                            Object var11_14 = null;
                            charBuffer.position(n);
                            return coderResult6;
                        }
                        Object var11_15 = null;
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var11_16 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var11_17 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var11_18 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var11_19 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

