/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.NetscapeCertTypeExtension;

final class X509TrustManagerImpl
implements X509TrustManager {
    private static final boolean a = Debug.a("com.sun.net.ssl.allowV1CACerts", false);
    private static final String b = "2.5.29.19";
    private static final String c = "2.5.29.15";
    private static final String d = "2.5.29.37";
    private static final String e = "2.16.840.1.113730.1.1";
    private static final String f = "1.3.6.1.5.5.7.3.1";
    private static final String g = "1.3.6.1.5.5.7.3.2";
    private static final String h = "2.5.29.37.0";
    private static final String i = "ssl_client";
    private static final String j = "ssl_server";
    private static final String k = "ssl_ca";
    private Set l = new HashSet();
    private Map m = new HashMap();
    private static final Debug n = Debug.getInstance("ssl");

    X509TrustManagerImpl(KeyStore keyStore) throws KeyStoreException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                certificateArray = keyStore.getCertificate(string);
                if (!(certificateArray instanceof X509Certificate)) continue;
                if (n != null && Debug.isOn("trustmanager")) {
                    System.out.println("adding as trusted cert: " + certificateArray);
                }
                this.a((X509Certificate)certificateArray);
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            if (n != null && Debug.isOn("trustmanager")) {
                System.out.println("adding private entry as trusted cert: " + certificateArray[0]);
            }
            this.a((X509Certificate)certificateArray[0]);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.l.size()];
        this.l.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    private void a(X509Certificate x509Certificate) {
        this.l.add(x509Certificate);
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        ArrayList<X509Certificate> arrayList = (ArrayList<X509Certificate>)this.m.get(x500Principal);
        if (arrayList == null) {
            arrayList = new ArrayList<X509Certificate>();
            this.m.put(x500Principal, arrayList);
        }
        arrayList.add(x509Certificate);
    }

    private boolean b(X509Certificate x509Certificate) {
        return this.l.contains(x509Certificate);
    }

    private void a(X509Certificate x509Certificate, int n, String string) throws CertificateException, IOException {
        Set set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        this.a(x509Certificate, set, n);
        if (n == 0) {
            this.a(x509Certificate, set, string);
        } else {
            this.a(x509Certificate, set);
        }
        if (!set.isEmpty()) {
            throw new CertificateException("Certificate contains unknown critical extensions: " + set);
        }
    }

    private boolean a(X509Certificate x509Certificate, String string) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(e);
        if (byArray == null) {
            return false;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2);
        Boolean bl = (Boolean)netscapeCertTypeExtension.get(string);
        return bl;
    }

    private void a(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        Date date = new Date();
        x509CertificateArray = this.a(x509CertificateArray, date);
        int n = 0;
        while (n < x509CertificateArray.length) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = x509CertificateArray[n];
            if (this.b(x509Certificate2)) {
                if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                    System.out.println("stop on trusted cert: " + x509Certificate2);
                }
                return;
            }
            try {
                this.a(x509Certificate2, n, string);
            }
            catch (Exception exception) {
                if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                    System.out.println("failed extension check: " + x509Certificate2);
                    System.out.println("ext exception was: " + exception);
                }
                if (exception instanceof CertificateException) {
                    throw (CertificateException)exception;
                }
                throw (CertificateException)new CertificateException("failed extensions check").initCause(exception);
            }
            X500Principal x500Principal = x509Certificate2.getIssuerX500Principal();
            X509Certificate x509Certificate3 = x509Certificate = n + 1 < x509CertificateArray.length ? x509CertificateArray[n + 1] : x509Certificate2;
            if (!x500Principal.equals(x509Certificate.getSubjectX500Principal())) {
                String string2 = n + 1 < x509CertificateArray.length ? "Certificate chaining error: issuer DN != subject DN" : "Could not find trusted certificate";
                throw new CertificateException(string2);
            }
            try {
                x509Certificate2.verify(x509Certificate.getPublicKey());
            }
            catch (Exception exception) {
                if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                    System.out.println("verify failed: " + x509Certificate2);
                    System.out.println("verify exception was: " + exception);
                }
                if (exception instanceof CertificateException) {
                    throw (CertificateException)exception;
                }
                throw (CertificateException)new CertificateException("Signature verification failed").initCause(exception);
            }
            ++n;
        }
        throw new CertificateException("Couldn't find trusted certificate");
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.a(x509CertificateArray, "Client." + string);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.a(x509CertificateArray, string);
    }

    private void a(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        set.remove(c);
        set.remove(e);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            throw new CertificateException("Wrong key usage: expect keyCertSign");
        }
        List<String> list = x509Certificate.getExtendedKeyUsage();
        if (list != null && set.contains(d)) {
            set.remove(d);
            if (!list.contains(h)) {
                throw new CertificateException("Extended key usage in CA certificates must include anyExtendedKeyUsage");
            }
        }
        if (x509Certificate.getExtensionValue(e) != null && !this.a(x509Certificate, k)) {
            throw new CertificateException("Invalid Netscape CertType extension for CA certificate");
        }
    }

    private void a(X509Certificate x509Certificate, Set set, int n) throws CertificateException {
        set.remove(b);
        if (n == 0) {
            return;
        }
        if (x509Certificate.getExtensionValue(b) == null) {
            if (!a) {
                throw new CertificateException("CA certificate does not include basic constraints extension");
            }
            if (x509Certificate.getVersion() >= 3) {
                throw new CertificateException("Intermediate X.509v3 certificate without basic constraints extension");
            }
        } else {
            int n2 = x509Certificate.getBasicConstraints();
            if (n2 < 0) {
                throw new CertificateException("End user tried to act as a CA");
            }
            if (n - 1 > n2) {
                throw new CertificateException("Violated path length constraints");
            }
        }
    }

    private void a(X509Certificate x509Certificate, Set set, String string) throws CertificateException, IOException {
        List<String> list;
        set.remove(c);
        set.remove(e);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            if (blArray.length == 0) {
                throw new CertificateException("Invalid key usage extension.");
            }
            boolean bl = blArray[0];
            boolean bl2 = blArray.length >= 3 ? blArray[2] : false;
            String string2 = "Wrong key usage. Expected digitalSignature.";
            String string3 = "Wrong key usage. Expected keyEncipherment.";
            if (string.indexOf("Client") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("DHE_DSS") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("DHE_RSA") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("RSA_EXPORT") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("RSA") != -1) {
                if (!bl2) {
                    throw new CertificateException(string3);
                }
            } else if (string.indexOf("UNKNOWN") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else {
                throw new CertificateException("Unknown authType" + string);
            }
        }
        if ((list = x509Certificate.getExtendedKeyUsage()) != null && set.contains(d)) {
            set.remove(d);
            String string4 = "Extended key usage does not permit use for TLS ";
            if (!list.contains(h)) {
                if (string.indexOf("Client") == -1) {
                    if (!list.contains(f)) {
                        throw new CertificateException(string4 + "server");
                    }
                } else if (!list.contains(g)) {
                    throw new CertificateException(string4 + "client");
                }
            }
        }
        if (x509Certificate.getExtensionValue(e) != null) {
            String string5 = "Invalid Netscape CertType extension for SSL ";
            if (string.indexOf("Client") != -1) {
                if (!this.a(x509Certificate, i)) {
                    throw new CertificateException(string5 + "client");
                }
            } else if (!this.a(x509Certificate, j)) {
                throw new CertificateException(string5 + "server");
            }
        }
    }

    private X509Certificate a(X509Certificate x509Certificate, Date date) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        List list = (List)this.m.get(x500Principal);
        if (list == null) {
            return null;
        }
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        PublicKey publicKey = x509Certificate.getPublicKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate) || !x509Certificate2.getIssuerX500Principal().equals(x500Principal2) || !x509Certificate2.getPublicKey().equals(publicKey)) continue;
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                continue;
            }
            return x509Certificate2;
        }
        return null;
    }

    private X509Certificate b(X509Certificate x509Certificate, Date date) {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        List list = (List)this.m.get(x500Principal);
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                if (n == null || !Debug.isOn("trustmanager")) continue;
                System.out.println("local root cert is invalid: " + x509Certificate2);
                continue;
            }
            return x509Certificate2;
        }
        return null;
    }

    private X509Certificate[] a(X509Certificate[] x509CertificateArray, Date date) throws CertificateException {
        X509Certificate x509Certificate;
        Serializable serializable;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(x509CertificateArray.length);
        boolean bl = false;
        if (x509CertificateArray.length == 0) {
            return x509CertificateArray;
        }
        int n = 0;
        while (n < x509CertificateArray.length) {
            X509Certificate x509Certificate2 = x509CertificateArray[n];
            serializable = this.a(x509Certificate2, date);
            if (serializable == null) {
                try {
                    x509Certificate2.checkValidity(date);
                }
                catch (CertificateException certificateException) {
                    if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                        System.out.println("out of date cert: " + x509Certificate2);
                    }
                    throw certificateException;
                }
            } else {
                x509Certificate2 = serializable;
                bl = true;
                if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                    System.out.println("updated cert with: " + x509Certificate2);
                }
            }
            arrayList.add(x509Certificate2);
            ++n;
        }
        int n2 = x509CertificateArray.length - 1;
        serializable = x509CertificateArray[n2].getSubjectX500Principal();
        X500Principal x500Principal = x509CertificateArray[n2].getIssuerX500Principal();
        if (!x500Principal.equals(serializable) && (x509Certificate = this.b(x509CertificateArray[n2], date)) != null) {
            if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                System.out.println("add missing root cert: " + x509Certificate);
            }
            bl = true;
            arrayList.add(x509Certificate);
        }
        if (bl) {
            return arrayList.toArray(new X509Certificate[arrayList.size()]);
        }
        return x509CertificateArray;
    }
}

