/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.BaseSSLSocketImpl;
import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.SunJSSE_a2;
import com.sun.net.ssl.internal.ssl.SunJSSE_a3;
import com.sun.net.ssl.internal.ssl.SunJSSE_a4;
import com.sun.net.ssl.internal.ssl.SunJSSE_a5;
import com.sun.net.ssl.internal.ssl.SunJSSE_a7;
import com.sun.net.ssl.internal.ssl.SunJSSE_a8;
import com.sun.net.ssl.internal.ssl.SunJSSE_ax;
import com.sun.net.ssl.internal.ssl.SunJSSE_ba;
import com.sun.net.ssl.internal.ssl.SunJSSE_bb;
import com.sun.net.ssl.internal.ssl.SunJSSE_bc;
import com.sun.net.ssl.internal.ssl.SunJSSE_bd;
import com.sun.net.ssl.internal.ssl.SunJSSE_be;
import com.sun.net.ssl.internal.ssl.SunJSSE_g;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Iterator;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

final class SunJSSE_aw
extends SunJSSE_ax {
    private byte a;
    private X509Certificate[] b;
    private PrivateKey c;
    private boolean d = false;
    private PrivateKey e;
    private PublicKey f;
    private SunJSSE_bd g;
    private ProtocolVersion h;

    void a(byte by) {
        this.a = by;
    }

    void b(byte by) throws SSLProtocolException {
        String string = BaseSSLSocketImpl.b(by);
        if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
            System.out.println("SSL -- handshake alert:  " + string);
        }
        if (by == 41 && this.a == 1) {
            return;
        }
        throw new SSLProtocolException("handshake alert: " + string);
    }

    void a(byte by, int n) throws IOException {
        if (((SunJSSE_ax)this).h > by && ((SunJSSE_ax)this).h != 16 && by != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + ((SunJSSE_ax)this).h + ", type = " + by);
        }
        switch (by) {
            case 1: {
                ((SunJSSE_ax)this).f.mark(n);
                SunJSSE_a4 sunJSSE_a4 = new SunJSSE_a4(((SunJSSE_ax)this).f);
                ((SunJSSE_ax)this).f.reset();
                ((SunJSSE_ax)this).f.skip(n);
                this.a(sunJSSE_a4);
                break;
            }
            case 11: {
                if (this.a == 0) {
                    ((SunJSSE_ax)this).d.a((byte)10, "client sent unsolicited cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(((SunJSSE_ax)this).f));
                break;
            }
            case 16: {
                byte[] byArray = this.q == SunJSSE_g.K_RSA || this.q == SunJSSE_g.K_RSA_EXPORT ? this.a(new SunJSSE_be(((SunJSSE_ax)this).a, this.h, this.i.a(), ((SunJSSE_ax)this).f, n, this.c)) : this.a(new ClientDiffieHellmanPublic(((SunJSSE_ax)this).f));
                this.a(byArray);
                Arrays.fill(byArray, (byte)0);
                break;
            }
            case 15: {
                this.a(new SunJSSE_bc(((SunJSSE_ax)this).f));
                break;
            }
            case 20: {
                this.b(new SunJSSE_a7(((SunJSSE_ax)this).a, ((SunJSSE_ax)this).f));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + by);
            }
        }
        if (((SunJSSE_ax)this).h < by && by != 15) {
            ((SunJSSE_ax)this).h = by;
        }
    }

    private void c(boolean bl) {
        boolean bl2 = !bl;
        this.g = new SunJSSE_bd(bl2);
        this.g.a(this.i.a(), bl2 ? 768 : 512);
    }

    private void d(boolean bl) throws IOException {
        ((SunJSSE_ax)this).g.flush();
        SunJSSE_a7 sunJSSE_a7 = new SunJSSE_a7(((SunJSSE_ax)this).a, ((SunJSSE_ax)this).e, 2, this.l.a());
        this.a(sunJSSE_a7);
        if (!bl || !this.r) {
            ((SunJSSE_ax)this).h = 20;
        }
    }

    private boolean b(boolean bl) {
        KeyPair keyPair = this.i.d().a(bl, this.i.a());
        if (keyPair == null) {
            return false;
        }
        this.f = (RSAPublicKey)keyPair.getPublic();
        this.e = keyPair.getPrivate();
        return true;
    }

    boolean a(CipherSuite cipherSuite) {
        if (this.r) {
            return true;
        }
        if (!cipherSuite.a()) {
            return false;
        }
        CipherSuite.KeyExchange keyExchange = cipherSuite.h;
        this.c = null;
        this.b = null;
        this.g = null;
        this.e = null;
        this.f = null;
        if (keyExchange == SunJSSE_g.K_RSA || keyExchange == SunJSSE_g.K_RSA_EXPORT || keyExchange == SunJSSE_g.K_DHE_RSA) {
            if (!this.a("RSA")) {
                return false;
            }
            if (keyExchange == SunJSSE_g.K_RSA_EXPORT) {
                PublicKey publicKey = this.b[0].getPublicKey();
                if (!(publicKey instanceof RSAPublicKey)) {
                    return false;
                }
                RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
                if (rSAPublicKey.getModulus().bitLength() > 512 && !this.b(cipherSuite.k)) {
                    return false;
                }
            } else if (keyExchange == SunJSSE_g.K_DHE_RSA) {
                this.c(cipherSuite.k);
            }
        } else if (keyExchange == SunJSSE_g.K_DHE_DSS) {
            if (!this.a("DSA")) {
                return false;
            }
            this.c(cipherSuite.k);
        } else if (keyExchange == SunJSSE_g.K_DH_ANON) {
            this.c(cipherSuite.k);
        } else {
            throw new RuntimeException("CipherSuite: " + cipherSuite);
        }
        this.b(cipherSuite);
        return true;
    }

    private byte[] a(ClientDiffieHellmanPublic clientDiffieHellmanPublic) throws IOException {
        if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
            clientDiffieHellmanPublic.a(System.out);
        }
        return this.g.a(clientDiffieHellmanPublic.getClientPublicKey());
    }

    HandshakeMessage a() {
        return new SunJSSE_a3();
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            if (this.a == 1) {
                return;
            }
            ((SunJSSE_ax)this).d.a((byte)42, "null cert chain");
        }
        X509TrustManager x509TrustManager = this.i.c();
        try {
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            String string = publicKey instanceof RSAPublicKey ? "RSA" : (publicKey instanceof DSAPublicKey ? "DSA" : "UNKNOWN");
            x509TrustManager.checkClientTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            ((SunJSSE_ax)this).d.a((byte)46, certificateException);
        }
        this.d = true;
        this.l.a(x509CertificateArray);
    }

    private void a(SunJSSE_a4 sunJSSE_a4) throws IOException {
        Object object;
        Object object2;
        if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
            sunJSSE_a4.a(System.out);
        }
        ((SunJSSE_ax)this).f.a();
        SunJSSE_a5 sunJSSE_a5 = new SunJSSE_a5();
        this.h = sunJSSE_a4.a;
        if (this.h.i < ((SunJSSE_ax)this).b.d.i) {
            throw new SSLProtocolException("version mismatch, client is " + this.h);
        }
        ProtocolVersion protocolVersion = this.h.i <= ((SunJSSE_ax)this).b.e.i ? this.h : ((SunJSSE_ax)this).b.e;
        this.a(protocolVersion);
        sunJSSE_a5.a = ((SunJSSE_ax)this).a;
        this.j = sunJSSE_a4.b;
        sunJSSE_a5.b = this.k = new SunJSSE_a2(this.i.a());
        this.l = null;
        if (sunJSSE_a4.c.a() != 0 && (object2 = ((SSLSessionContextImpl)this.i.engineGetServerSessionContext()).a(sunJSSE_a4.c.b())) != null) {
            this.r = ((SSLSessionImpl)object2).b();
            if (this.r && (object = ((SSLSessionImpl)object2).f()) != ((SunJSSE_ax)this).a) {
                this.r = false;
            }
            if (this.r && this.a != 0) {
                try {
                    ((SSLSessionImpl)object2).getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    this.r = false;
                }
            }
            if (this.r) {
                object = ((SSLSessionImpl)object2).e();
                if (!this.c((CipherSuite)object) || !sunJSSE_a4.d.a((CipherSuite)object)) {
                    this.r = false;
                } else {
                    this.b((CipherSuite)object);
                }
            }
            if (this.r) {
                this.l = object2;
                if (SunJSSE_ax.z != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Resuming " + this.l);
                }
            }
        }
        if (this.l == null) {
            if (!this.s) {
                throw new SSLException("Client did not resume a session");
            }
            this.b(sunJSSE_a4);
            this.l = new SSLSessionImpl(((SunJSSE_ax)this).a, this.p, this.i.a(), ((SunJSSE_ax)this).d.getInetAddress().getHostAddress(), ((SunJSSE_ax)this).d.getPort());
        }
        sunJSSE_a5.d = this.p;
        sunJSSE_a5.c = this.l.d();
        sunJSSE_a5.e = this.l.g();
        if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
            sunJSSE_a5.a(System.out);
            System.out.println("Cipher suite:  " + this.l.e());
        }
        sunJSSE_a5.write(((SunJSSE_ax)this).g);
        if (this.r) {
            this.b(this.l.a());
            this.d(true);
            return;
        }
        if (this.q != SunJSSE_g.K_DH_ANON) {
            if (this.b == null) {
                throw new RuntimeException("no certificates");
            }
            object2 = new HandshakeMessage.CertificateMsg(this.b);
            this.l.b(this.b);
            if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateMsg)object2).a(System.out);
            }
            ((HandshakeMessage)object2).write(((SunJSSE_ax)this).g);
        } else if (this.b != null) {
            throw new RuntimeException("anonymous keyexchange with certs");
        }
        if (this.q == SunJSSE_g.K_RSA) {
            object2 = null;
        } else if (this.q == SunJSSE_g.K_RSA_EXPORT) {
            if (((RSAPrivateKey)this.c).getModulus().bitLength() > 512) {
                try {
                    object2 = new SunJSSE_a8(this.f, this.c, this.j, this.k, this.i.a());
                    this.c = this.e;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    SunJSSE_ax.a("Error generating RSA server key exchange", generalSecurityException);
                    object2 = null;
                }
            } else {
                object2 = null;
            }
        } else if (this.q == SunJSSE_g.K_DHE_DSS || this.q == SunJSSE_g.K_DHE_RSA) {
            try {
                object2 = new HandshakeMessage.DH_ServerKeyExchange(this.g, this.c, this.j.a, this.k.a, this.i.a());
            }
            catch (GeneralSecurityException generalSecurityException) {
                SunJSSE_ax.a("Error generating DH server key exchange", generalSecurityException);
                object2 = null;
            }
        } else if (this.q == SunJSSE_g.K_DH_ANON) {
            object2 = new HandshakeMessage.DH_ServerKeyExchange(this.g);
        } else {
            throw new RuntimeException("internal error: " + this.q);
        }
        if (object2 != null) {
            if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
                ((HandshakeMessage)object2).a(System.out);
            }
            ((HandshakeMessage)object2).write(((SunJSSE_ax)this).g);
        }
        if (this.a != 0 && this.q != SunJSSE_g.K_DH_ANON) {
            X509Certificate[] x509CertificateArray = this.i.c().getAcceptedIssuers();
            object = new SunJSSE_ba(x509CertificateArray, this.q);
            if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
                ((SunJSSE_ba)object).a(System.out);
            }
            ((HandshakeMessage)object).write(((SunJSSE_ax)this).g);
        }
        object = new SunJSSE_bb();
        if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
            ((SunJSSE_bb)object).a(System.out);
        }
        ((HandshakeMessage)object).write(((SunJSSE_ax)this).g);
        ((SunJSSE_ax)this).g.flush();
    }

    private void b(SunJSSE_a4 sunJSSE_a4) throws IOException {
        Iterator iterator = sunJSSE_a4.d.a();
        while (iterator.hasNext()) {
            CipherSuite cipherSuite = (CipherSuite)iterator.next();
            if (!this.c(cipherSuite) || this.a == 2 && cipherSuite.h == SunJSSE_g.K_DH_ANON || !this.a(cipherSuite)) continue;
            return;
        }
        ((SunJSSE_ax)this).d.a((byte)40, "no cipher suites in common");
    }

    private void b(SunJSSE_a7 sunJSSE_a7) throws IOException {
        boolean bl;
        if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
            sunJSSE_a7.a(System.out);
        }
        if (this.a == 2) {
            this.l.getPeerCertificates();
        }
        if (this.d) {
            ((SunJSSE_ax)this).d.a((byte)40, "client did not send certificate verify message");
        }
        if (!(bl = sunJSSE_a7.a(((SunJSSE_ax)this).a, ((SunJSSE_ax)this).e, 1, this.l.a()))) {
            ((SunJSSE_ax)this).d.a((byte)40, "client 'finished' message doesn't verify");
        }
        if (!this.r) {
            ((SunJSSE_ax)this).f.a();
            this.d(false);
        }
        this.l.a(System.currentTimeMillis());
        if (!this.r && this.l.b()) {
            ((SSLSessionContextImpl)this.i.engineGetServerSessionContext()).a(this.l);
            if (SunJSSE_ax.z != null && Debug.isOn("session")) {
                System.out.println("%% Cached server session: " + this.l);
            }
        } else if (!this.r && SunJSSE_ax.z != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable server session: " + this.l);
        }
    }

    private void a(SunJSSE_bc sunJSSE_bc) throws IOException {
        if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
            sunJSSE_bc.a(System.out);
        }
        try {
            PublicKey publicKey = this.l.getPeerCertificates()[0].getPublicKey();
            boolean bl = sunJSSE_bc.a(((SunJSSE_ax)this).a, ((SunJSSE_ax)this).e, publicKey, this.l.a());
            if (!bl) {
                ((SunJSSE_ax)this).d.a((byte)42, "certificate verify message signature error");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            ((SunJSSE_ax)this).d.a((byte)42, "certificate verify format error", generalSecurityException);
        }
        this.d = false;
    }

    private byte[] a(SunJSSE_be sunJSSE_be) throws IOException {
        if (SunJSSE_ax.z != null && Debug.isOn("handshake")) {
            sunJSSE_be.a(System.out);
        }
        return sunJSSE_be.d;
    }

    private boolean a(String string) {
        X509KeyManager x509KeyManager = this.i.b();
        String string2 = x509KeyManager.chooseServerAlias(string, null, ((SunJSSE_ax)this).d);
        if (string2 == null) {
            return false;
        }
        PrivateKey privateKey = x509KeyManager.getPrivateKey(string2);
        if (privateKey == null) {
            return false;
        }
        X509Certificate[] x509CertificateArray = x509KeyManager.getCertificateChain(string2);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return false;
        }
        PublicKey publicKey = x509CertificateArray[0].getPublicKey();
        if (!privateKey.getAlgorithm().equals(string) || !publicKey.getAlgorithm().equals(string)) {
            return false;
        }
        this.c = privateKey;
        this.b = x509CertificateArray;
        return true;
    }

    SunJSSE_aw(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, byte by) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, by != 0, false);
        this.a = by;
    }
}

