/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.WSeedGenerator;
import sun.plugin.usability.Trace;
import sun.security.provider.Sun;

public final class WSecureRandom
extends SecureRandomSpi
implements Serializable {
    private sun.security.provider.SecureRandom spi = null;
    private Sun provider = null;

    public WSecureRandom() {
        byte[] byArray = WSeedGenerator.generateSeed(128);
        SecureRandom secureRandom = null;
        if (byArray == null) {
            Trace.securityPrintln(ResourceHandler.getMessage("crypto.api_failure"));
            this.provider = new Sun();
            try {
                secureRandom = SecureRandom.getInstance("SHA1PRNG", this.provider);
                byArray = secureRandom.generateSeed(20);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        }
        if (byArray != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(byArray);
                byArray = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        } else {
            Trace.securityPrintln(ResourceHandler.getMessage("crypto.seed_failure"));
        }
        this.spi = new sun.security.provider.SecureRandom();
        this.spi.engineSetSeed(byArray);
    }

    public byte[] engineGenerateSeed(int n) {
        return this.spi.engineGenerateSeed(n);
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        this.spi.engineNextBytes(byArray);
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        this.spi.engineSetSeed(byArray);
    }
}

