/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.proxy;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sun.plugin.net.proxy.BrowserProxyInfo;
import sun.plugin.net.proxy.ProxyConfigException;
import sun.plugin.net.proxy.ProxyHandler;
import sun.plugin.net.proxy.ProxyInfo;
import sun.plugin.usability.Trace;

public class ManualProxyHandler
implements ProxyHandler {
    private BrowserProxyInfo bpi = null;
    private List proxyOverridePatterns = null;

    public boolean isProxyCacheSupported() {
        return true;
    }

    public boolean isSupported(int n) {
        return n == 1;
    }

    private boolean isProxyOverriden(String string) {
        Iterator iterator = this.proxyOverridePatterns.iterator();
        while (iterator.hasNext()) {
            Pattern pattern = (Pattern)iterator.next();
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.loading.manual");
        if (!this.isSupported(browserProxyInfo.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + browserProxyInfo.getType());
        }
        this.bpi = browserProxyInfo;
        this.proxyOverridePatterns = new ArrayList();
        String[] stringArray = this.bpi.getOverrides();
        if (stringArray != null) {
            Trace.msgNetPrintln("net.proxy.pattern.convert");
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                String string = stringArray[n];
                try {
                    if (string.equals("<local>")) {
                        this.proxyOverridePatterns.add(Pattern.compile("[^.]+"));
                        Trace.netPrintln("    <local> --> [^.]+");
                    } else {
                        Pattern pattern = this.canonicalizePattern(string);
                        this.proxyOverridePatterns.add(pattern);
                        Trace.netPrintln("    " + string + " --> " + pattern.pattern());
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    patternSyntaxException.printStackTrace();
                    Trace.msgNetPrintln("net.proxy.bypass.convert.error");
                }
                ++n;
            }
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
    }

    private Pattern canonicalizePattern(String string) throws PatternSyntaxException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '*') {
                stringBuffer.append(".*");
            } else {
                stringBuffer.append(Character.toUpperCase(c));
            }
            ++n;
        }
        return Pattern.compile(stringBuffer.toString());
    }

    public ProxyInfo[] getProxyInfo(URL uRL) {
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        if (this.isProxyOverriden(string2.toUpperCase())) {
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
        String string3 = null;
        int n = -1;
        if (string.equals("http")) {
            string3 = this.bpi.getHttpHost();
            n = this.bpi.getHttpPort();
        } else if (string.equals("https")) {
            string3 = this.bpi.getHttpsHost();
            n = this.bpi.getHttpsPort();
        } else if (string.equals("ftp")) {
            string3 = this.bpi.getFtpHost();
            n = this.bpi.getFtpPort();
        } else if (string.equals("gopher")) {
            string3 = this.bpi.getGopherHost();
            n = this.bpi.getGopherPort();
        }
        return new ProxyInfo[]{new ProxyInfo(string3, n, this.bpi.getSocksHost(), this.bpi.getSocksPort())};
    }
}

