/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.plugin.cache.JarCacheTableCellRenderer;
import sun.plugin.cache.JarCacheTableColumn;
import sun.plugin.cache.JarCacheTableColumnModel;
import sun.plugin.cache.JarCacheTableHeaderRenderer;
import sun.plugin.cache.JarCacheTableSorter;

public class JarCacheTable
extends JTable {
    public static final Font tableFont = new Font("Dialog", 0, 10);
    private final Color shadeColor = new Color(232, 232, 232);
    private DefaultTableCellRenderer tableCellRenderer = new JarCacheTableCellRenderer(tableFont, this.shadeColor);
    private JarCacheTableColumnModel tableColumnModel = new JarCacheTableColumnModel();
    private JarCacheTableColumn[] tableColumns = null;
    private JarCacheTableSorter sorter = null;
    private String[] colNames = null;

    public JarCacheTable() {
        this.sizeColumnsToFit(3);
        this.setAutoResizeMode(0);
        this.setColumnModel(this.tableColumnModel);
        this.tableColumns = this.tableColumnModel.getColumnArray();
        this.colNames = new String[this.tableColumns.length];
        int n = 0;
        while (n < this.tableColumns.length) {
            this.colNames[n] = this.tableColumns[n].getHeaderValue().toString();
            ++n;
        }
        this.sorter = new JarCacheTableSorter(this.colNames);
        this.sorter.addMouseListenerToHeaderInTable(this);
        this.setModel(this.sorter);
        int n2 = this.tableColumnModel.getColumnCount();
        TableColumn tableColumn = null;
        int n3 = 0;
        while (n3 < n2) {
            tableColumn = this.columnModel.getColumn(n3);
            if (this.tableColumns[n3].isVisible()) {
                tableColumn.setMinWidth(this.tableColumns[n3].getMinWidth());
                tableColumn.setPreferredWidth(this.tableColumns[n3].getPreferredWidth());
                tableColumn.setResizable(this.tableColumns[n3].getResizable());
            } else {
                tableColumn.setMinWidth(0);
                tableColumn.setMaxWidth(0);
            }
            ++n3;
        }
        this.setHeaderRenderers();
        ActionListener actionListener = new ActionListener(this){
            private final JarCacheTable this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.removeRows();
            }
            {
                this.this$0 = jarCacheTable;
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(127, 0), 2);
        this.getTableHeader().setReorderingAllowed(false);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public void refresh() {
        this.sorter.refresh();
    }

    public void removeRows() {
        this.sorter.removeRows(this.getSelectedRows());
    }

    public void setHeaderRenderers() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            tableColumnModel.getColumn(n2).setHeaderRenderer(new JarCacheTableHeaderRenderer());
            ++n2;
        }
    }

    public void adjustColumnSize(Container container) {
        int n = this.tableColumnModel.getColumnCount();
        int n2 = 0;
        int n3 = 0;
        TableColumn tableColumn = null;
        int n4 = 0;
        while (n4 < n - 1) {
            tableColumn = this.columnModel.getColumn(n4);
            if (this.tableColumns[n4].isVisible()) {
                n2 += this.tableColumns[n4].getWidth();
                n3 += tableColumn.getPreferredWidth();
            }
            ++n4;
        }
        n3 = n2;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        tableColumn = this.columnModel.getColumn(n - 1);
        int n5 = (int)(dimension.getWidth() - (double)n3 - (double)insets.left - (double)insets.right - 3.0);
        tableColumn.setPreferredWidth(n5);
    }

    public Font getFont() {
        return tableFont;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.tableCellRenderer;
    }

    public JarCacheTableColumn[] getJarCacheTableColumns() {
        return this.tableColumns;
    }

    public JarCacheTableColumnModel getJarCacheTableColumnModel() {
        return this.tableColumnModel;
    }
}

