/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

public class Privilege {
    public static final int N_PERMISSIONS = 15;
    public static final int FORBIDDEN = 0;
    public static final int ALLOWED = 1;
    public static final int BLANK = 2;
    public static final int N_DURATIONS = 240;
    public static final int SCOPE = 16;
    public static final int SESSION = 32;
    public static final int FOREVER = 64;
    private int permission = 0;
    private int duration = 16;

    public int getDuration() {
        return this.duration;
    }

    public int getPermission() {
        return this.permission;
    }

    public boolean isAllowed() {
        return this.permission == 1;
    }

    public boolean isBlank() {
        return this.permission == 2;
    }

    public boolean isForbidden() {
        return this.permission == 0;
    }

    public boolean sameDuration(int n) {
        return this.duration == n;
    }

    public boolean samePermission(int n) {
        return this.permission == n;
    }

    public static int add(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == 2) {
            return n2;
        }
        if (n2 == 2) {
            return n;
        }
        if (n == 1 || n2 == 1) {
            return 1;
        }
        return 2;
    }

    Privilege(int n, int n2) {
        this.permission = n;
        this.duration = n2;
    }

    public boolean equals(Object object) {
        if (object instanceof Privilege) {
            Privilege privilege = (Privilege)object;
            return this.permission == privilege.getPermission() && this.duration == privilege.getDuration();
        }
        return false;
    }

    public static Privilege findPrivilege(int n, int n2) {
        return new Privilege(n, n2);
    }

    public boolean sameDuration(Privilege privilege) {
        return this.sameDuration(privilege.getDuration());
    }

    public boolean samePermission(Privilege privilege) {
        return this.samePermission(privilege.getPermission());
    }

    public static Privilege add(Privilege privilege, Privilege privilege2) {
        int n = Privilege.add(privilege.getPermission(), privilege2.getPermission());
        return new Privilege(n, privilege.getDuration());
    }
}

