/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Vector;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.DNSName;
import sun.security.x509.EDIPartyName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralSubtree;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.OtherName;
import sun.security.x509.RFC822Name;
import sun.security.x509.URIName;
import sun.security.x509.X400Address;
import sun.security.x509.X500Name;

public class GeneralSubtrees
extends Vector {
    private static final int NAME_DIFF_TYPE = -1;
    private static final int NAME_MATCH = 0;
    private static final int NAME_NARROWS = 1;
    private static final int NAME_WIDENS = 2;
    private static final int NAME_SAME_TYPE = 3;

    public GeneralSubtrees() {
        super(1, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void minimize() throws IOException {
        int n2 = 0;
        while (n2 < super.size()) {
            GeneralNameInterface generalNameInterface = this.getGeneralNameInterface(n2);
            boolean bl2 = false;
            int n3 = n2 + 1;
            while (n3 < super.size()) {
                block10: {
                    GeneralNameInterface generalNameInterface2 = this.getGeneralNameInterface(n3);
                    switch (generalNameInterface.constrains(generalNameInterface2)) {
                        case -1: {
                            break block10;
                        }
                        case 0: {
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            super.remove(n3);
                            --n3;
                            break block10;
                        }
                        case 2: {
                            bl2 = true;
                            break;
                        }
                        case 3: {
                            break block10;
                        }
                    }
                    break;
                }
                ++n3;
            }
            if (bl2) {
                super.remove(n2);
                --n2;
            }
            ++n2;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeneralSubtrees)) {
            return false;
        }
        int n2 = this.size();
        GeneralSubtrees generalSubtrees = (GeneralSubtrees)object;
        if (generalSubtrees.size() != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!generalSubtrees.elementAt(n3).equals(this.elementAt(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public String toString() {
        String string = "   GeneralSubtrees:\n" + super.toString() + "\n";
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n2 = 0;
        while (n2 < this.size()) {
            ((GeneralSubtree)this.elementAt(n2)).encode(derOutputStream2);
            ++n2;
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    /*
     * Unable to fully structure code
     */
    public GeneralSubtrees(DerValue var1_1) throws IOException {
        super();
        if (var1_1.tag == 48) ** GOTO lbl7
        throw new IOException("Invalid encoding of GeneralSubtrees.");
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.data.getDerValue();
            var3_3 = new GeneralSubtree(var2_2);
            this.addElement(var3_3);
lbl7:
            // 2 sources

            ** while (var1_1.data.available() != 0)
        }
lbl8:
        // 1 sources

    }

    private GeneralNameInterface getGeneralNameInterface(int n2) {
        GeneralSubtree generalSubtree = (GeneralSubtree)super.get(n2);
        GeneralName generalName = generalSubtree.getName();
        GeneralNameInterface generalNameInterface = generalName.getName();
        return generalNameInterface;
    }

    public void reduce(GeneralSubtrees generalSubtrees) throws IOException {
        if (generalSubtrees != null) {
            int n2 = 0;
            while (n2 < generalSubtrees.size()) {
                GeneralSubtree generalSubtree = (GeneralSubtree)generalSubtrees.get(n2);
                GeneralName generalName = generalSubtree.getName();
                GeneralNameInterface generalNameInterface = generalName.getName();
                int n3 = 0;
                while (n3 < super.size()) {
                    GeneralSubtree generalSubtree2 = (GeneralSubtree)super.get(n3);
                    GeneralName generalName2 = generalSubtree2.getName();
                    GeneralNameInterface generalNameInterface2 = generalName2.getName();
                    switch (generalNameInterface.constrains(generalNameInterface2)) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            super.remove(n3);
                            --n3;
                            break;
                        }
                        case 1: {
                            super.remove(n3);
                            --n3;
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    public void union(GeneralSubtrees generalSubtrees) throws IOException {
        if (generalSubtrees != null) {
            int n2 = 0;
            while (n2 < generalSubtrees.size()) {
                super.add(generalSubtrees.get(n2));
                ++n2;
            }
            this.minimize();
        }
    }

    private GeneralSubtree createWidestSubtree(GeneralNameInterface generalNameInterface) throws IOException {
        GeneralName generalName = null;
        switch (generalNameInterface.getType()) {
            case 0: {
                ObjectIdentifier objectIdentifier = ((OtherName)generalNameInterface).getOID();
                generalName = new GeneralName(new OtherName(objectIdentifier, null));
                break;
            }
            case 1: {
                generalName = new GeneralName(new RFC822Name(""));
                break;
            }
            case 2: {
                generalName = new GeneralName(new DNSName(""));
                break;
            }
            case 3: {
                generalName = new GeneralName(new X400Address((byte[])null));
                break;
            }
            case 4: {
                generalName = new GeneralName(new X500Name(""));
                break;
            }
            case 5: {
                generalName = new GeneralName(new EDIPartyName(""));
                break;
            }
            case 6: {
                generalName = new GeneralName(new URIName(""));
                break;
            }
            case 7: {
                generalName = new GeneralName(new IPAddressName((byte[])null));
                break;
            }
            case 8: {
                generalName = new GeneralName(new OIDName(new ObjectIdentifier((int[])null)));
                break;
            }
            default: {
                throw new IOException("Unsupported GeneralNameInterface type: " + generalNameInterface.getType());
            }
        }
        return new GeneralSubtree(generalName, 0, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public GeneralSubtrees intersect(GeneralSubtrees generalSubtrees) throws IOException {
        Object object;
        Object object2;
        int n2;
        boolean bl2;
        GeneralNameInterface generalNameInterface;
        Object object3;
        if (generalSubtrees == null) {
            throw new IOException("other GeneralSubtrees must not be null");
        }
        GeneralSubtrees generalSubtrees2 = new GeneralSubtrees();
        GeneralSubtrees generalSubtrees3 = null;
        if (super.size() == 0) {
            this.union(generalSubtrees);
            return null;
        }
        this.minimize();
        generalSubtrees.minimize();
        int n3 = 0;
        while (n3 < super.size()) {
            Object object4;
            GeneralSubtree generalSubtree = (GeneralSubtree)super.get(n3);
            object3 = generalSubtree.getName();
            generalNameInterface = ((GeneralName)object3).getName();
            bl2 = false;
            n2 = 0;
            int n4 = 0;
            block10: while (n4 < generalSubtrees.size()) {
                object2 = (GeneralSubtree)generalSubtrees.get(n4);
                object = ((GeneralSubtree)object2).getName();
                object4 = ((GeneralName)object).getName();
                switch (generalNameInterface.constrains((GeneralNameInterface)object4)) {
                    case 1: {
                        super.remove(n3);
                        --n3;
                        generalSubtrees2.add(object2);
                        n2 = 0;
                        break block10;
                    }
                    case 3: {
                        n2 = 1;
                        break;
                    }
                    case 0: 
                    case 2: {
                        n2 = 0;
                        break block10;
                    }
                }
                ++n4;
            }
            if (n2 != 0) {
                boolean bl3 = false;
                int n5 = 0;
                while (n5 < super.size()) {
                    object4 = (GeneralSubtree)super.get(n5);
                    GeneralName generalName = ((GeneralSubtree)object4).getName();
                    GeneralNameInterface generalNameInterface2 = generalName.getName();
                    if (generalNameInterface2.getType() == generalNameInterface.getType()) {
                        int n6 = 0;
                        while (n6 < generalSubtrees.size()) {
                            GeneralSubtree generalSubtree2 = (GeneralSubtree)generalSubtrees.get(n6);
                            GeneralName generalName2 = generalSubtree2.getName();
                            GeneralNameInterface generalNameInterface3 = generalName2.getName();
                            int n7 = generalNameInterface2.constrains(generalNameInterface3);
                            if (n7 == 0 || n7 == 2 || n7 == 1) {
                                bl3 = true;
                                break;
                            }
                            ++n6;
                        }
                    }
                    ++n5;
                }
                if (!bl3) {
                    if (generalSubtrees3 == null) {
                        generalSubtrees3 = new GeneralSubtrees();
                    }
                    if (!generalSubtrees3.contains(object4 = this.createWidestSubtree(generalNameInterface))) {
                        generalSubtrees3.add(object4);
                    }
                }
                super.remove(n3);
                --n3;
            }
            ++n3;
        }
        if (generalSubtrees2.size() > 0) {
            this.union(generalSubtrees2);
        }
        int n8 = 0;
        while (n8 < generalSubtrees.size()) {
            object3 = (GeneralSubtree)generalSubtrees.get(n8);
            generalNameInterface = ((GeneralSubtree)object3).getName().getName();
            bl2 = false;
            n2 = 0;
            block14: while (n2 < super.size()) {
                GeneralSubtree generalSubtree = (GeneralSubtree)super.get(n2);
                object2 = generalSubtree.getName();
                object = ((GeneralName)object2).getName();
                switch (object.constrains(generalNameInterface)) {
                    case -1: {
                        bl2 = true;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        bl2 = false;
                        break block14;
                    }
                }
                ++n2;
            }
            if (bl2) {
                super.add(object3);
            }
            ++n8;
        }
        return generalSubtrees3;
    }
}

