/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;

public class CertificateExtensions
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions";
    public static final String NAME = "extensions";
    private Hashtable map = new Hashtable(11);
    private boolean unsupportedCritExt = false;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Object;

    public int hashCode() {
        return this.map.hashCode();
    }

    public CertificateExtensions() {
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public void decode(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.init(derValue.data);
    }

    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl2) throws CertificateException, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        Collection collection = this.map.values();
        Object[] objectArray = collection.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof CertAttrSet) {
                ((CertAttrSet)objectArray[n2]).encode(derOutputStream2);
            } else if (objectArray[n2] instanceof Extension) {
                ((Extension)objectArray[n2]).encode(derOutputStream2);
            } else {
                throw new CertificateException("Illegal extension object");
            }
            ++n2;
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        if (!bl2) {
            derOutputStream = new DerOutputStream();
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream3);
        } else {
            derOutputStream = derOutputStream3;
        }
        outputStream.write(derOutputStream.toByteArray());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CertificateExtensions)) {
            return false;
        }
        Collection collection = ((CertificateExtensions)object).getAllExtensions();
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        if (n2 != this.map.size()) {
            return false;
        }
        String string = null;
        int n3 = 0;
        while (n3 < n2) {
            Extension extension;
            if (objectArray[n3] instanceof CertAttrSet) {
                string = ((CertAttrSet)objectArray[n3]).getName();
            }
            Extension extension2 = (Extension)objectArray[n3];
            if (string == null) {
                string = extension2.getExtensionId().toString();
            }
            if ((extension = (Extension)this.map.get(string)) == null) {
                return false;
            }
            if (!extension.equals(extension2)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return this.map.toString();
    }

    public void delete(String string) throws IOException {
        Object object = this.map.get(string);
        if (object == null) {
            throw new IOException("No extension found with name " + string);
        }
        this.map.remove(string);
    }

    public Collection getAllExtensions() {
        return this.map.values();
    }

    public Enumeration getElements() {
        return this.map.elements();
    }

    public CertificateExtensions(DerInputStream derInputStream) throws IOException {
        this.init(derInputStream);
    }

    private void init(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSequence(5);
        int n2 = 0;
        while (n2 < derValueArray.length) {
            Extension extension = new Extension(derValueArray[n2]);
            this.parseExtension(extension);
            ++n2;
        }
    }

    private void parseExtension(Extension extension) throws IOException {
        try {
            Class clazz = OIDMap.getClass(extension.getExtensionId());
            if (clazz == null) {
                if (extension.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(extension.getExtensionId().toString(), extension) == null) {
                    return;
                }
                throw new IOException("Duplicate extensions not allowed");
            }
            Class[] classArray = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = CertificateExtensions.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = CertificateExtensions.class$("java.lang.Object")) : class$java$lang$Object};
            Constructor constructor = clazz.getConstructor(classArray);
            byte[] byArray = extension.getExtensionValue();
            int n2 = byArray.length;
            Object object = Array.newInstance(Byte.TYPE, n2);
            int n3 = 0;
            while (n3 < n2) {
                Array.setByte(object, n3, byArray[n3]);
                ++n3;
            }
            Object[] objectArray = new Object[]{new Boolean(extension.isCritical()), object};
            CertAttrSet certAttrSet = (CertAttrSet)constructor.newInstance(objectArray);
            if (this.map.put(certAttrSet.getName(), certAttrSet) != null) {
                throw new IOException("Duplicate extensions not allowed");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException(invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object get(String string) throws IOException {
        Object object = this.map.get(string);
        if (object == null) {
            throw new IOException("No extension found with name " + string);
        }
        return object;
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Extension)) {
            throw new IOException("Unknown extension type.");
        }
        this.map.put(string, object);
    }
}

