/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.jgss.krb5.MessageToken;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbException;

class WrapToken
extends MessageToken {
    public static int CONFOUNDER_SIZE = 8;
    private static byte[][] pads = new byte[][]{null, {1}, {2, 2}, {3, 3, 3}, {4, 4, 4, 4}, {5, 5, 5, 5, 5}, {6, 6, 6, 6, 6, 6}, {7, 7, 7, 7, 7, 7, 7}, {8, 8, 8, 8, 8, 8, 8, 8}};
    private boolean readTokenFromInputStream = true;
    private InputStream is = null;
    private byte[] tokenBytes = null;
    private int tokenOffset = 0;
    private int tokenLen = 0;
    private byte[] dataBytes = null;
    private int dataOffset = 0;
    private int dataLen = 0;
    private int dataSize = 0;
    private byte[] encKey = null;
    private byte[] confounder = null;
    private byte[] padding = null;
    private boolean privacy = false;

    protected int getKrb5TokenSize() {
        return super.getKrb5TokenSize() + this.dataSize;
    }

    public byte[] encode() throws IOException, GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.dataSize + 50);
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getData() throws GSSException {
        byte[] byArray = new byte[this.dataSize];
        this.getData(byArray, 0);
        byte[] byArray2 = new byte[this.dataSize - this.confounder.length - this.padding.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private byte[] getPadding(int n2) {
        int n3 = n2 % 8;
        n3 = 8 - n3;
        return pads[n3];
    }

    static int getSizeLimit(int n2, boolean bl2, int n3) {
        return GSSHeader.getMaxMechTokenSize(Krb5Token.OID, n3) - (24 + CONFOUNDER_SIZE) - 8;
    }

    protected int getSealAlg(boolean bl2) {
        return bl2 ? 0 : 65535;
    }

    private byte[] getEncryptionKey(byte[] byArray) throws GSSException {
        if (byArray.length > 8) {
            throw new GSSException(11, -100, "Invalid DES Key!");
        }
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray2[n2] = (byte)(byArray[n2] ^ 0xF0);
            ++n2;
        }
        return byArray2;
    }

    public int encode(byte[] byArray, int n2) throws IOException, GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.encode(byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        n2 += byArray2.length;
        if (!this.privacy) {
            System.arraycopy(this.confounder, 0, byArray, n2, this.confounder.length);
            System.arraycopy(this.dataBytes, this.dataOffset, byArray, n2 += this.confounder.length, this.dataLen);
            System.arraycopy(this.padding, 0, byArray, n2 += this.dataLen, this.padding.length);
        } else {
            int n3 = n2;
            this.encKey = this.getEncryptionKey(this.getContextKey());
            Cipher cipher = this.getInitializedDes(true, this.encKey, MessageToken.ZERO_IV);
            try {
                n3 += cipher.update(this.confounder, 0, this.confounder.length, byArray, n3);
                n3 += cipher.update(this.dataBytes, this.dataOffset, this.dataLen, byArray, n3);
                cipher.update(this.padding, 0, this.padding.length, byArray, n3);
                cipher.doFinal();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new GSSException(11, -1, "Could not use DES Cipher - " + generalSecurityException.getMessage());
            }
        }
        return byArray2.length + this.confounder.length + this.dataLen + this.padding.length;
    }

    public int getData(byte[] byArray, int n2) throws GSSException {
        if (this.readTokenFromInputStream) {
            this.getDataFromStream(byArray, n2);
        } else {
            this.getDataFromBuffer(byArray, n2);
        }
        return this.dataSize - this.confounder.length - this.padding.length;
    }

    private void getDataFromBuffer(byte[] byArray, int n2) throws GSSException {
        GSSHeader gSSHeader = this.getGSSHeader();
        int n3 = this.tokenOffset + gSSHeader.getLength() + 24;
        if (n3 + this.dataSize > this.tokenOffset + this.tokenLen) {
            throw new GSSException(10, -1, "Insufficient data in " + Krb5Token.getTokenName(this.getTokenId()));
        }
        this.confounder = new byte[CONFOUNDER_SIZE];
        if (this.privacy) {
            this.encKey = this.getEncryptionKey(this.getContextKey());
            this.desCbcDecrypt(this.encKey, this.tokenBytes, n3, this.dataSize, byArray, n2);
        } else {
            System.arraycopy(this.tokenBytes, n3, this.confounder, 0, CONFOUNDER_SIZE);
            int n4 = this.tokenBytes[n3 + this.dataSize - 1];
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > 8) {
                n4 %= 8;
            }
            this.padding = pads[n4];
            System.arraycopy(this.tokenBytes, n3 + CONFOUNDER_SIZE, byArray, n2, this.dataSize - CONFOUNDER_SIZE - n4);
        }
        if (!this.verifySignAndSeqNumber(this.confounder, byArray, n2, this.dataSize - CONFOUNDER_SIZE - this.padding.length, this.padding)) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in Wrap token");
        }
    }

    private void getDataFromStream(byte[] byArray, int n2) throws GSSException {
        GSSHeader gSSHeader = this.getGSSHeader();
        this.confounder = new byte[CONFOUNDER_SIZE];
        try {
            if (this.privacy) {
                this.encKey = this.getEncryptionKey(this.getContextKey());
                this.desCbcDecrypt(this.encKey, this.is, this.dataSize, byArray, n2);
            } else {
                Krb5Token.readFully(this.is, this.confounder);
                int n3 = (this.dataSize - CONFOUNDER_SIZE) / 8 - 1;
                int n4 = n2;
                int n5 = 0;
                while (n5 < n3) {
                    Krb5Token.readFully(this.is, byArray, n4, 8);
                    n4 += 8;
                    ++n5;
                }
                byte[] byArray2 = new byte[8];
                Krb5Token.readFully(this.is, byArray2);
                byte by = byArray2[7];
                this.padding = pads[by];
                System.arraycopy(byArray2, 0, byArray, n4, byArray2.length - by);
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, Krb5Token.getTokenName(this.getTokenId()) + ": " + iOException.getMessage());
        }
        if (!this.verifySignAndSeqNumber(this.confounder, byArray, n2, this.dataSize - CONFOUNDER_SIZE - this.padding.length, this.padding)) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in Wrap token");
        }
    }

    private void desCbcDecrypt(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) throws GSSException {
        try {
            int n5 = 0;
            Cipher cipher = this.getInitializedDes(false, byArray, MessageToken.ZERO_IV);
            n5 = cipher.update(byArray2, n2, CONFOUNDER_SIZE, this.confounder);
            n2 += CONFOUNDER_SIZE;
            int n6 = cipher.getBlockSize();
            int n7 = (n3 -= CONFOUNDER_SIZE) / n6 - 1;
            int n8 = 0;
            while (n8 < n7) {
                n5 = cipher.update(byArray2, n2, n6, byArray3, n4);
                n2 += n6;
                n4 += n6;
                ++n8;
            }
            byte[] byArray4 = new byte[n6];
            cipher.update(byArray2, n2, n6, byArray4);
            cipher.doFinal();
            byte by = byArray4[n6 - 1];
            this.padding = pads[by];
            System.arraycopy(byArray4, 0, byArray3, n4, n6 -= by);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(11, -1, "Could not use DES cipher - " + generalSecurityException.getMessage());
        }
    }

    private void desCbcDecrypt(byte[] byArray, InputStream inputStream, int n2, byte[] byArray2, int n3) throws GSSException, IOException {
        int n4 = 0;
        Cipher cipher = this.getInitializedDes(false, byArray, MessageToken.ZERO_IV);
        WrapTokenInputStream wrapTokenInputStream = new WrapTokenInputStream(this, inputStream, n2);
        CipherInputStream cipherInputStream = new CipherInputStream(wrapTokenInputStream, cipher);
        n4 = cipherInputStream.read(this.confounder);
        int n5 = cipher.getBlockSize();
        int n6 = (n2 -= n4) / n5 - 1;
        int n7 = 0;
        while (n7 < n6) {
            n4 = cipherInputStream.read(byArray2, n3, n5);
            n3 += n5;
            ++n7;
        }
        byte[] byArray3 = new byte[n5];
        n4 = cipherInputStream.read(byArray3);
        try {
            cipher.doFinal();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(11, -1, "Could not use DES cipher - " + generalSecurityException.getMessage());
        }
        byte by = byArray3[n5 - 1];
        if (by < 1 || by > 8) {
            throw new GSSException(10, -1, "Invalid padding on Wrap Token");
        }
        this.padding = pads[by];
        System.arraycopy(byArray3, 0, byArray2, n3, n5 -= by);
    }

    public void encode(OutputStream outputStream) throws IOException, GSSException {
        super.encode(outputStream);
        if (!this.privacy) {
            outputStream.write(this.confounder);
            outputStream.write(this.dataBytes, this.dataOffset, this.dataLen);
            outputStream.write(this.padding);
        } else {
            this.encKey = this.getEncryptionKey(this.getContextKey());
            Cipher cipher = this.getInitializedDes(true, this.encKey, MessageToken.ZERO_IV);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            cipherOutputStream.write(this.confounder);
            cipherOutputStream.write(this.dataBytes, this.dataOffset, this.dataLen);
            cipherOutputStream.write(this.padding);
        }
    }

    public WrapToken(Krb5Context krb5Context, MessageProp messageProp, byte[] byArray, int n2, int n3) throws GSSException {
        super(513, krb5Context);
        try {
            new Confounder();
            this.confounder = Confounder.bytes(CONFOUNDER_SIZE);
        }
        catch (KrbException krbException) {
            throw new GSSException(11, -1, krbException.getMessage());
        }
        this.padding = this.getPadding(n3);
        this.dataSize = this.confounder.length + n3 + this.padding.length;
        this.dataBytes = byArray;
        this.dataOffset = n2;
        this.dataLen = n3;
        this.genSignAndSeqNumber(messageProp, this.confounder, byArray, n2, n3, this.padding);
        if (!krb5Context.getConfState()) {
            messageProp.setPrivacy(false);
        }
        this.privacy = messageProp.getPrivacy();
    }

    public WrapToken(Krb5Context krb5Context, byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        super(513, krb5Context, byArray, n2, n3, messageProp);
        this.readTokenFromInputStream = false;
        this.tokenBytes = byArray;
        this.tokenOffset = n2;
        this.tokenLen = n3;
        this.privacy = messageProp.getPrivacy();
        this.dataSize = this.getGSSHeader().getMechTokenLength() - 24;
    }

    public WrapToken(Krb5Context krb5Context, InputStream inputStream, MessageProp messageProp) throws GSSException {
        super(513, krb5Context, inputStream, messageProp);
        this.is = inputStream;
        this.privacy = messageProp.getPrivacy();
        this.dataSize = this.getGSSHeader().getMechTokenLength() - 24;
    }

    class WrapTokenInputStream
    extends InputStream {
        private InputStream is;
        private int length;
        private int remaining;
        private int temp;
        private final WrapToken this$0;

        public final int available() throws IOException {
            return Math.min(this.remaining, this.is.available());
        }

        public final int read() throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = this.is.read();
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        public final void close() throws IOException {
            this.remaining = 0;
        }

        public final long skip(long l2) throws IOException {
            if (this.remaining == 0) {
                return 0L;
            }
            this.temp = (int)Math.min((long)this.remaining, l2);
            this.temp = (int)this.is.skip(this.temp);
            this.remaining -= this.temp;
            return this.temp;
        }

        public final int read(byte[] byArray) throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = Math.min(this.remaining, byArray.length);
            this.temp = this.is.read(byArray, 0, this.temp);
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        public final int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = Math.min(this.remaining, n3);
            this.temp = this.is.read(byArray, n2, this.temp);
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        public WrapTokenInputStream(WrapToken wrapToken, InputStream inputStream, int n2) {
            this.this$0 = wrapToken;
            this.is = inputStream;
            this.length = n2;
            this.remaining = n2;
        }
    }
}

