/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.rmi.runtime.Log;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCClient;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LiveRef;

class ConnectionInputStream
extends MarshalInputStream {
    private boolean dgcAckNeeded = false;
    private Map incomingRefTable = new HashMap(5);
    private UID ackID;

    void readID() throws IOException {
        this.ackID = UID.read(this);
    }

    void registerRefs() throws IOException {
        if (!this.incomingRefTable.isEmpty()) {
            Set set = this.incomingRefTable.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Endpoint endpoint = (Endpoint)entry.getKey();
                List list = (List)entry.getValue();
                DGCClient.registerRefs(endpoint, list);
            }
        }
    }

    void setAckNeeded() {
        this.dgcAckNeeded = true;
    }

    ConnectionInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    void done(Connection connection) {
        block7: {
            if (!this.dgcAckNeeded) break block7;
            Connection connection2 = null;
            Channel channel = null;
            boolean bl2 = true;
            DGCImpl.dgcLog.log(Log.VERBOSE, "send ack");
            try {
                channel = connection.getChannel();
                connection2 = channel.newConnection();
                DataOutputStream dataOutputStream = new DataOutputStream(connection2.getOutputStream());
                dataOutputStream.writeByte(84);
                if (this.ackID == null) {
                    this.ackID = new UID();
                }
                this.ackID.write(dataOutputStream);
                connection2.releaseOutputStream();
                connection2.getInputStream().available();
                connection2.releaseInputStream();
            }
            catch (RemoteException remoteException) {
                bl2 = false;
            }
            catch (IOException iOException) {
                bl2 = false;
            }
            try {
                if (connection2 != null) {
                    channel.free(connection2, bl2);
                }
            }
            catch (RemoteException remoteException) {}
        }
    }

    void saveRef(LiveRef liveRef) {
        Endpoint endpoint = liveRef.getEndpoint();
        List list = (List)this.incomingRefTable.get(endpoint);
        if (list == null) {
            list = new ArrayList();
            this.incomingRefTable.put(endpoint, list);
        }
        list.add(liveRef);
    }
}

