/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import sun.reflect.ByteVector;
import sun.reflect.ByteVectorFactory;
import sun.reflect.ClassFileConstants;
import sun.reflect.Label;
import sun.reflect.UTF8;

class ClassFileAssembler
implements ClassFileConstants {
    private ByteVector vec;
    private short cpIdx = 0;
    private int stack = 0;
    private int maxStack = 0;
    private int maxLocals = 0;

    public int getStack() {
        return this.stack;
    }

    public short cpi() {
        if (this.cpIdx == 0) {
            throw new RuntimeException("Illegal use of ClassFileAssembler");
        }
        return this.cpIdx;
    }

    public short getLength() {
        return (short)this.vec.getLength();
    }

    public short getMaxLocals() {
        return (short)this.maxLocals;
    }

    public short getMaxStack() {
        return (short)this.maxStack;
    }

    public ClassFileAssembler() {
        this(ByteVectorFactory.create());
    }

    private void decStack() {
        --this.stack;
    }

    public void emitMagicAndVersion() {
        this.emitInt(-889275714);
        this.emitShort((short)0);
        this.emitShort((short)46);
    }

    private void incStack() {
        this.setStack(this.stack + 1);
    }

    public void opc_aaload() {
        this.emitByte((byte)50);
        this.decStack();
    }

    public void opc_aconst_null() {
        this.emitByte((byte)1);
        this.incStack();
    }

    public void opc_aload_0() {
        this.emitByte((byte)42);
        if (this.maxLocals < 1) {
            this.maxLocals = 1;
        }
        this.incStack();
    }

    public void opc_aload_1() {
        this.emitByte((byte)43);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
    }

    public void opc_aload_2() {
        this.emitByte((byte)44);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
    }

    public void opc_aload_3() {
        this.emitByte((byte)45);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
    }

    public void opc_areturn() {
        this.emitByte((byte)-80);
        this.setStack(0);
    }

    public void opc_arraylength() {
        this.emitByte((byte)-66);
    }

    public void opc_astore_0() {
        this.emitByte((byte)75);
        if (this.maxLocals < 1) {
            this.maxLocals = 1;
        }
        this.decStack();
    }

    public void opc_astore_1() {
        this.emitByte((byte)76);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.decStack();
    }

    public void opc_astore_2() {
        this.emitByte((byte)77);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.decStack();
    }

    public void opc_astore_3() {
        this.emitByte((byte)78);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.decStack();
    }

    public void opc_athrow() {
        this.emitByte((byte)-65);
        this.setStack(1);
    }

    public void opc_dload_0() {
        this.emitByte((byte)38);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_dload_1() {
        this.emitByte((byte)39);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_dload_2() {
        this.emitByte((byte)40);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_dload_3() {
        this.emitByte((byte)41);
        if (this.maxLocals < 5) {
            this.maxLocals = 5;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_dreturn() {
        this.emitByte((byte)-81);
        this.setStack(0);
    }

    public void opc_dup() {
        this.emitByte((byte)89);
        this.incStack();
    }

    public void opc_dup_x1() {
        this.emitByte((byte)90);
        this.incStack();
    }

    public void opc_f2d() {
        this.emitByte((byte)-115);
    }

    public void opc_fload_0() {
        this.emitByte((byte)34);
        if (this.maxLocals < 1) {
            this.maxLocals = 1;
        }
        this.incStack();
    }

    public void opc_fload_1() {
        this.emitByte((byte)35);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
    }

    public void opc_fload_2() {
        this.emitByte((byte)36);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
    }

    public void opc_fload_3() {
        this.emitByte((byte)37);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
    }

    public void opc_freturn() {
        this.emitByte((byte)-82);
        this.setStack(0);
    }

    public void opc_i2d() {
        this.emitByte((byte)-121);
    }

    public void opc_i2f() {
        this.emitByte((byte)-122);
    }

    public void opc_i2l() {
        this.emitByte((byte)-123);
    }

    public void opc_iload_0() {
        this.emitByte((byte)26);
        if (this.maxLocals < 1) {
            this.maxLocals = 1;
        }
        this.incStack();
    }

    public void opc_iload_1() {
        this.emitByte((byte)27);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
    }

    public void opc_iload_2() {
        this.emitByte((byte)28);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
    }

    public void opc_iload_3() {
        this.emitByte((byte)29);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
    }

    public void opc_ireturn() {
        this.emitByte((byte)-84);
        this.setStack(0);
    }

    public void opc_l2d() {
        this.emitByte((byte)-118);
    }

    public void opc_l2f() {
        this.emitByte((byte)-119);
    }

    public void opc_lload_0() {
        this.emitByte((byte)30);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_lload_1() {
        this.emitByte((byte)31);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_lload_2() {
        this.emitByte((byte)32);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_lload_3() {
        this.emitByte((byte)33);
        if (this.maxLocals < 5) {
            this.maxLocals = 5;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_lreturn() {
        this.emitByte((byte)-83);
        this.setStack(0);
    }

    public void opc_pop() {
        this.emitByte((byte)87);
        this.decStack();
    }

    public void opc_return() {
        this.emitByte((byte)-79);
        this.setStack(0);
    }

    public void opc_swap() {
        this.emitByte((byte)95);
    }

    public void emitByte(byte by) {
        this.vec.add(by);
    }

    public void opc_ldc(byte by) {
        this.emitByte((byte)18);
        this.emitByte(by);
        this.incStack();
    }

    public void emitInt(int n2) {
        this.emitByte((byte)(n2 >> 24));
        this.emitByte((byte)(n2 >> 16 & 0xFF));
        this.emitByte((byte)(n2 >> 8 & 0xFF));
        this.emitByte((byte)(n2 & 0xFF));
    }

    public void setMaxLocals(int n2) {
        this.maxLocals = n2;
    }

    public void setStack(int n2) {
        this.stack = n2;
        if (this.stack > this.maxStack) {
            this.maxStack = this.stack;
        }
    }

    public void emitConstantPoolClass(short s2) {
        this.emitByte((byte)7);
        this.emitShort(s2);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolString(short s2) {
        this.emitByte((byte)8);
        this.emitShort(s2);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitShort(short s2) {
        this.emitByte((byte)(s2 >> 8 & 0xFF));
        this.emitByte((byte)(s2 & 0xFF));
    }

    public void opc_checkcast(short s2) {
        this.emitByte((byte)-64);
        this.emitShort(s2);
    }

    public void opc_goto(short s2) {
        this.emitByte((byte)-89);
        this.emitShort(s2);
    }

    public void opc_if_icmpeq(short s2) {
        this.emitByte((byte)-97);
        this.emitShort(s2);
        this.setStack(this.getStack() - 2);
    }

    public void opc_ifeq(short s2) {
        this.emitByte((byte)-103);
        this.emitShort(s2);
        this.decStack();
    }

    public void opc_ifnonnull(short s2) {
        this.emitByte((byte)-57);
        this.emitShort(s2);
        this.decStack();
    }

    public void opc_ifnull(short s2) {
        this.emitByte((byte)-58);
        this.emitShort(s2);
        this.decStack();
    }

    public void opc_instanceof(short s2) {
        this.emitByte((byte)-63);
        this.emitShort(s2);
    }

    public void opc_new(short s2) {
        this.emitByte((byte)-69);
        this.emitShort(s2);
        this.incStack();
    }

    public void opc_sipush(short s2) {
        this.emitByte((byte)17);
        this.emitShort(s2);
        this.incStack();
    }

    public void opc_getfield(short s2, int n2) {
        this.emitByte((byte)-76);
        this.emitShort(s2);
        this.setStack(this.getStack() + n2 - 1);
    }

    public void opc_getstatic(short s2, int n2) {
        this.emitByte((byte)-78);
        this.emitShort(s2);
        this.setStack(this.getStack() + n2);
    }

    public void opc_putfield(short s2, int n2) {
        this.emitByte((byte)-75);
        this.emitShort(s2);
        this.setStack(this.getStack() - n2 - 1);
    }

    public void opc_putstatic(short s2, int n2) {
        this.emitByte((byte)-77);
        this.emitShort(s2);
        this.setStack(this.getStack() - n2);
    }

    public void opc_invokeinterface(short s2, int n2, byte by, int n3) {
        this.emitByte((byte)-71);
        this.emitShort(s2);
        this.emitByte(by);
        this.emitByte((byte)0);
        this.setStack(this.getStack() - n2 - 1 + n3);
    }

    public void opc_invokespecial(short s2, int n2, int n3) {
        this.emitByte((byte)-73);
        this.emitShort(s2);
        this.setStack(this.getStack() - n2 - 1 + n3);
    }

    public void opc_invokestatic(short s2, int n2, int n3) {
        this.emitByte((byte)-72);
        this.emitShort(s2);
        this.setStack(this.getStack() - n2 + n3);
    }

    public void opc_invokevirtual(short s2, int n2, int n3) {
        this.emitByte((byte)-74);
        this.emitShort(s2);
        this.setStack(this.getStack() - n2 - 1 + n3);
    }

    public void emitConstantPoolFieldref(short s2, short s3) {
        this.emitByte((byte)9);
        this.emitShort(s2);
        this.emitShort(s3);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolInterfaceMethodref(short s2, short s3) {
        this.emitByte((byte)11);
        this.emitShort(s2);
        this.emitShort(s3);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolMethodref(short s2, short s3) {
        this.emitByte((byte)10);
        this.emitShort(s2);
        this.emitShort(s3);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolNameAndType(short s2, short s3) {
        this.emitByte((byte)12);
        this.emitShort(s2);
        this.emitShort(s3);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    void emitShort(short s2, short s3) {
        this.vec.put(s2, (byte)(s3 >> 8 & 0xFF));
        this.vec.put(s2 + 1, (byte)(s3 & 0xFF));
    }

    public void emitConstantPoolUTF8(String string) {
        byte[] byArray = UTF8.encode(string);
        this.emitByte((byte)1);
        this.emitShort((short)byArray.length);
        int n2 = 0;
        while (n2 < byArray.length) {
            this.emitByte(byArray[n2]);
            ++n2;
        }
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public ByteVector getData() {
        return this.vec;
    }

    public ClassFileAssembler(ByteVector byteVector) {
        this.vec = byteVector;
    }

    public void append(ByteVector byteVector) {
        int n2 = 0;
        while (n2 < byteVector.getLength()) {
            this.emitByte(byteVector.get(n2));
            ++n2;
        }
    }

    public void append(ClassFileAssembler classFileAssembler) {
        this.append(classFileAssembler.vec);
    }

    public void opc_goto(Label label) {
        short s2 = this.getLength();
        this.emitByte((byte)-89);
        label.add(this, s2, this.getLength(), this.getStack());
        this.emitShort((short)-1);
    }

    public void opc_if_icmpeq(Label label) {
        short s2 = this.getLength();
        this.emitByte((byte)-97);
        label.add(this, s2, this.getLength(), this.getStack() - 2);
        this.emitShort((short)-1);
    }

    public void opc_ifeq(Label label) {
        short s2 = this.getLength();
        this.emitByte((byte)-103);
        label.add(this, s2, this.getLength(), this.getStack() - 1);
        this.emitShort((short)-1);
    }

    public void opc_ifnonnull(Label label) {
        short s2 = this.getLength();
        this.emitByte((byte)-57);
        label.add(this, s2, this.getLength(), this.getStack() - 1);
        this.emitShort((short)-1);
        this.decStack();
    }

    public void opc_ifnull(Label label) {
        short s2 = this.getLength();
        this.emitByte((byte)-58);
        label.add(this, s2, this.getLength(), this.getStack() - 1);
        this.emitShort((short)-1);
        this.decStack();
    }
}

