/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import sun.print.ImagePrinter;
import sun.print.PSPrinterJob;
import sun.print.PSStreamPrintService;
import sun.print.PrintJobAttributeException;
import sun.print.PrintJobFlavorException;

public class PSStreamPrintJob
implements CancelablePrintJob {
    private transient Vector jobListeners;
    private transient Vector attrListeners;
    private transient Vector listenedAttributeSets;
    private PSStreamPrintService service;
    private boolean fidelity;
    private boolean printing = false;
    private boolean printReturned = false;
    private PrintRequestAttributeSet reqAttrSet = null;
    private PrintJobAttributeSet jobAttrSet = null;
    private PrinterJob job;
    private Doc doc;
    private InputStream instream = null;
    private Reader reader = null;
    private String jobName = "Java Printing";
    private int copies = 1;
    private MediaSizeName mediaName = MediaSizeName.NA_LETTER;
    private MediaSize mediaSize = MediaSize.NA.LETTER;
    private OrientationRequested orient = OrientationRequested.PORTRAIT;
    static Class class$javax$print$attribute$standard$RequestingUserName;
    static Class class$javax$print$attribute$standard$JobName;
    static Class class$javax$print$attribute$standard$DocumentName;
    static Class class$javax$print$attribute$standard$Fidelity;
    static Class class$javax$print$attribute$standard$Copies;
    static Class class$javax$print$attribute$standard$Media;
    static Class class$javax$print$attribute$standard$OrientationRequested;

    public void cancel() throws PrintException {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (!this.printing) {
                throw new PrintException("Job is not yet submitted.");
            }
            if (this.job != null && !this.printReturned) {
                this.job.cancel();
                this.notifyEvent(101);
                return;
            }
            throw new PrintException("Job could not be cancelled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataStreams() {
        block18: {
            Object object;
            block17: {
                block16: {
                    block15: {
                        if (this.doc == null) {
                            return;
                        }
                        object = null;
                        try {
                            object = this.doc.getPrintData();
                        }
                        catch (IOException iOException) {
                            return;
                        }
                        if (this.instream == null) break block15;
                        try {
                            try {
                                this.instream.close();
                            }
                            catch (IOException iOException) {
                                Object var4_8 = null;
                                this.instream = null;
                            }
                            Object var4_7 = null;
                            this.instream = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_9 = null;
                            this.instream = null;
                            throw throwable;
                        }
                    }
                    if (this.reader == null) break block16;
                    try {
                        try {
                            this.reader.close();
                        }
                        catch (IOException iOException) {
                            Object var6_12 = null;
                            this.reader = null;
                        }
                        Object var6_11 = null;
                        this.reader = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_13 = null;
                        this.reader = null;
                        throw throwable;
                    }
                }
                if (!(object instanceof InputStream)) break block17;
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
                break block18;
            }
            if (!(object instanceof Reader)) break block18;
            try {
                ((Reader)object).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int n2) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent printJobEvent = new PrintJobEvent(this, n2);
                int n3 = 0;
                while (n3 < this.jobListeners.size()) {
                    PrintJobListener printJobListener = (PrintJobListener)this.jobListeners.elementAt(n3);
                    switch (n2) {
                        case 101: {
                            printJobListener.printJobCanceled(printJobEvent);
                            break;
                        }
                        case 103: {
                            printJobListener.printJobFailed(printJobEvent);
                            break;
                        }
                        case 106: {
                            printJobListener.printDataTransferCompleted(printJobEvent);
                            break;
                        }
                        case 105: {
                            printJobListener.printJobNoMoreEvents(printJobEvent);
                            break;
                        }
                        case 102: {
                            printJobListener.printJobCompleted(printJobEvent);
                            break;
                        }
                    }
                    ++n3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageableJob(Pageable pageable) throws PrintException {
        try {
            try {
                PSStreamPrintJob pSStreamPrintJob = this;
                synchronized (pSStreamPrintJob) {
                    if (this.job != null) {
                        throw new PrintException("already printing");
                    }
                    this.job = new PSPrinterJob();
                }
                this.job.setPrintService(this.getPrintService());
                this.job.setCopies(this.copies);
                this.job.setJobName(this.jobName);
                this.job.setPageable(pageable);
                this.job.print();
                this.notifyEvent(102);
                Object var5_5 = null;
                this.printReturned = true;
                return;
            }
            catch (PrinterException printerException) {
                this.notifyEvent(103);
                throw new PrintException(printerException);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.printReturned = true;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printableJob(Printable printable) throws PrintException {
        try {
            try {
                PSStreamPrintJob pSStreamPrintJob = this;
                synchronized (pSStreamPrintJob) {
                    if (this.job != null) {
                        throw new PrintException("already printing");
                    }
                    this.job = new PSPrinterJob();
                }
                this.job.setPrintService(this.getPrintService());
                this.job.setCopies(this.copies);
                this.job.setJobName(this.jobName);
                PageFormat pageFormat = new PageFormat();
                if (this.mediaSize != null) {
                    Paper paper = new Paper();
                    paper.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                    paper.setImageableArea(72.0, 72.0, paper.getWidth() - 144.0, paper.getHeight() - 144.0);
                    pageFormat.setPaper(paper);
                }
                if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                    pageFormat.setOrientation(2);
                } else if (this.orient == OrientationRequested.LANDSCAPE) {
                    pageFormat.setOrientation(0);
                }
                this.job.setPrintable(printable, pageFormat);
                this.job.print();
                this.notifyEvent(102);
                Object var6_7 = null;
                this.printReturned = true;
                return;
            }
            catch (PrinterException printerException) {
                this.notifyEvent(103);
                throw new PrintException(printerException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.printReturned = true;
            throw throwable;
        }
    }

    private void getAttributeValues(DocFlavor docFlavor) throws PrintException {
        this.fidelity = this.reqAttrSet.get(class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = PSStreamPrintJob.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity) == Fidelity.FIDELITY_TRUE;
        Attribute[] attributeArray = this.reqAttrSet.toArray();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            Attribute attribute = attributeArray[n2];
            Class clazz = attribute.getCategory();
            if (this.fidelity) {
                if (!this.service.isAttributeCategorySupported(clazz)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported category: " + clazz, clazz, null);
                }
                if (!this.service.isAttributeValueSupported(attribute, docFlavor, null)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported attribute: " + attribute, null, attribute);
                }
            }
            if (clazz == (class$javax$print$attribute$standard$JobName == null ? PSStreamPrintJob.class$("javax.print.attribute.standard.JobName") : class$javax$print$attribute$standard$JobName)) {
                this.jobName = ((JobName)attribute).getValue();
            } else if (clazz == (class$javax$print$attribute$standard$Copies == null ? PSStreamPrintJob.class$("javax.print.attribute.standard.Copies") : class$javax$print$attribute$standard$Copies)) {
                this.copies = ((Copies)attribute).getValue();
            } else if (clazz == (class$javax$print$attribute$standard$Media == null ? PSStreamPrintJob.class$("javax.print.attribute.standard.Media") : class$javax$print$attribute$standard$Media)) {
                if (attribute instanceof MediaSizeName) {
                    this.mediaName = (MediaSizeName)attribute;
                    if (!this.service.isAttributeValueSupported(attribute, null, null)) {
                        this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                    }
                }
            } else if (clazz == (class$javax$print$attribute$standard$OrientationRequested == null ? PSStreamPrintJob.class$("javax.print.attribute.standard.OrientationRequested") : class$javax$print$attribute$standard$OrientationRequested)) {
                this.orient = (OrientationRequested)attribute;
            }
            ++n2;
        }
    }

    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintJobAttributeSet getAttributes() {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet hashPrintJobAttributeSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(hashPrintJobAttributeSet);
            }
            return this.jobAttrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (printJobAttributeListener == null || this.attrListeners == null) {
                return;
            }
            int n2 = this.attrListeners.indexOf(printJobAttributeListener);
            if (n2 == -1) {
                return;
            }
            this.attrListeners.remove(n2);
            this.listenedAttributeSets.remove(n2);
            if (this.attrListeners.isEmpty()) {
                this.attrListeners = null;
                this.listenedAttributeSets = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobListener(PrintJobListener printJobListener) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (printJobListener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new Vector();
            }
            this.jobListeners.add(printJobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobListener(PrintJobListener printJobListener) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (printJobListener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(printJobListener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    PSStreamPrintJob(PSStreamPrintService pSStreamPrintService) {
        this.service = pSStreamPrintService;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener, PrintJobAttributeSet printJobAttributeSet) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (printJobAttributeListener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new Vector();
                this.listenedAttributeSets = new Vector();
            }
            this.attrListeners.add(printJobAttributeListener);
            if (printJobAttributeSet == null) {
                printJobAttributeSet = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(printJobAttributeSet);
        }
    }

    private synchronized void initializeAttributeSets(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) {
        TextSyntax textSyntax;
        DocAttributeSet docAttributeSet;
        Attribute[] attributeArray;
        this.reqAttrSet = new HashPrintRequestAttributeSet();
        this.jobAttrSet = new HashPrintJobAttributeSet();
        if (printRequestAttributeSet != null) {
            this.reqAttrSet.addAll(printRequestAttributeSet);
            attributeArray = printRequestAttributeSet.toArray();
            int n2 = 0;
            while (n2 < attributeArray.length) {
                if (attributeArray[n2] instanceof PrintJobAttribute) {
                    this.jobAttrSet.add(attributeArray[n2]);
                }
                ++n2;
            }
        }
        if ((docAttributeSet = doc.getAttributes()) != null) {
            attributeArray = docAttributeSet.toArray();
            int n3 = 0;
            while (n3 < attributeArray.length) {
                if (attributeArray[n3] instanceof PrintRequestAttribute) {
                    this.reqAttrSet.add(attributeArray[n3]);
                }
                if (attributeArray[n3] instanceof PrintJobAttribute) {
                    this.jobAttrSet.add(attributeArray[n3]);
                }
                ++n3;
            }
        }
        String string = "";
        try {
            string = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null || string.equals("")) {
            textSyntax = (RequestingUserName)printRequestAttributeSet.get(class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = PSStreamPrintJob.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName);
            if (textSyntax != null) {
                this.jobAttrSet.add(new JobOriginatingUserName(textSyntax.getValue(), textSyntax.getLocale()));
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName("", null));
            }
        } else {
            this.jobAttrSet.add(new JobOriginatingUserName(string, null));
        }
        if (this.jobAttrSet.get(class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = PSStreamPrintJob.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName) == null) {
            if (docAttributeSet != null && docAttributeSet.get(class$javax$print$attribute$standard$DocumentName == null ? (class$javax$print$attribute$standard$DocumentName = PSStreamPrintJob.class$("javax.print.attribute.standard.DocumentName")) : class$javax$print$attribute$standard$DocumentName) != null) {
                DocumentName documentName = (DocumentName)docAttributeSet.get(class$javax$print$attribute$standard$DocumentName == null ? (class$javax$print$attribute$standard$DocumentName = PSStreamPrintJob.class$("javax.print.attribute.standard.DocumentName")) : class$javax$print$attribute$standard$DocumentName);
                textSyntax = new JobName(documentName.getValue(), documentName.getLocale());
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            } else {
                String string2 = "JPS Job:" + doc;
                try {
                    Object object = doc.getPrintData();
                    if (object instanceof URL) {
                        string2 = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                textSyntax = new JobName(string2, null);
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) throws PrintException {
        Object object;
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (this.printing) {
                throw new PrintException("already printing");
            }
            this.printing = true;
        }
        this.doc = doc;
        DocFlavor docFlavor = doc.getDocFlavor();
        try {
            object = doc.getPrintData();
        }
        catch (IOException iOException) {
            this.notifyEvent(103);
            throw new PrintException("can't get print data: " + iOException.toString());
        }
        if (docFlavor == null || !this.service.isDocFlavorSupported(docFlavor)) {
            this.notifyEvent(103);
            throw new PrintJobFlavorException("invalid flavor", docFlavor);
        }
        this.initializeAttributeSets(doc, printRequestAttributeSet);
        this.getAttributeValues(docFlavor);
        String string = docFlavor.getRepresentationClassName();
        if (docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG)) {
            try {
                this.instream = doc.getStreamForBytes();
                this.printableJob(new ImagePrinter(this.instream));
                return;
            }
            catch (ClassCastException classCastException) {
                this.notifyEvent(103);
                throw new PrintException(classCastException);
            }
            catch (IOException iOException) {
                this.notifyEvent(103);
                throw new PrintException(iOException);
            }
        }
        if (docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.URL.PNG)) {
            try {
                this.printableJob(new ImagePrinter((URL)object));
                return;
            }
            catch (ClassCastException classCastException) {
                this.notifyEvent(103);
                throw new PrintException(classCastException);
            }
        }
        if (string.equals("java.awt.print.Pageable")) {
            try {
                this.pageableJob((Pageable)doc.getPrintData());
                return;
            }
            catch (ClassCastException classCastException) {
                this.notifyEvent(103);
                throw new PrintException(classCastException);
            }
            catch (IOException iOException) {
                this.notifyEvent(103);
                throw new PrintException(iOException);
            }
        }
        if (string.equals("java.awt.print.Printable")) {
            try {
                this.printableJob((Printable)doc.getPrintData());
                return;
            }
            catch (ClassCastException classCastException) {
                this.notifyEvent(103);
                throw new PrintException(classCastException);
            }
            catch (IOException iOException) {
                this.notifyEvent(103);
                throw new PrintException(iOException);
            }
        }
        this.notifyEvent(103);
        throw new PrintException("unrecognized class: " + string);
    }
}

