/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public abstract class SingleByteDecoder
extends CharsetDecoder {
    private final String byteToCharTable;
    static final boolean $assertionsDisabled = !(class$sun$nio$cs$SingleByteDecoder == null ? (class$sun$nio$cs$SingleByteDecoder = SingleByteDecoder.class$("sun.nio.cs.SingleByteDecoder")) : class$sun$nio$cs$SingleByteDecoder).desiredAssertionStatus();
    static Class class$sun$nio$cs$SingleByteDecoder;

    public char decode(int n2) {
        int n3 = n2 + 128;
        if (n3 >= this.byteToCharTable.length() || n3 < 0) {
            return '\ufffd';
        }
        return this.byteToCharTable.charAt(n3);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected SingleByteDecoder(Charset charset, String string) {
        super(charset, 1.0f, 1.0f);
        this.byteToCharTable = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        n2 = n2 <= n3 ? n2 : n3;
        char[] cArray = charBuffer.array();
        int n4 = charBuffer.arrayOffset() + charBuffer.position();
        int n5 = charBuffer.arrayOffset() + charBuffer.limit();
        if (!$assertionsDisabled && n4 > n5) {
            throw new AssertionError();
        }
        n4 = n4 <= n5 ? n4 : n5;
        try {
            while (n2 < n3) {
                byte by = byArray[n2];
                int n6 = by + 128;
                if (n6 >= this.byteToCharTable.length() || n6 < 0) {
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                char c2 = this.byteToCharTable.charAt(n6);
                if (c2 == '\ufffd') {
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                if (n5 - n4 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                cArray[n4++] = c2;
                ++n2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            charBuffer.position(n4 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n2;
        block7: {
            CoderResult coderResult2;
            block10: {
                CoderResult coderResult3;
                block9: {
                    CoderResult coderResult4;
                    n2 = byteBuffer.position();
                    try {
                        while (true) {
                            if (!byteBuffer.hasRemaining()) {
                                coderResult = CoderResult.UNDERFLOW;
                                break block7;
                            }
                            byte by = byteBuffer.get();
                            int n3 = by + 128;
                            if (n3 >= this.byteToCharTable.length() || n3 < 0) {
                                coderResult4 = CoderResult.malformedForLength(1);
                                Object var11_9 = null;
                                break;
                            }
                            char c2 = this.byteToCharTable.charAt(n3);
                            if (c2 == '\ufffd') {
                                coderResult3 = CoderResult.malformedForLength(1);
                                break block9;
                            }
                            if (!charBuffer.hasRemaining()) {
                                coderResult2 = CoderResult.OVERFLOW;
                                break block10;
                            }
                            ++n2;
                            charBuffer.put(c2);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        byteBuffer.position(n2);
                        throw throwable;
                    }
                    byteBuffer.position(n2);
                    return coderResult4;
                }
                Object var11_10 = null;
                byteBuffer.position(n2);
                return coderResult3;
            }
            Object var11_11 = null;
            byteBuffer.position(n2);
            return coderResult2;
        }
        Object var11_12 = null;
        byteBuffer.position(n2);
        return coderResult;
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

