/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Pipe;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

class SinkChannelImpl
extends Pipe.SinkChannel
implements SelChImpl {
    SocketChannel sc;

    public int getFDVal() {
        return ((SocketChannelImpl)this.sc).getFDVal();
    }

    protected void implCloseSelectableChannel() throws IOException {
        if (!this.isRegistered()) {
            this.kill();
        }
    }

    public void kill() throws IOException {
        this.sc.close();
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        this.sc.configureBlocking(bl2);
    }

    public FileDescriptor getFD() {
        return ((SocketChannelImpl)this.sc).getFD();
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.sc.write(byteBuffer);
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            this.close();
            throw asynchronousCloseException;
        }
    }

    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        try {
            return this.sc.write(byteBufferArray);
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            this.close();
            throw asynchronousCloseException;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        try {
            return this.write(Util.subsequence(byteBufferArray, n2, n3));
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            this.close();
            throw asynchronousCloseException;
        }
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        if ((n2 & 4) != 0) {
            n2 = 4;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    public void translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        if ((n2 & 4) != 0) {
            selectionKeyImpl.readyOps(4);
        }
    }

    SinkChannelImpl(SelectorProvider selectorProvider, SocketChannel socketChannel) {
        super(selectorProvider);
        this.sc = socketChannel;
    }
}

