/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;
import sun.nio.ch.OptionAdaptor;
import sun.nio.ch.Util;

public class DatagramSocketAdaptor
extends DatagramSocket {
    private final DatagramChannelImpl dc;
    private volatile OptionAdaptor opts = null;
    private volatile int timeout = 0;
    private volatile int trafficClass = 0;

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return Net.asInetSocketAddress(this.dc.localAddress()).getPort();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getPort() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getPort() : -1;
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.opts().getReceiveBufferSize();
    }

    public int getSendBufferSize() throws SocketException {
        return this.opts().getSendBufferSize();
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    public int getTrafficClass() throws SocketException {
        int n2 = this.opts().getTrafficClass();
        if (n2 < 0) {
            n2 = this.trafficClass;
        }
        return n2;
    }

    public void close() {
        try {
            this.dc.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    public void disconnect() {
        try {
            this.dc.disconnect();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    public boolean getBroadcast() throws SocketException {
        return this.opts().getBroadcast();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.opts().getReuseAddress();
    }

    public boolean isBound() {
        return this.dc.isBound();
    }

    public boolean isClosed() {
        return !this.dc.isOpen();
    }

    public boolean isConnected() {
        return this.dc.isConnected();
    }

    public void setReceiveBufferSize(int n2) throws SocketException {
        this.opts().setReceiveBufferSize(n2);
    }

    public void setSendBufferSize(int n2) throws SocketException {
        this.opts().setSendBufferSize(n2);
    }

    public void setSoTimeout(int n2) throws SocketException {
        this.timeout = n2;
    }

    public void setTrafficClass(int n2) throws SocketException {
        this.opts().setTrafficClass(n2);
        this.trafficClass = n2;
    }

    public void setBroadcast(boolean bl2) throws SocketException {
        this.opts().setBroadcast(bl2);
    }

    public void setReuseAddress(boolean bl2) throws SocketException {
        this.opts().setReuseAddress(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DatagramPacket datagramPacket) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket2 = datagramPacket;
                synchronized (datagramPacket2) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                    this.receive(byteBuffer);
                    datagramPacket.setLength(byteBuffer.position() - datagramPacket.getOffset());
                }
            }
            catch (IOException iOException) {
                Net.translateException(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DatagramPacket datagramPacket) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket2 = datagramPacket;
                synchronized (datagramPacket2) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                    this.dc.send(byteBuffer, datagramPacket.getSocketAddress());
                }
            }
            catch (IOException iOException) {
                Net.translateException(iOException);
            }
        }
    }

    public InetAddress getInetAddress() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getAddress() : null;
    }

    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        try {
            return Net.asInetSocketAddress(this.dc.localAddress()).getAddress();
        }
        catch (Exception exception) {
            return new InetSocketAddress(0).getAddress();
        }
    }

    public void connect(InetAddress inetAddress, int n2) {
        try {
            this.connectInternal(new InetSocketAddress(inetAddress, n2));
        }
        catch (SocketException socketException) {}
    }

    public void bind(SocketAddress socketAddress) throws SocketException {
        try {
            if (socketAddress == null) {
                socketAddress = new InetSocketAddress(0);
            }
            this.dc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void connect(SocketAddress socketAddress) throws SocketException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        this.connectInternal(socketAddress);
    }

    private void connectInternal(SocketAddress socketAddress) throws SocketException {
        InetSocketAddress inetSocketAddress = Net.asInetSocketAddress(socketAddress);
        int n2 = inetSocketAddress.getPort();
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("connect: " + n2);
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: null address");
        }
        if (!this.isClosed()) {
            return;
        }
        try {
            this.dc.connect(socketAddress);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    private void receive(ByteBuffer byteBuffer) throws IOException {
        if (this.timeout == 0) {
            this.dc.receive(byteBuffer);
            return;
        }
        SelectionKey selectionKey = null;
        this.dc.configureBlocking(false);
        try {
            long l2;
            if (this.dc.receive(byteBuffer) != null) {
                return;
            }
            Selector selector = Util.getTemporarySelector(this.dc);
            selectionKey = this.dc.register(selector, 1);
            long l3 = this.timeout;
            do {
                l2 = System.currentTimeMillis();
                selector.select(l3);
                if (selectionKey.isReadable() && this.dc.receive(byteBuffer) != null) {
                    return;
                }
                selector.selectedKeys().remove(selectionKey);
            } while ((l3 -= System.currentTimeMillis() - l2) > 0L);
            throw new SocketTimeoutException();
        }
        finally {
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            if (this.dc.isOpen()) {
                this.dc.configureBlocking(true);
            }
        }
    }

    public DatagramChannel getChannel() {
        return this.dc;
    }

    private DatagramSocketAdaptor(DatagramChannelImpl datagramChannelImpl) throws IOException {
        super((SocketAddress)null);
        this.dc = datagramChannelImpl;
    }

    private OptionAdaptor opts() {
        if (this.opts == null) {
            this.opts = new OptionAdaptor(this.dc);
        }
        return this.opts;
    }

    public static DatagramSocket create(DatagramChannelImpl datagramChannelImpl) {
        try {
            return new DatagramSocketAdaptor(datagramChannelImpl);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }
}

