/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.SortedSet;
import java.util.TreeSet;
import sun.misc.GC;

public class GC {
    private static final long NO_TARGET = Long.MAX_VALUE;
    private static long latencyTarget = Long.MAX_VALUE;
    private static Thread daemon = null;
    private static Object lock = new LatencyLock(null);
    static Class class$sun$misc$GC$LatencyRequest;

    static long access$200() {
        return latencyTarget;
    }

    public static long currentLatencyTarget() {
        long l2 = latencyTarget;
        return l2 == Long.MAX_VALUE ? 0L : l2;
    }

    public static native long maxObjectInspectionAge();

    private GC() {
    }

    static void access$500(long l2) {
        GC.setLatencyTarget(l2);
    }

    private static void setLatencyTarget(long l2) {
        latencyTarget = l2;
        if (daemon == null) {
            Daemon.create();
        } else {
            lock.notify();
        }
    }

    static Object access$100() {
        return lock;
    }

    public static LatencyRequest requestLatency(long l2) {
        return new LatencyRequest(l2, null);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static Thread access$302(Thread thread) {
        daemon = thread;
        return daemon;
    }

    private static class Daemon
    extends Thread {
        public static void create() {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    Daemon daemon = new Daemon(threadGroup, null);
                    daemon.setDaemon(true);
                    daemon.setPriority(2);
                    daemon.start();
                    GC.access$302(daemon);
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = GC.access$100();
                synchronized (object) {
                    long l2 = GC.access$200();
                    if (l2 == Long.MAX_VALUE) {
                        GC.access$302(null);
                        return;
                    }
                    long l3 = GC.maxObjectInspectionAge();
                    if (l3 >= l2) {
                        System.gc();
                        l3 = 0L;
                    }
                    try {
                        GC.access$100().wait(l2 - l3);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }

        private Daemon(ThreadGroup threadGroup) {
            super(threadGroup, "GC Daemon");
        }

        Daemon(ThreadGroup threadGroup, 1 var2_2) {
            this(threadGroup);
        }
    }

    private static class LatencyLock {
        private LatencyLock() {
        }

        LatencyLock(1 var1_1) {
            this();
        }
    }

    public static class LatencyRequest
    implements Comparable {
        private static long counter = 0L;
        private static SortedSet requests = null;
        private long latency;
        private long id;

        private static void adjustLatencyIfNeeded() {
            if (requests == null || requests.isEmpty()) {
                if (GC.access$200() != Long.MAX_VALUE) {
                    GC.access$500(Long.MAX_VALUE);
                }
            } else {
                LatencyRequest latencyRequest = (LatencyRequest)requests.first();
                if (latencyRequest.latency != GC.access$200()) {
                    GC.access$500(latencyRequest.latency);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = GC.access$100();
            synchronized (object) {
                if (this.latency == Long.MAX_VALUE) {
                    throw new IllegalStateException("Request already cancelled");
                }
                if (!requests.remove(this)) {
                    throw new InternalError("Latency request " + this + " not found");
                }
                if (requests.isEmpty()) {
                    requests = null;
                }
                this.latency = Long.MAX_VALUE;
                LatencyRequest.adjustLatencyIfNeeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LatencyRequest(long l2) {
            if (l2 <= 0L) {
                throw new IllegalArgumentException("Non-positive latency: " + l2);
            }
            this.latency = l2;
            Object object = GC.access$100();
            synchronized (object) {
                this.id = ++counter;
                if (requests == null) {
                    requests = new TreeSet();
                }
                requests.add(this);
                LatencyRequest.adjustLatencyIfNeeded();
            }
        }

        public int compareTo(Object object) {
            LatencyRequest latencyRequest = (LatencyRequest)object;
            long l2 = this.latency - latencyRequest.latency;
            if (l2 == 0L) {
                l2 = this.id - latencyRequest.id;
            }
            return l2 < 0L ? -1 : (l2 > 0L ? 1 : 0);
        }

        public String toString() {
            return (class$sun$misc$GC$LatencyRequest == null ? (class$sun$misc$GC$LatencyRequest = GC.class$("sun.misc.GC$LatencyRequest")) : class$sun$misc$GC$LatencyRequest).getName() + "[" + this.latency + "," + this.id + "]";
        }

        LatencyRequest(long l2, 1 var3_2) {
            this(l2);
        }
    }
}

