/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;

public final class RenderCache {
    public Entry[] entries;

    public RenderCache(int n2) {
        this.entries = new Entry[n2];
    }

    public Object get(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        int n2;
        int n3 = n2 = this.entries.length - 1;
        while (n3 >= 0) {
            Entry entry = this.entries[n3];
            if (entry == null) break;
            if (entry.matches(surfaceType, compositeType, surfaceType2)) {
                if (n3 < n2 - 4) {
                    System.arraycopy(this.entries, n3 + 1, this.entries, n3, n2 - n3);
                    this.entries[n2] = entry;
                }
                return entry.getValue();
            }
            --n3;
        }
        return null;
    }

    public void put(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2, Object object) {
        Entry entry = new Entry(this, surfaceType, compositeType, surfaceType2, object);
        int n2 = this.entries.length;
        System.arraycopy(this.entries, 1, this.entries, 0, n2 - 1);
        this.entries[n2 - 1] = entry;
    }

    final class Entry {
        private SurfaceType src;
        private CompositeType comp;
        private SurfaceType dst;
        private Object value;
        private final RenderCache this$0;

        public Object getValue() {
            return this.value;
        }

        public boolean matches(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
            return this.src == surfaceType && this.comp == compositeType && this.dst == surfaceType2;
        }

        public Entry(RenderCache renderCache, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2, Object object) {
            this.this$0 = renderCache;
            this.src = surfaceType;
            this.comp = compositeType;
            this.dst = surfaceType2;
            this.value = object;
        }
    }
}

