/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.editors;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class FontEditor
extends Panel
implements PropertyEditor {
    private Font font;
    private Toolkit toolkit;
    private String sampleText = "Abcde...";
    private Label sample;
    private Choice familyChoser;
    private Choice styleChoser;
    private Choice sizeChoser;
    private String[] fonts;
    private String[] styleNames = new String[]{"plain", "bold", "italic"};
    private int[] styles = new int[]{0, 1, 2};
    private int[] pointSizes = new int[]{3, 5, 8, 10, 12, 14, 18, 24, 36, 48};
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public FontEditor() {
        this.setLayout(null);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.fonts = this.toolkit.getFontList();
        this.familyChoser = new Choice();
        int n2 = 0;
        while (n2 < this.fonts.length) {
            this.familyChoser.addItem(this.fonts[n2]);
            ++n2;
        }
        this.add(this.familyChoser);
        this.familyChoser.reshape(20, 5, 100, 30);
        this.styleChoser = new Choice();
        int n3 = 0;
        while (n3 < this.styleNames.length) {
            this.styleChoser.addItem(this.styleNames[n3]);
            ++n3;
        }
        this.add(this.styleChoser);
        this.styleChoser.reshape(145, 5, 70, 30);
        this.sizeChoser = new Choice();
        int n4 = 0;
        while (n4 < this.pointSizes.length) {
            this.sizeChoser.addItem("" + this.pointSizes[n4]);
            ++n4;
        }
        this.add(this.sizeChoser);
        this.sizeChoser.reshape(220, 5, 70, 30);
        this.resize(300, 40);
    }

    public boolean isPaintable() {
        return true;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public Dimension preferredSize() {
        return new Dimension(300, 40);
    }

    private void changeFont(Font font) {
        this.font = font;
        if (this.sample != null) {
            this.remove(this.sample);
        }
        this.sample = new Label(this.sampleText);
        this.sample.setFont(this.font);
        this.add(this.sample);
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).invalidate();
            ((Component)container).layout();
        }
        this.invalidate();
        this.layout();
        this.repaint();
        this.support.firePropertyChange("", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Object getValue() {
        return this.font;
    }

    public void setValue(Object object) {
        this.font = (Font)object;
        this.changeFont(this.font);
        int n2 = 0;
        while (n2 < this.fonts.length) {
            if (this.fonts[n2].equals(this.font.getFamily())) {
                this.familyChoser.select(n2);
                break;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.styleNames.length) {
            if (this.font.getStyle() == this.styles[n3]) {
                this.styleChoser.select(n3);
                break;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.pointSizes.length) {
            if (this.font.getSize() <= this.pointSizes[n4]) {
                this.sizeChoser.select(n4);
                break;
            }
            ++n4;
        }
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return "new java.awt.Font(\"" + this.font.getFamily() + "\", " + this.font.getStyle() + ", " + this.font.getSize() + ")";
    }

    public String[] getTags() {
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(this.sampleText, 0, rectangle.height - n2);
        graphics.setFont(font);
    }

    public boolean action(Event event, Object object) {
        String string = this.familyChoser.getSelectedItem();
        int n2 = this.styles[this.styleChoser.getSelectedIndex()];
        int n3 = this.pointSizes[this.sizeChoser.getSelectedIndex()];
        try {
            Font font = new Font(string, n2, n3);
            this.changeFont(font);
        }
        catch (Exception exception) {
            System.err.println("Couldn't create font " + string + "-" + this.styleNames[n2] + "-" + n3);
        }
        return false;
    }
}

