/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.D3DBlitLoops;
import sun.awt.windows.WVolatileImage;
import sun.awt.windows.Win32BlitLoops;
import sun.awt.windows.Win32D3DRenderer;
import sun.awt.windows.Win32DDRenderer;
import sun.awt.windows.Win32OffScreenImage;
import sun.awt.windows.Win32PeerlessImage;
import sun.awt.windows.Win32ScaleLoops;
import sun.awt.windows.Win32SurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.security.action.GetPropertyAction;

public class Win32OffScreenSurfaceData
extends SurfaceData {
    int width;
    int height;
    int transparency;
    private GraphicsConfiguration graphicsConfig;
    private Image image;
    private static boolean forceDDVram;
    private RenderLoops solidloops;
    private static boolean d3dEnabled;
    private boolean localD3dEnabled = true;
    private static boolean ddScaleEnabled;
    private static int textureBpp;
    static boolean directXInitialized;
    protected static Win32D3DRenderer win32pipe3D;
    protected static Win32DDRenderer win32pipe;
    protected static PixelToShapeConverter win32txpipe3D;
    protected static PixelToShapeConverter win32txpipe;

    public static int getTextureBpp() {
        return textureBpp;
    }

    public int getTransparency() {
        return this.transparency;
    }

    static {
        String string;
        boolean bl2;
        d3dEnabled = true;
        ddScaleEnabled = false;
        textureBpp = 32;
        directXInitialized = false;
        Win32OffScreenSurfaceData.initIDs();
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        String string3 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddoffscreen"));
        String string4 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddforcevram"));
        String string5 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddblit"));
        String string6 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddscale"));
        String string7 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.offscreenSharing"));
        boolean bl3 = string3 != null && (string3.equals("false") || string3.equals("f"));
        forceDDVram = string4 != null && (string4.equals("true") || string4.equals("t"));
        boolean bl4 = string5 != null && (string5.equals("false") || string5.equals("f"));
        boolean bl5 = string6 == null || string6.equals("false") || string6.equals("f");
        boolean bl6 = bl2 = string7 != null && !string7.equals("false") && !string7.equals("f");
        if (bl2) {
            System.out.println("Warning: offscreenSharing has been enabled. The use of this capability will change in future releases and applications that depend on it may not work correctly");
        }
        Win32OffScreenSurfaceData.initD3D();
        if (!(string2 != null || bl3 || (string = (String)AccessController.doPrivileged(new GetPropertyAction("javax.accessibility.screen_magnifier_present"))) != null && string.equals("true"))) {
            Win32OffScreenSurfaceData.initDDraw(bl2);
            if (!bl4) {
                Win32BlitLoops.register();
            } else {
                System.out.println("DirectDraw Blits disabled");
            }
            if (!bl5) {
                Win32ScaleLoops.register();
                ddScaleEnabled = true;
                System.out.println("DirectDraw Scaling enabled");
            }
            if (forceDDVram) {
                System.out.println("DirectDraw surfaces constrained to use vram");
            }
        }
        win32pipe3D = new Win32D3DRenderer();
        win32pipe = new Win32DDRenderer();
        if (GraphicsPrimitive.tracingEnabled()) {
            win32pipe = win32pipe.traceWrapDD();
            win32pipe3D = win32pipe3D.traceWrapD3D();
        }
        win32txpipe = new PixelToShapeConverter(win32pipe);
        win32txpipe3D = new PixelToShapeConverter(win32pipe3D);
    }

    public void disableD3D() {
        this.localD3dEnabled = false;
    }

    public native void flush();

    public static void initD3D() {
        if (!directXInitialized) {
            boolean bl2 = false;
            directXInitialized = true;
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.d3d"));
            String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.d3dtexbpp"));
            if (string != null) {
                if (string.equals("true") || string.equals("t")) {
                    bl2 = true;
                    d3dEnabled = true;
                } else if (string.equals("false") || string.equals("f")) {
                    d3dEnabled = false;
                }
            }
            if (string2 != null) {
                try {
                    int n2 = Integer.parseInt(string2);
                    if (n2 == 32 || n2 == 16) {
                        textureBpp = n2;
                        System.out.println("Texture bpp is set to " + textureBpp);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (d3dEnabled && (d3dEnabled = Win32OffScreenSurfaceData.enableD3D(bl2))) {
                D3DBlitLoops.register();
            }
        }
    }

    private static native void initIDs();

    public void invalidate() {
        if (this.isValid()) {
            this.nativeInvalidate();
            super.invalidate();
        }
    }

    public void lock() {
    }

    private native void nativeInvalidate();

    public native void restoreSurface();

    public void unlock() {
    }

    public static boolean isDDScaleEnabled() {
        return ddScaleEnabled;
    }

    public native void setTransparentPixel(int var1);

    private native void initOps(int var1, int var2);

    public native void initSurface(int var1, int var2, int var3, int var4, boolean var5, int var6, boolean var7);

    private static native void initDDraw(boolean var0);

    private static native boolean enableD3D(boolean var0);

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.width, this.height);
    }

    public Raster getRaster(int n2, int n3, int n4, int n5) {
        throw new InternalError("not implemented yet");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        Win32DDRenderer win32DDRenderer;
        PixelToShapeConverter pixelToShapeConverter;
        if (d3dEnabled && this.localD3dEnabled) {
            pixelToShapeConverter = win32txpipe3D;
            win32DDRenderer = win32pipe3D;
        } else {
            pixelToShapeConverter = win32txpipe;
            win32DDRenderer = win32pipe;
        }
        if (sunGraphics2D.antialiasHint != 2) {
            if (sunGraphics2D.paintState == 0) {
                if (sunGraphics2D.compositeState == 0) {
                    if (sunGraphics2D.clipState != 2) {
                        sunGraphics2D.imagepipe = SurfaceData.imagepipe;
                        if (sunGraphics2D.transformState > 1) {
                            sunGraphics2D.drawpipe = pixelToShapeConverter;
                            sunGraphics2D.fillpipe = pixelToShapeConverter;
                        } else if (sunGraphics2D.strokeState != 0) {
                            sunGraphics2D.drawpipe = pixelToShapeConverter;
                            sunGraphics2D.fillpipe = win32DDRenderer;
                        } else {
                            sunGraphics2D.drawpipe = win32DDRenderer;
                            sunGraphics2D.fillpipe = win32DDRenderer;
                        }
                        sunGraphics2D.shapepipe = win32DDRenderer;
                        sunGraphics2D.textpipe = sunGraphics2D.textAntialiasHint == 2 ? SurfaceData.aaTextRenderer : SurfaceData.solidTextRenderer;
                        sunGraphics2D.loops = this.solidloops;
                        return;
                    }
                }
            }
        }
        super.validatePipe(sunGraphics2D);
    }

    public SurfaceData getReplacement() {
        if (this.image instanceof Win32OffScreenImage) {
            return ((Win32OffScreenImage)this.image).restoreContents();
        }
        if (this.image instanceof WVolatileImage) {
            return ((WVolatileImage)this.image).restoreContents();
        }
        return null;
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState == 0) {
            if (sunGraphics2D.compositeState == 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    public static SurfaceType getSurfaceType(ColorModel colorModel, int n2) {
        if (n2 == 3) {
            if (colorModel.getPixelSize() == 16) {
                return Win32SurfaceData.Ushort4444ArgbD3D;
            }
            return Win32SurfaceData.IntArgbD3D;
        }
        boolean bl2 = n2 == 2;
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        return bl2 ? Win32SurfaceData.IntRgbDD_BM : Win32SurfaceData.IntRgbDD;
                    }
                    return bl2 ? Win32SurfaceData.IntRgbxDD_BM : Win32SurfaceData.IntRgbxDD;
                }
                return bl2 ? Win32SurfaceData.ThreeByteBgrDD_BM : Win32SurfaceData.ThreeByteBgrDD;
            }
            case 15: {
                return bl2 ? Win32SurfaceData.Ushort555RgbDD_BM : Win32SurfaceData.Ushort555RgbDD;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getBlueMask() == 62) {
                    return bl2 ? Win32SurfaceData.Ushort555RgbxDD_BM : Win32SurfaceData.Ushort555RgbxDD;
                }
                return bl2 ? Win32SurfaceData.Ushort565RgbDD_BM : Win32SurfaceData.Ushort565RgbDD;
            }
            case 8: {
                if (colorModel.getColorSpace().getType() == 6 && colorModel instanceof ComponentColorModel) {
                    return bl2 ? Win32SurfaceData.ByteGrayDD_BM : Win32SurfaceData.ByteGrayDD;
                }
                if (colorModel instanceof IndexColorModel && SurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                    return bl2 ? Win32SurfaceData.Index8GrayDD_BM : Win32SurfaceData.Index8GrayDD;
                }
                return bl2 ? Win32SurfaceData.ByteIndexedDD_BM : Win32SurfaceData.ByteIndexedOpaqueDD;
            }
        }
        throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
    }

    protected Win32OffScreenSurfaceData(int n2, int n3, SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n4) {
        super(surfaceType, colorModel);
        this.width = n2;
        this.height = n3;
        this.graphicsConfig = graphicsConfiguration;
        this.image = image;
        this.initOps(colorModel.getPixelSize(), n4);
        this.transparency = n4;
        this.solidloops = ((Win32GraphicsConfig)graphicsConfiguration).getSolidLoops(surfaceType);
    }

    public static Win32OffScreenSurfaceData createData(int n2, int n3, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n4) {
        if (!((Win32GraphicsDevice)graphicsConfiguration.getDevice()).isOffscreenAccelerationEnabled()) {
            return null;
        }
        if (n4 == 3) {
            colorModel = ((Win32PeerlessImage)image).getDeviceColorModel();
        }
        Win32OffScreenSurfaceData win32OffScreenSurfaceData = new Win32OffScreenSurfaceData(n2, n3, Win32OffScreenSurfaceData.getSurfaceType(colorModel, n4), colorModel, graphicsConfiguration, image, n4);
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)graphicsConfiguration.getDevice();
        win32OffScreenSurfaceData.initSurface(colorModel.getPixelSize(), n2, n3, win32GraphicsDevice.getScreen(), image instanceof WVolatileImage, n4, forceDDVram);
        return win32OffScreenSurfaceData;
    }
}

