/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGHuffmanTable;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.Enumeration;
import java.util.Vector;

public class JPEGParam
implements JPEGEncodeParam,
Cloneable {
    private static int[] defComponents = new int[]{-1, 1, 3, 3, 4, 3, 4, 4, 4, 4, 4, 4};
    private static int[][] stdCompMapping = new int[][]{{0, 0, 0, 0}, {0}, {0, 0, 0}, {0, 1, 1}, {0, 0, 0, 0}, {0, 1, 1}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}};
    private static int[][] stdSubsample = new int[][]{{1, 1, 1, 1}, {1}, {1, 1, 1}, {1, 2, 2}, {1, 1, 1, 1}, {1, 2, 2}, {1, 1, 1, 1}, {1, 2, 2, 1}, {1, 1, 1, 1}, {1, 2, 2, 1}, {1, 2, 2, 1}, {1, 2, 2, 1}};
    private int width;
    private int height;
    private int encodedColorID;
    private int numComponents;
    private byte[][][] appMarkers;
    private byte[][] comMarker;
    private boolean imageInfoValid;
    private boolean tableInfoValid;
    private int[] horizontalSubsampling;
    private int[] verticalSubsampling;
    private JPEGQTable[] qTables;
    private int[] qTableMapping;
    private JPEGHuffmanTable[] dcHuffTables;
    private int[] dcHuffMapping;
    private JPEGHuffmanTable[] acHuffTables;
    private int[] acHuffMapping;
    private int restartInterval;
    private static final int app0Length = 14;

    public int getDensityUnit() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("No APP0 marker present");
        }
        byte[] byArray = this.findAPP0();
        if (byArray == null) {
            throw new IllegalArgumentException("Can't understand APP0 marker that is present");
        }
        return byArray[7];
    }

    public int getEncodedColorID() {
        return this.encodedColorID;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getRestartInterval() {
        return this.restartInterval;
    }

    public int getWidth() {
        return this.width;
    }

    public int getXDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("No APP0 marker present");
        }
        byte[] byArray = this.findAPP0();
        if (byArray == null) {
            throw new IllegalArgumentException("Can't understand APP0 marker that is present");
        }
        int n2 = byArray[8] << 8 | byArray[9] & 0xFF;
        return n2;
    }

    public int getYDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("No APP0 marker present");
        }
        byte[] byArray = this.findAPP0();
        if (byArray == null) {
            throw new IllegalArgumentException("Can't understand APP0 marker that is present");
        }
        int n2 = byArray[10] << 8 | byArray[11] & 0xFF;
        return n2;
    }

    public boolean isImageInfoValid() {
        return this.imageInfoValid;
    }

    public boolean isTableInfoValid() {
        return this.tableInfoValid;
    }

    static byte[] createDefaultAPP0Marker() {
        byte[] byArray = new byte[]{74, 70, 73, 70, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0};
        return byArray;
    }

    byte[] findAPP0() {
        byte[][] byArray = null;
        byArray = this.getMarkerData(224);
        if (byArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != null && JPEGParam.checkAPP0(byArray[n2])) {
                return byArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public void setQuality(float f2, boolean bl2) {
        double d2 = f2;
        if (d2 <= 0.01) {
            d2 = 0.01;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        d2 = d2 < 0.5 ? 0.5 / d2 : 2.0 - d2 * 2.0;
        this.qTableMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.qTableMapping, 0, this.getNumComponents());
        JPEGQTable jPEGQTable = JPEGQTable.StdLuminance;
        this.qTables[0] = jPEGQTable.getScaledInstance((float)d2, bl2);
        jPEGQTable = JPEGQTable.StdChrominance;
        this.qTables[1] = jPEGQTable.getScaledInstance((float)d2, bl2);
        this.qTables[2] = null;
        this.qTables[3] = null;
    }

    public int getACHuffmanComponentMapping(int n2) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Requested Component doesn't exist.");
        }
        return this.acHuffMapping[n2];
    }

    public int getDCHuffmanComponentMapping(int n2) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Requested Component doesn't exist.");
        }
        return this.dcHuffMapping[n2];
    }

    public int getHorizontalSubsampling(int n2) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.horizontalSubsampling[n2];
    }

    public static int getNumComponents(int n2) {
        if (n2 < 0 || n2 >= 12) {
            throw new IllegalArgumentException("Invalid JPEGColorID.");
        }
        return defComponents[n2];
    }

    public int getQTableComponentMapping(int n2) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Requested Component doesn't exist.");
        }
        return this.qTableMapping[n2];
    }

    public int getVerticalSubsampling(int n2) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.verticalSubsampling[n2];
    }

    public JPEGParam(int n2) {
        this(n2, defComponents[n2]);
    }

    protected void setDefaults(int n2) {
        this.encodedColorID = n2;
        this.restartInterval = 0;
        boolean bl2 = false;
        switch (this.numComponents) {
            case 1: {
                if (this.encodedColorID != 1 && this.encodedColorID != 0) break;
                bl2 = true;
                break;
            }
            case 3: {
                if (this.encodedColorID != 3) break;
                bl2 = true;
                break;
            }
            case 4: {
                if (this.encodedColorID != 4) break;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            this.addMarkerData(224, JPEGParam.createDefaultAPP0Marker());
        }
        this.setTableInfoValid(true);
        this.setImageInfoValid(true);
        this.dcHuffTables[0] = JPEGHuffmanTable.StdDCLuminance;
        this.dcHuffTables[1] = JPEGHuffmanTable.StdDCChrominance;
        this.dcHuffMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.dcHuffMapping, 0, this.getNumComponents());
        this.acHuffTables[0] = JPEGHuffmanTable.StdACLuminance;
        this.acHuffTables[1] = JPEGHuffmanTable.StdACChrominance;
        this.acHuffMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.acHuffMapping, 0, this.getNumComponents());
        this.qTables[0] = JPEGQTable.StdLuminance.getScaledInstance(0.5f, true);
        this.qTables[1] = JPEGQTable.StdChrominance.getScaledInstance(0.5f, true);
        this.qTableMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.qTableMapping, 0, this.getNumComponents());
        this.horizontalSubsampling = new int[this.getNumComponents()];
        System.arraycopy(stdSubsample[this.encodedColorID], 0, this.horizontalSubsampling, 0, this.getNumComponents());
        this.verticalSubsampling = new int[this.getNumComponents()];
        System.arraycopy(stdSubsample[this.encodedColorID], 0, this.verticalSubsampling, 0, this.getNumComponents());
    }

    public void setDensityUnit(int n2) {
        byte[] byArray = null;
        if (!this.getMarker(224)) {
            byArray = JPEGParam.createDefaultAPP0Marker();
            this.addMarkerData(224, byArray);
        } else {
            byArray = this.findAPP0();
            if (byArray == null) {
                throw new IllegalArgumentException("Can't understand APP0 marker that is present");
            }
        }
        byArray[7] = (byte)n2;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public void setRestartInterval(int n2) {
        this.restartInterval = n2;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public void setXDensity(int n2) {
        byte[] byArray = null;
        if (!this.getMarker(224)) {
            byArray = JPEGParam.createDefaultAPP0Marker();
            this.addMarkerData(224, byArray);
        } else {
            byArray = this.findAPP0();
            if (byArray == null) {
                throw new IllegalArgumentException("Can't understand APP0 marker that is present");
            }
        }
        byArray[8] = (byte)(n2 >>> 8 & 0xFF);
        byArray[9] = (byte)(n2 & 0xFF);
    }

    public void setYDensity(int n2) {
        byte[] byArray = null;
        if (!this.getMarker(224)) {
            byArray = JPEGParam.createDefaultAPP0Marker();
            this.addMarkerData(224, byArray);
        } else {
            byArray = this.findAPP0();
            if (byArray == null) {
                throw new IllegalArgumentException("Can't understand APP0 marker that is present");
            }
        }
        byArray[10] = (byte)(n2 >>> 8 & 0xFF);
        byArray[11] = (byte)(n2 & 0xFF);
    }

    public boolean getMarker(int n2) {
        byte[][] byArray = null;
        if (n2 == 254) {
            byArray = this.comMarker;
        } else if (n2 >= 224 && n2 <= 239) {
            byArray = this.appMarkers[n2 - 224];
        } else {
            throw new IllegalArgumentException("Invalid Marker ID:" + n2);
        }
        if (byArray == null) {
            return false;
        }
        return byArray.length != 0;
    }

    public byte[][] getMarkerData(int n2) {
        if (n2 == 254) {
            return this.comMarker;
        }
        if (n2 >= 224 && n2 <= 239) {
            return this.appMarkers[n2 - 224];
        }
        throw new IllegalArgumentException("Invalid Marker ID:" + n2);
    }

    public JPEGParam(int n2, int n3) {
        if (n2 != 0 && n3 != defComponents[n2]) {
            throw new IllegalArgumentException("NumComponents not in sync with COLOR_ID");
        }
        this.qTables = new JPEGQTable[4];
        this.acHuffTables = new JPEGHuffmanTable[4];
        this.dcHuffTables = new JPEGHuffmanTable[4];
        int n4 = 0;
        while (n4 < 4) {
            this.qTables[n4] = null;
            this.dcHuffTables[n4] = null;
            this.acHuffTables[n4] = null;
            ++n4;
        }
        this.comMarker = null;
        this.appMarkers = new byte[16][][];
        this.numComponents = n3;
        this.setDefaults(n2);
    }

    public void setACHuffmanComponentMapping(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Given Component doesn't exist.");
        }
        if (n3 < 0 || n3 >= 4) {
            throw new IllegalArgumentException("Tables must be 0, 1, 2, or 3.");
        }
        this.acHuffMapping[n2] = n3;
    }

    public void setDCHuffmanComponentMapping(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Given Component doesn't exist.");
        }
        if (n3 < 0 || n3 >= 4) {
            throw new IllegalArgumentException("Tables must be 0, 1, 2, or 3.");
        }
        this.dcHuffMapping[n2] = n3;
    }

    public void setHorizontalSubsampling(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components: " + n2);
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("SubSample factor must be positive: " + n3);
        }
        this.horizontalSubsampling[n2] = n3;
    }

    public void setQTableComponentMapping(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Given Component doesn't exist.");
        }
        if (n3 < 0 || n3 >= 4) {
            throw new IllegalArgumentException("Tables must be 0, 1, 2, or 3.");
        }
        this.qTableMapping[n2] = n3;
    }

    public void setVerticalSubsampling(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("SubSample factor must be positive.");
        }
        this.verticalSubsampling[n2] = n3;
    }

    public void addMarkerData(int n2, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if (n2 == 254) {
            this.comMarker = JPEGParam.appendArray(this.comMarker, byArray);
        } else if (n2 >= 224 && n2 <= 239) {
            this.appMarkers[n2 - 224] = JPEGParam.appendArray(this.appMarkers[n2 - 224], byArray);
        } else {
            throw new IllegalArgumentException("Invalid Marker ID:" + n2);
        }
    }

    public void setMarkerData(int n2, byte[][] byArray) {
        if (n2 == 254) {
            this.comMarker = byArray;
        } else if (n2 >= 224 && n2 <= 239) {
            this.appMarkers[n2 - 224] = byArray;
        } else {
            throw new IllegalArgumentException("Invalid Marker ID:" + n2);
        }
    }

    public void setImageInfoValid(boolean bl2) {
        this.imageInfoValid = bl2;
    }

    public void setTableInfoValid(boolean bl2) {
        this.tableInfoValid = bl2;
    }

    static boolean checkAPP0(byte[] byArray) {
        if (byArray.length < 14) {
            return false;
        }
        if (byArray[0] != 74 || byArray[1] != 70 || byArray[2] != 73 || byArray[3] != 70 || byArray[4] != 0) {
            return false;
        }
        return byArray[5] >= 1;
    }

    static byte[] copyArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    static byte[][] copyArrays(byte[][] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[byArray.length][];
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != null) {
                byArrayArray[n2] = JPEGParam.copyArray(byArray[n2]);
            }
            ++n2;
        }
        return byArrayArray;
    }

    static byte[][] appendArray(byte[][] byArray, byte[] byArray2) {
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        byte[][] byArrayArray = new byte[n2 + 1][];
        int n3 = 0;
        while (n3 < n2) {
            byArrayArray[n3] = byArray[n3];
            ++n3;
        }
        if (byArray2 != null) {
            byArrayArray[n2] = JPEGParam.copyArray(byArray2);
        }
        return byArrayArray;
    }

    public JPEGParam(JPEGDecodeParam jPEGDecodeParam) {
        this(jPEGDecodeParam.getEncodedColorID(), jPEGDecodeParam.getNumComponents());
        this.copy(jPEGDecodeParam);
    }

    private void copy(JPEGDecodeParam jPEGDecodeParam) {
        if (this.getEncodedColorID() != jPEGDecodeParam.getEncodedColorID()) {
            throw new IllegalArgumentException("Argument to copy must match current COLOR_ID");
        }
        if (this.getNumComponents() != jPEGDecodeParam.getNumComponents()) {
            throw new IllegalArgumentException("Argument to copy must match in number of components");
        }
        this.setWidth(jPEGDecodeParam.getWidth());
        this.setHeight(jPEGDecodeParam.getHeight());
        int n2 = 224;
        while (n2 < 239) {
            this.setMarkerData(n2, JPEGParam.copyArrays(jPEGDecodeParam.getMarkerData(n2)));
            ++n2;
        }
        this.setMarkerData(254, JPEGParam.copyArrays(jPEGDecodeParam.getMarkerData(254)));
        this.setTableInfoValid(jPEGDecodeParam.isTableInfoValid());
        this.setImageInfoValid(jPEGDecodeParam.isImageInfoValid());
        this.setRestartInterval(jPEGDecodeParam.getRestartInterval());
        int n3 = 0;
        while (n3 < 4) {
            this.setDCHuffmanTable(n3, jPEGDecodeParam.getDCHuffmanTable(n3));
            this.setACHuffmanTable(n3, jPEGDecodeParam.getACHuffmanTable(n3));
            this.setQTable(n3, jPEGDecodeParam.getQTable(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 < jPEGDecodeParam.getNumComponents()) {
            this.setDCHuffmanComponentMapping(n4, jPEGDecodeParam.getDCHuffmanComponentMapping(n4));
            this.setACHuffmanComponentMapping(n4, jPEGDecodeParam.getACHuffmanComponentMapping(n4));
            this.setQTableComponentMapping(n4, jPEGDecodeParam.getQTableComponentMapping(n4));
            this.setHorizontalSubsampling(n4, jPEGDecodeParam.getHorizontalSubsampling(n4));
            this.setVerticalSubsampling(n4, jPEGDecodeParam.getVerticalSubsampling(n4));
            ++n4;
        }
    }

    public JPEGParam(JPEGEncodeParam jPEGEncodeParam) {
        this(jPEGEncodeParam.getEncodedColorID(), jPEGEncodeParam.getNumComponents());
        this.copy(jPEGEncodeParam);
    }

    private void copy(JPEGEncodeParam jPEGEncodeParam) {
        this.copy((JPEGDecodeParam)jPEGEncodeParam);
    }

    public JPEGHuffmanTable getACHuffmanTable(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("tableNum must be 0-3.");
        }
        return this.acHuffTables[n2];
    }

    public JPEGHuffmanTable getACHuffmanTableForComponent(int n2) {
        if (n2 < 0 || n2 >= this.acHuffMapping.length) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.getACHuffmanTable(this.acHuffMapping[n2]);
    }

    public JPEGHuffmanTable getDCHuffmanTable(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("tableNum must be 0-3.");
        }
        return this.dcHuffTables[n2];
    }

    public JPEGHuffmanTable getDCHuffmanTableForComponent(int n2) {
        if (n2 < 0 || n2 >= this.dcHuffMapping.length) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.getDCHuffmanTable(this.dcHuffMapping[n2]);
    }

    public void setACHuffmanTable(int n2, JPEGHuffmanTable jPEGHuffmanTable) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("tableNum must be 0, 1, 2, or 3.");
        }
        this.acHuffTables[n2] = jPEGHuffmanTable;
    }

    public void setDCHuffmanTable(int n2, JPEGHuffmanTable jPEGHuffmanTable) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("tableNum must be 0, 1, 2, or 3.");
        }
        this.dcHuffTables[n2] = jPEGHuffmanTable;
    }

    public JPEGQTable getQTable(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("tableNum must be between 0 and 3.");
        }
        return this.qTables[n2];
    }

    public JPEGQTable getQTableForComponent(int n2) {
        if (n2 < 0 || n2 >= this.qTableMapping.length) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.getQTable(this.qTableMapping[n2]);
    }

    public void setQTable(int n2, JPEGQTable jPEGQTable) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("tableNum must be between 0 and 3.");
        }
        this.qTables[n2] = jPEGQTable;
    }

    public static int getDefaultColorId(ColorModel colorModel) {
        boolean bl2 = colorModel.hasAlpha();
        ColorSpace colorSpace = colorModel.getColorSpace();
        ColorSpace colorSpace2 = null;
        switch (colorSpace.getType()) {
            case 6: {
                return 1;
            }
            case 5: {
                if (bl2) {
                    return 7;
                }
                return 3;
            }
            case 3: {
                if (colorSpace2 == null) {
                    try {
                        colorSpace2 = ColorSpace.getInstance(1002);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (colorSpace == colorSpace2) {
                    return bl2 ? 10 : 5;
                }
                return bl2 ? 7 : 3;
            }
            case 9: {
                return 4;
            }
        }
        return 0;
    }

    public Object clone() {
        JPEGParam jPEGParam = new JPEGParam(this.getEncodedColorID(), this.getNumComponents());
        jPEGParam.copy(this);
        return jPEGParam;
    }

    static byte[][] buildArray(Vector vector) {
        if (vector == null) {
            return null;
        }
        int n2 = 0;
        byte[][] byArrayArray = new byte[vector.size()][];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])enumeration.nextElement();
            if (byArray == null) continue;
            byArrayArray[n2++] = JPEGParam.copyArray(byArray);
        }
        return byArrayArray;
    }
}

