/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import sun.awt.image.ImageFetcher;
import sun.misc.Ref;

public abstract class PixelStore
extends Ref {
    int width;
    int height;
    ColorModel colormodel;
    Hashtable properties;
    boolean[] seen;
    int numlines;
    int availinfo;
    int hints;
    static final int NO_BITS_YET = 0;
    static final int BITS_ALLOCATED = 1;
    static final int BITS_LOST = 2;
    int bit_state = 0;
    int[] offsets;

    public synchronized int getBitState() {
        if (this.bit_state == 1 && this.numlines > 0) {
            Object object = this.get();
        }
        return this.bit_state;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public PixelStore() {
    }

    public synchronized void imageComplete() {
        if (this.get() != null && this.bit_state == 1) {
            this.hints = 30;
            this.availinfo |= 0x20;
        }
    }

    public synchronized void setHints(int n2) {
        this.hints = n2;
    }

    public PixelStore(int n2, int n3) {
        this.setDimensions(n2, n3);
    }

    public synchronized void setDimensions(int n2, int n3) {
        this.width = n2;
        this.height = n3;
        this.availinfo |= 3;
    }

    protected void recordPixels(int n2, int n3, int n4, int n5) {
        this.numlines = Math.max(this.numlines, n3 + n5);
        if ((this.hints & 2) == 0) {
            if (this.seen == null) {
                this.seen = new boolean[this.height];
            }
            int n6 = 0;
            while (n6 < n5) {
                this.seen[n3 + n6] = true;
                ++n6;
            }
        }
    }

    public synchronized boolean setPixels(int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) {
        this.recordPixels(n2, n3, n4, n5);
        Object[] objectArray = (Object[])this.get();
        if (objectArray != null) {
            int n8 = n6;
            int n9 = n3;
            while (n9 < n3 + n5) {
                byte[] byArray2 = (byte[])objectArray[n9];
                int n10 = this.offsets[n9] + n2;
                System.arraycopy(byArray, n8, byArray2, n10, n4);
                n8 += n7;
                ++n9;
            }
            this.availinfo |= 8;
        }
        return objectArray != null;
    }

    public synchronized boolean setPixels(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        this.recordPixels(n2, n3, n4, n5);
        Object[] objectArray = (Object[])this.get();
        if (objectArray != null) {
            int n8 = n6;
            int n9 = n3;
            while (n9 < n3 + n5) {
                int[] nArray2 = (int[])objectArray[n9];
                int n10 = this.offsets[n9] + n2;
                System.arraycopy(nArray, n8, nArray2, n10, n4);
                n8 += n7;
                ++n9;
            }
            this.availinfo |= 8;
        }
        return objectArray != null;
    }

    public synchronized ColorModel getColorModel() {
        return this.colormodel;
    }

    public PixelStore(int n2, int n3, ColorModel colorModel) {
        this.setDimensions(n2, n3);
        this.setColorModel(colorModel);
    }

    public synchronized void setColorModel(ColorModel colorModel) {
        this.colormodel = colorModel;
    }

    public Object reconstitute() {
        Object[] objectArray = null;
        if (this.bit_state == 0) {
            if ((this.availinfo & 2) == 0 || (this.availinfo & 1) == 0 || this.colormodel == null) {
                return null;
            }
            this.bit_state = 1;
            objectArray = new Object[this.height];
            this.offsets = new int[this.height];
            int n2 = 0;
            while (n2 < this.height) {
                int n3 = this.height - n2;
                Object object = null;
                while (object == null && n3 > 0) {
                    try {
                        object = this.allocateLines(n3);
                        if (object != null) continue;
                        break;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        object = null;
                        n3 /= 2;
                    }
                }
                if (object == null) {
                    this.bit_state = 2;
                    return null;
                }
                int n4 = 0;
                while (n3 > 0) {
                    objectArray[n2] = object;
                    this.offsets[n2] = n4;
                    n4 += this.width;
                    ++n2;
                    --n3;
                }
            }
        } else if (this.bit_state == 1) {
            this.bit_state = 2;
        }
        return objectArray;
    }

    abstract Object allocateLines(int var1);

    public synchronized void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
        this.availinfo |= 4;
    }

    public synchronized boolean replay(ImageProducer imageProducer, ImageConsumer imageConsumer) {
        return this.replay(imageProducer, imageConsumer, true);
    }

    public synchronized boolean replay(ImageProducer imageProducer, ImageConsumer imageConsumer, boolean bl2) {
        if (bl2 && (this.availinfo & 1) != 0 && (this.availinfo & 2) != 0) {
            imageConsumer.setDimensions(this.width, this.height);
            if (!imageProducer.isConsumer(imageConsumer)) {
                return true;
            }
        }
        if (bl2 && (this.availinfo & 4) != 0) {
            imageConsumer.setProperties(this.properties);
        }
        if (bl2 && this.colormodel != null) {
            imageConsumer.setColorModel(this.colormodel);
            if (!imageProducer.isConsumer(imageConsumer)) {
                return true;
            }
        }
        if (this.hints != 0) {
            imageConsumer.setHints(this.hints & 0x1E);
            if (!imageProducer.isConsumer(imageConsumer)) {
                return true;
            }
        }
        Object[] objectArray = null;
        if (this.bit_state == 1 && this.numlines > 0) {
            objectArray = (Object[])this.get();
        }
        if (this.bit_state == 2) {
            return false;
        }
        Thread thread = Thread.currentThread();
        if (ImageFetcher.isFetcher(thread) && thread.getPriority() > 3) {
            thread.setPriority(3);
        }
        if (objectArray != null) {
            Object object = null;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.numlines) {
                if (this.seen != null && !this.seen[n3]) {
                    if (object != null) {
                        this.replayLines(imageConsumer, n3 - n2, n2, object);
                        if (!imageProducer.isConsumer(imageConsumer)) {
                            return true;
                        }
                        object = null;
                        n2 = 0;
                    }
                } else {
                    Object object2 = objectArray[n3];
                    if (object != object2 && object != null) {
                        this.replayLines(imageConsumer, n3 - n2, n2, object);
                        if (!imageProducer.isConsumer(imageConsumer)) {
                            return true;
                        }
                        n2 = 0;
                    }
                    object = object2;
                    ++n2;
                }
                ++n3;
            }
            if (object != null) {
                this.replayLines(imageConsumer, this.numlines - n2, n2, object);
                if (!imageProducer.isConsumer(imageConsumer)) {
                    return true;
                }
            }
        }
        if (bl2 && this.bit_state == 1 && (this.availinfo & 0x20) != 0) {
            imageConsumer.imageComplete(3);
        }
        return true;
    }

    abstract void replayLines(ImageConsumer var1, int var2, int var3, Object var4);
}

