/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.IntegerComponentRaster;

public class IntegerInterleavedRaster
extends IntegerComponentRaster {
    private int maxX;
    private int maxY;

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int[] getDataStorage() {
        return this.data;
    }

    public int getDataOffset(int n2) {
        return this.dataOffsets[n2];
    }

    private void verify(boolean bl2) {
        int n2 = (this.height - 1) * this.scanlineStride + (this.width - 1) + this.dataOffsets[0];
        int n3 = 0;
        if (n2 > n3) {
            n3 = n2;
        }
        if (this.data.length < n3) {
            throw new RasterFormatException("Data array too small (should be " + n3 + " but is " + this.data.length + " )");
        }
    }

    public Raster createChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        return this.createWritableChild(n2, n3, n4, n5, n6, n7, nArray);
    }

    private void setDataElements(int n2, int n3, int n4, int n5, Raster raster) {
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int[] nArray = null;
        if (raster instanceof IntegerInterleavedRaster) {
            int n8;
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)raster;
            nArray = integerInterleavedRaster.getDataStorage();
            int n9 = integerInterleavedRaster.getScanlineStride();
            int n10 = n8 = integerInterleavedRaster.getDataOffset(0);
            int n11 = this.dataOffsets[0] + (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
            int n12 = 0;
            while (n12 < n5) {
                System.arraycopy(nArray, n10, this.data, n11, n4);
                n10 += n9;
                n11 += this.scanlineStride;
                ++n12;
            }
            this.notifyChanged();
            return;
        }
        Object object = null;
        int n13 = 0;
        while (n13 < n5) {
            object = raster.getDataElements(n6, n7 + n13, n4, 1, object);
            this.setDataElements(n2, n3 + n13, n4, 1, object);
            ++n13;
        }
    }

    public void setDataElements(int n2, int n3, Raster raster) {
        int n4 = n2 + raster.getMinX();
        int n5 = n3 + raster.getMinY();
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        if (n4 < this.minX || n5 < this.minY || n4 + n6 > this.maxX || n5 + n7 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n4, n5, n6, n7, raster);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new RasterFormatException("negative " + (n2 <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n2, n3);
        return new IntegerInterleavedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        this.notifyStolen();
        return new IntegerInterleavedRaster(sampleModel, this.dataBuffer, new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = (int[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) + this.dataOffsets[0];
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            System.arraycopy(nArray, n7, this.data, n6, n4);
            n7 += n4;
            n6 += this.scanlineStride;
            ++n8;
        }
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = (int[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) + this.dataOffsets[0];
        this.data[n4] = nArray[0];
        this.notifyChanged();
    }

    public String toString() {
        return new String("IntegerInterleavedRaster: width = " + this.width + " height = " + this.height + " #Bands = " + this.numBands + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY + " dataOffset[0] " + this.dataOffsets[0]);
    }

    public IntegerInterleavedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = object instanceof int[] ? (int[])object : new int[n4 * n5];
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) + this.dataOffsets[0];
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            System.arraycopy(this.data, n6, nArray, n7, n4);
            n7 += n4;
            n6 += this.scanlineStride;
            ++n8;
        }
        return nArray;
    }

    public Object getDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = object == null ? new int[1] : (int[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) + this.dataOffsets[0];
        nArray[0] = this.data[n4];
        return nArray;
    }

    public IntegerInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public IntegerInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, IntegerInterleavedRaster integerInterleavedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, integerInterleavedRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferInt)) {
            throw new RasterFormatException("IntegerInterleavedRasters must haveinteger DataBuffers");
        }
        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
        this.data = dataBufferInt.getData();
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new RasterFormatException("IntegerInterleavedRasters must have SinglePixelPackedSampleModel");
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
        this.pixelStride = 1;
        this.dataOffsets = new int[1];
        this.dataOffsets[0] = dataBufferInt.getOffset();
        this.bandOffset = this.dataOffsets[0];
        int n2 = rectangle.x - point.x;
        int n3 = rectangle.y - point.y;
        this.dataOffsets[0] = this.dataOffsets[0] + (n2 + n3 * this.scanlineStride);
        this.numDataElems = singlePixelPackedSampleModel.getNumDataElements();
        this.verify(false);
    }
}

