/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.Image;
import sun.awt.image.ImageWatched;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;

public class ImageRepresentation
extends ImageWatched
implements ImageConsumer {
    InputStreamImageSource src;
    Image image;
    int tag;
    long pData;
    int width = -1;
    int height = -1;
    int hints;
    int availinfo;
    Rectangle newbits;
    BufferedImage bimage;
    WritableRaster biRaster;
    protected ColorModel cmodel;
    ColorModel srcModel = null;
    int[] srcLUT = null;
    int srcLUTtransIndex = -1;
    int numSrcLUT = 0;
    boolean forceCMhint;
    int sstride;
    boolean isDefaultBI = false;
    boolean isSameCM = false;
    static boolean s_useNative;
    private boolean consuming = false;
    private int numWaiters;

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    static {
        NativeLibLoader.loadLibraries();
        ImageRepresentation.initIDs();
        s_useNative = true;
    }

    synchronized void abort() {
        this.image.getSource().removeConsumer(this);
        this.consuming = false;
        this.newbits = null;
        this.bimage = null;
        this.biRaster = null;
        this.cmodel = null;
        this.srcLUT = null;
        this.isDefaultBI = false;
        this.isSameCM = false;
        this.newInfo(this.image, 128, -1, -1, -1, -1);
        this.availinfo &= 0xFFFFFF87;
    }

    private synchronized void checkConsumption() {
        if (this.watchers == null && this.numWaiters == 0 && (this.availinfo & 0x20) == 0) {
            this.dispose();
        }
    }

    private void convertToRGB() {
        Object[] objectArray;
        Object object;
        int n2 = this.bimage.getWidth();
        int n3 = this.bimage.getHeight();
        int n4 = n2 * n3;
        int[] nArray = new int[n4];
        if (this.cmodel instanceof IndexColorModel && this.biRaster instanceof ByteComponentRaster && this.biRaster.getNumDataElements() == 1) {
            object = (ByteComponentRaster)this.biRaster;
            objectArray = ((ByteComponentRaster)object).getDataStorage();
            int n5 = ((ByteComponentRaster)object).getDataOffset(0);
            int n6 = 0;
            while (n6 < n4) {
                nArray[n6] = this.srcLUT[objectArray[n5 + n6] & 0xFF];
                ++n6;
            }
        } else {
            object = null;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = 0;
                while (n9 < n2) {
                    object = this.biRaster.getDataElements(n9, n8, object);
                    nArray[n7++] = this.cmodel.getRGB(object);
                    ++n9;
                }
                ++n8;
            }
        }
        this.isSameCM = false;
        this.cmodel = ColorModel.getRGBdefault();
        object = new DataBufferInt(nArray, nArray.length);
        objectArray = new int[]{0xFF0000, 65280, 255, -16777216};
        this.biRaster = Raster.createPackedRaster((DataBuffer)object, n2, n3, n2, objectArray, null);
        this.bimage = this.createImage(this.cmodel, this.biRaster, this.cmodel.isAlphaPremultiplied(), null);
        this.srcLUT = null;
        this.isDefaultBI = true;
    }

    void createBufferedImage() {
        DirectColorModel directColorModel;
        this.isDefaultBI = false;
        try {
            this.biRaster = this.cmodel.createCompatibleWritableRaster(this.width, this.height);
            this.bimage = this.createImage(this.cmodel, this.biRaster, this.cmodel.isAlphaPremultiplied(), null);
        }
        catch (Exception exception) {
            this.cmodel = ColorModel.getRGBdefault();
            this.biRaster = this.cmodel.createCompatibleWritableRaster(this.width, this.height);
            this.bimage = this.createImage(this.cmodel, this.biRaster, false, null);
        }
        int n2 = this.bimage.getType();
        if (this.cmodel == ColorModel.getRGBdefault() || n2 == 1 || n2 == 3) {
            this.isDefaultBI = true;
        } else if (this.cmodel instanceof DirectColorModel && (directColorModel = (DirectColorModel)this.cmodel).getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255) {
            this.isDefaultBI = true;
        }
    }

    private synchronized void decrementWaiters() {
        --this.numWaiters;
        this.checkConsumption();
    }

    synchronized void dispose() {
        this.image.getSource().removeConsumer(this);
        this.consuming = false;
        this.newbits = null;
        this.availinfo &= 0xFFFFFFC7;
    }

    private static native void initIDs();

    void startProduction() {
        if (!this.consuming) {
            this.consuming = true;
            this.image.getSource().startProduction(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageComplete(int n2) {
        int n3;
        boolean bl2;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        switch (n2) {
            default: {
                bl2 = true;
                n3 = 128;
                break;
            }
            case 1: {
                this.image.addInfo(64);
                bl2 = true;
                n3 = 64;
                this.dispose();
                break;
            }
            case 3: {
                bl2 = true;
                n3 = 32;
                break;
            }
            case 2: {
                bl2 = false;
                n3 = 16;
            }
        }
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            if (bl2) {
                this.image.getSource().removeConsumer(this);
                this.consuming = false;
                this.newbits = null;
                if (this.bimage != null) {
                    this.bimage = this.getOpaqueRGBImage();
                }
            }
            this.availinfo |= n3;
            this.notifyAll();
        }
        this.newInfo(this.image, n3, 0, 0, this.width, this.height);
        this.image.infoDone(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void reconstruct(int n2) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        int n3 = n2 & ~this.availinfo;
        if ((this.availinfo & 0x40) != 0) return;
        if (n3 == 0) return;
        ++this.numWaiters;
        try {
            this.startProduction();
            n3 = n2 & ~this.availinfo;
            while (true) {
                block10: {
                    block9: {
                        if ((this.availinfo & 0x40) != 0) break block9;
                        if (n3 != 0) break block10;
                    }
                    Object var5_5 = null;
                    this.decrementWaiters();
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    Object var5_4 = null;
                    this.decrementWaiters();
                    return;
                }
                n3 = n2 & ~this.availinfo;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.decrementWaiters();
            throw throwable;
        }
    }

    public void setHints(int n2) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.hints = n2;
    }

    public void setDimensions(int n2, int n3) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.image.setDimensions(n2, n3);
        this.newInfo(this.image, 3, 0, 0, n2, n3);
        if (n2 <= 0 || n3 <= 0) {
            this.imageComplete(1);
            return;
        }
        this.width = n2;
        this.height = n3;
        this.availinfo |= 3;
    }

    BufferedImage getBufferedImage() {
        return this.bimage;
    }

    public BufferedImage getOpaqueRGBImage() {
        if (this.bimage.getType() == 2) {
            int n2 = this.bimage.getWidth();
            int n3 = this.bimage.getHeight();
            int n4 = n2 * n3;
            DataBufferInt dataBufferInt = (DataBufferInt)this.biRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            int n5 = 0;
            while (n5 < n4) {
                if (nArray[n5] >>> 24 != 255) {
                    return this.bimage;
                }
                ++n5;
            }
            DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
            int[] nArray2 = new int[]{0xFF0000, 65280, 255};
            WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n2, n3, n2, nArray2, null);
            try {
                BufferedImage bufferedImage = this.createImage(directColorModel, writableRaster, false, null);
                return bufferedImage;
            }
            catch (Exception exception) {
                return this.bimage;
            }
        }
        return this.bimage;
    }

    ColorModel getColorModel() {
        return this.cmodel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        int n8 = n6;
        Object var11_10 = null;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            int n9;
            Object object;
            Object object2;
            if (this.bimage == null) {
                if (this.cmodel == null) {
                    this.cmodel = colorModel;
                }
                this.createBufferedImage();
            }
            if (this.isSameCM && this.cmodel != colorModel && this.srcLUT != null && colorModel instanceof IndexColorModel && this.biRaster instanceof ByteComponentRaster) {
                object2 = (IndexColorModel)colorModel;
                object = (ByteComponentRaster)this.biRaster;
                n9 = this.numSrcLUT;
                if (this.setDiffICM(n2, n3, n4, n5, this.srcLUT, this.srcLUTtransIndex, this.numSrcLUT, (IndexColorModel)object2, byArray, n6, n7, (ByteComponentRaster)object, ((ByteComponentRaster)object).getDataOffset(0)) == 0) {
                    ((SunWritableRaster)object).notifyChanged();
                    this.convertToRGB();
                } else {
                    if (n9 != this.numSrcLUT) {
                        int n10;
                        boolean bl2 = ((ColorModel)object2).hasAlpha();
                        if (this.srcLUTtransIndex != -1) {
                            bl2 = true;
                        }
                        this.cmodel = object2 = new IndexColorModel(n10, this.numSrcLUT, this.srcLUT, 0, bl2, this.srcLUTtransIndex, (n10 = ((ColorModel)object2).getPixelSize()) > 8 ? 1 : 0);
                        this.bimage = this.createImage((ColorModel)object2, (WritableRaster)object, false, null);
                    }
                    return;
                }
            }
            if (this.isDefaultBI) {
                object = (IntegerComponentRaster)this.biRaster;
                if (this.srcLUT != null && colorModel instanceof IndexColorModel) {
                    if (colorModel != this.srcModel) {
                        ((IndexColorModel)colorModel).getRGBs(this.srcLUT);
                        this.srcModel = colorModel;
                    }
                    if (s_useNative) {
                        ((SunWritableRaster)object).notifyChanged();
                        this.setICMpixels(n2, n3, n4, n5, this.srcLUT, byArray, n6, n7, (IntegerComponentRaster)object);
                    } else {
                        int[] nArray = new int[n4 * n5];
                        int n11 = 0;
                        int n12 = 0;
                        while (n12 < n5) {
                            int n13 = n8;
                            int n14 = 0;
                            while (n14 < n4) {
                                nArray[n11++] = this.srcLUT[byArray[n13++] & 0xFF];
                                ++n14;
                            }
                            ++n12;
                            n8 += n7;
                        }
                        ((IntegerComponentRaster)object).setDataElements(n2, n3, n4, n5, nArray);
                    }
                } else {
                    int[] nArray = new int[n4];
                    int n15 = n3;
                    while (n15 < n3 + n5) {
                        int n16 = n8;
                        int n17 = 0;
                        while (n17 < n4) {
                            nArray[n17] = colorModel.getRGB(byArray[n16++] & 0xFF);
                            ++n17;
                        }
                        ((IntegerComponentRaster)object).setDataElements(n2, n15, n4, 1, nArray);
                        ++n15;
                        n8 += n7;
                    }
                    this.availinfo |= 8;
                }
            } else if (this.cmodel == colorModel && this.biRaster instanceof ByteComponentRaster && this.biRaster.getNumDataElements() == 1) {
                object2 = (ByteComponentRaster)this.biRaster;
                if (n4 * n5 > 200) {
                    if (n6 == 0 && n7 == n4) {
                        ((ByteComponentRaster)object2).putByteData(n2, n3, n4, n5, byArray);
                    } else {
                        object = new byte[n4];
                        int n18 = n6;
                        n9 = n3;
                        while (n9 < n3 + n5) {
                            System.arraycopy(byArray, n18, object, 0, n4);
                            ((ByteComponentRaster)object2).putByteData(n2, n9, n4, 1, (byte[])object);
                            n18 += n7;
                            ++n9;
                        }
                    }
                } else {
                    ((SunWritableRaster)object2).notifyChanged();
                    this.setBytePixels(n2, n3, n4, n5, byArray, n6, n7, (ByteComponentRaster)object2, ((ByteComponentRaster)object2).getDataOffset(0));
                }
            } else {
                int n19 = n3;
                while (n19 < n3 + n5) {
                    int n20 = n8;
                    int n21 = n2;
                    while (n21 < n2 + n4) {
                        this.bimage.setRGB(n21, n19, colorModel.getRGB(byArray[n20++] & 0xFF));
                        ++n21;
                    }
                    ++n19;
                    n8 += n7;
                }
                this.availinfo |= 8;
            }
        }
        if ((this.availinfo & 0x10) == 0) {
            this.newInfo(this.image, 8, n2, n3, n4, n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        int n8 = n6;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            if (this.bimage == null) {
                if (this.cmodel == null) {
                    this.cmodel = colorModel;
                }
                this.createBufferedImage();
            }
            int[] nArray2 = new int[n4];
            if (this.cmodel instanceof IndexColorModel) {
                this.convertToRGB();
            }
            if (colorModel == this.cmodel && this.biRaster instanceof IntegerComponentRaster) {
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)this.biRaster;
                if (n6 == 0 && n7 == n4) {
                    integerComponentRaster.setDataElements(n2, n3, n4, n5, nArray);
                } else {
                    int n9 = n3;
                    while (n9 < n3 + n5) {
                        System.arraycopy(nArray, n8, nArray2, 0, n4);
                        integerComponentRaster.setDataElements(n2, n9, n4, 1, nArray2);
                        ++n9;
                        n8 += n7;
                    }
                }
            } else {
                if (colorModel.getTransparency() != 1) {
                    if (this.cmodel.getTransparency() == 1) {
                        this.convertToRGB();
                    }
                }
                if (this.isDefaultBI) {
                    IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)this.biRaster;
                    int[] nArray3 = integerComponentRaster.getDataStorage();
                    if (this.cmodel.equals(colorModel)) {
                        int n10 = integerComponentRaster.getScanlineStride();
                        int n11 = n3 * n10 + n2;
                        int n12 = 0;
                        while (n12 < n5) {
                            System.arraycopy(nArray, n8, nArray3, n11, n4);
                            n11 += n10;
                            ++n12;
                            n8 += n7;
                        }
                    } else {
                        int n13 = n3;
                        while (n13 < n3 + n5) {
                            int n14 = n8;
                            int n15 = 0;
                            while (n15 < n4) {
                                nArray2[n15] = colorModel.getRGB(nArray[n14++]);
                                ++n15;
                            }
                            integerComponentRaster.setDataElements(n2, n13, n4, 1, nArray2);
                            ++n13;
                            n8 += n7;
                        }
                    }
                    this.availinfo |= 8;
                } else {
                    Object object = null;
                    int n16 = n3;
                    while (n16 < n3 + n5) {
                        int n17 = n8;
                        int n18 = n2;
                        while (n18 < n2 + n4) {
                            int n19 = colorModel.getRGB(nArray[n17++]);
                            object = this.cmodel.getDataElements(n19, object);
                            this.biRaster.setDataElements(n18, n16, object);
                            ++n18;
                        }
                        ++n16;
                        n8 += n7;
                    }
                    this.availinfo |= 8;
                }
            }
        }
        if ((this.availinfo & 0x10) == 0) {
            this.newInfo(this.image, 8, n2, n3, n4, n5);
        }
    }

    public void setColorModel(ColorModel colorModel) {
        DirectColorModel directColorModel;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.srcModel = colorModel;
        if (colorModel instanceof IndexColorModel) {
            if (colorModel.getTransparency() == 3) {
                this.cmodel = ColorModel.getRGBdefault();
                this.srcLUT = null;
            } else {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                this.numSrcLUT = indexColorModel.getMapSize();
                this.srcLUT = new int[Math.max(this.numSrcLUT, 256)];
                indexColorModel.getRGBs(this.srcLUT);
                this.srcLUTtransIndex = indexColorModel.getTransparentPixel();
                this.cmodel = colorModel;
            }
        } else if (this.cmodel == null) {
            this.cmodel = colorModel;
            this.srcLUT = null;
        } else if (colorModel instanceof DirectColorModel && (directColorModel = (DirectColorModel)colorModel).getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255) {
            this.cmodel = colorModel;
            this.srcLUT = null;
        }
        this.isSameCM = this.cmodel == colorModel;
    }

    public int check(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x60) == 0) {
            this.addWatcher(imageObserver);
        }
        return this.availinfo;
    }

    public synchronized void removeWatcher(ImageObserver imageObserver) {
        super.removeWatcher(imageObserver);
        this.checkConsumption();
    }

    public boolean prepare(ImageObserver imageObserver) {
        boolean bl2;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl3 = bl2 = (this.availinfo & 0x20) != 0;
        if (!bl2) {
            this.addWatcher(imageObserver);
            this.startProduction();
            bl2 = (this.availinfo & 0x20) != 0;
        }
        return bl2;
    }

    public void setProperties(Hashtable hashtable) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.image.setProperties(hashtable);
        this.newInfo(this.image, 4, 0, 0, 0, 0);
    }

    public native void setBytePixels(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, ByteComponentRaster var8, int var9);

    public native void setICMpixels(int var1, int var2, int var3, int var4, int[] var5, byte[] var6, int var7, int var8, IntegerComponentRaster var9);

    public ImageRepresentation(Image image, ColorModel colorModel, boolean bl2) {
        this.image = image;
        if (this.image.getSource() instanceof InputStreamImageSource) {
            this.src = (InputStreamImageSource)this.image.getSource();
        }
        this.setColorModel(colorModel);
        this.forceCMhint = bl2;
    }

    public native int setDiffICM(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7, IndexColorModel var8, byte[] var9, int var10, int var11, ByteComponentRaster var12, int var13);

    protected BufferedImage createImage(ColorModel colorModel, WritableRaster writableRaster, boolean bl2, Hashtable hashtable) {
        return new BufferedImage(colorModel, writableRaster, bl2, null);
    }

    public boolean drawToBufImage(Graphics graphics, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        boolean bl2;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl3 = (this.availinfo & 0x20) != 0;
        boolean bl4 = bl2 = (this.availinfo & 0x80) != 0;
        if (!bl3 && !bl2) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl5 = bl3 = (this.availinfo & 0x20) != 0;
        }
        if (bl3 || 0 != (this.availinfo & 0x10)) {
            graphics.drawImage(this.bimage, n2, n3, n4, n5, n6, n7, n8, n9, color, null);
        }
        return bl3;
    }

    public boolean drawToBufImage(Graphics graphics, Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        boolean bl2;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl3 = (this.availinfo & 0x20) != 0;
        boolean bl4 = bl2 = (this.availinfo & 0x80) != 0;
        if (!bl3 && !bl2) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl5 = bl3 = (this.availinfo & 0x20) != 0;
        }
        if (bl3 || 0 != (this.availinfo & 0x10)) {
            graphics.drawImage(this.bimage, n2, n3, n4, n5, color, null);
        }
        return bl3;
    }

    public boolean drawToBufImage(Graphics graphics, Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        boolean bl2;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl3 = (this.availinfo & 0x20) != 0;
        boolean bl4 = bl2 = (this.availinfo & 0x80) != 0;
        if (!bl3 && !bl2) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl5 = bl3 = (this.availinfo & 0x20) != 0;
        }
        if (bl3 || 0 != (this.availinfo & 0x10)) {
            graphics.drawImage(this.bimage, n2, n3, color, null);
        }
        return bl3;
    }

    public boolean drawToBufImage(Graphics graphics, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl3 = (this.availinfo & 0x20) != 0;
        boolean bl4 = bl2 = (this.availinfo & 0x80) != 0;
        if (!bl3 && !bl2) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl5 = bl3 = (this.availinfo & 0x20) != 0;
        }
        if (bl3 || 0 != (this.availinfo & 0x10)) {
            graphics2D.drawImage(this.bimage, affineTransform, null);
        }
        return bl3;
    }
}

