/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.awt.AppContext;
import sun.awt.image.FetcherInfo;
import sun.awt.image.ImageFetchable;

class ImageFetcher
extends Thread {
    static final int HIGH_PRIORITY = 8;
    static final int LOW_PRIORITY = 3;
    static final int ANIM_PRIORITY = 2;
    static final int TIMEOUT = 5000;

    private void fetchloop() {
        Thread thread = Thread.currentThread();
        while (ImageFetcher.isFetcher(thread)) {
            if (Thread.interrupted()) {
                return;
            }
            thread.setPriority(8);
            ImageFetchable imageFetchable = ImageFetcher.nextImage();
            if (imageFetchable == null) {
                return;
            }
            try {
                imageFetchable.doFetch();
            }
            catch (Exception exception) {
                System.err.println("Uncaught error fetching image:");
                exception.printStackTrace();
            }
            ImageFetcher.stoppingAnimation(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block19: {
            Throwable throwable2;
            Vector vector;
            FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
            try {
                this.fetchloop();
                vector = fetcherInfo.waitList;
            }
            catch (Exception exception) {
                Vector vector2;
                try {
                    exception.printStackTrace();
                    vector2 = fetcherInfo.waitList;
                }
                catch (Throwable throwable2) {
                    Vector vector3 = fetcherInfo.waitList;
                    synchronized (vector3) {
                        Thread thread = Thread.currentThread();
                        int n2 = 0;
                        while (n2 < fetcherInfo.fetchers.length) {
                            if (fetcherInfo.fetchers[n2] == thread) {
                                fetcherInfo.fetchers[n2] = null;
                                --fetcherInfo.numFetchers;
                            }
                            ++n2;
                        }
                    }
                }
                synchronized (vector2) {
                    Thread thread = Thread.currentThread();
                    int n3 = 0;
                    while (n3 < fetcherInfo.fetchers.length) {
                        if (fetcherInfo.fetchers[n3] == thread) {
                            fetcherInfo.fetchers[n3] = null;
                            --fetcherInfo.numFetchers;
                        }
                        ++n3;
                    }
                    break block19;
                }
            }
            synchronized (vector) {
                Thread thread = Thread.currentThread();
                int n4 = 0;
                while (n4 < fetcherInfo.fetchers.length) {
                    if (fetcherInfo.fetchers[n4] == thread) {
                        fetcherInfo.fetchers[n4] = null;
                        --fetcherInfo.numFetchers;
                    }
                    ++n4;
                }
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startingAnimation() {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Thread thread = Thread.currentThread();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < fetcherInfo.fetchers.length) {
                if (fetcherInfo.fetchers[n2] == thread) {
                    fetcherInfo.fetchers[n2] = null;
                    --fetcherInfo.numFetchers;
                    thread.setName("Image Animator " + n2);
                    if (fetcherInfo.waitList.size() > fetcherInfo.numWaiting) {
                        ImageFetcher.createFetchers(fetcherInfo);
                    }
                    return;
                }
                ++n2;
            }
        }
        thread.setPriority(2);
        thread.setName("Image Animator");
    }

    public static boolean amFetcher() {
        return ImageFetcher.isFetcher(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stoppingAnimation(Thread thread) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            int n2 = -1;
            int n3 = 0;
            while (n3 < fetcherInfo.fetchers.length) {
                if (fetcherInfo.fetchers[n3] == thread) {
                    return;
                }
                if (fetcherInfo.fetchers[n3] == null) {
                    n2 = n3;
                }
                ++n3;
            }
            if (n2 >= 0) {
                fetcherInfo.fetchers[n2] = thread;
                ++fetcherInfo.numFetchers;
                thread.setName("Image Fetcher " + n2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFetcher(Thread thread) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < fetcherInfo.fetchers.length) {
                if (fetcherInfo.fetchers[n2] == thread) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private ImageFetcher(ThreadGroup threadGroup, int n2) {
        super(threadGroup, "Image Fetcher " + n2);
        this.setDaemon(true);
    }

    private static void createFetchers(FetcherInfo fetcherInfo) {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2;
        AppContext appContext = AppContext.getAppContext();
        ThreadGroup threadGroup3 = appContext.getThreadGroup();
        try {
            if (threadGroup3.getParent() != null) {
                threadGroup2 = threadGroup3;
            } else {
                threadGroup3 = Thread.currentThread().getThreadGroup();
                threadGroup = threadGroup3.getParent();
                while (threadGroup != null && threadGroup.getParent() != null) {
                    threadGroup3 = threadGroup;
                    threadGroup = threadGroup3.getParent();
                }
                threadGroup2 = threadGroup3;
            }
        }
        catch (SecurityException securityException) {
            threadGroup2 = appContext.getThreadGroup();
        }
        threadGroup = threadGroup2;
        AccessController.doPrivileged(new PrivilegedAction(fetcherInfo, threadGroup){
            private final FetcherInfo val$info;
            private final ThreadGroup val$fetcherGroup;

            public Object run() {
                int n2 = 0;
                while (n2 < this.val$info.fetchers.length) {
                    if (this.val$info.fetchers[n2] == null) {
                        this.val$info.fetchers[n2] = new ImageFetcher(this.val$fetcherGroup, n2, null);
                        this.val$info.fetchers[n2].start();
                        ++this.val$info.numFetchers;
                        break;
                    }
                    ++n2;
                }
                return null;
            }
            {
                this.val$info = fetcherInfo;
                this.val$fetcherGroup = threadGroup;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageFetchable nextImage() {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            ImageFetchable imageFetchable = null;
            long l2 = System.currentTimeMillis() + 5000L;
            block6: while (imageFetchable == null) {
                while (true) {
                    Object var10_5;
                    if (fetcherInfo.waitList.size() != 0) {
                        imageFetchable = (ImageFetchable)fetcherInfo.waitList.elementAt(0);
                        fetcherInfo.waitList.removeElement(imageFetchable);
                        continue block6;
                    }
                    long l3 = System.currentTimeMillis();
                    if (l3 >= l2) {
                        return null;
                    }
                    try {
                        try {
                            ++fetcherInfo.numWaiting;
                            fetcherInfo.waitList.wait(l2 - l3);
                        }
                        catch (InterruptedException interruptedException) {
                            ImageFetchable imageFetchable2 = null;
                            var10_5 = null;
                            --fetcherInfo.numWaiting;
                            return imageFetchable2;
                        }
                        var10_5 = null;
                        --fetcherInfo.numWaiting;
                    }
                    catch (Throwable throwable) {
                        var10_5 = null;
                        --fetcherInfo.numWaiting;
                        throw throwable;
                    }
                }
                break;
            }
            return imageFetchable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(ImageFetchable imageFetchable) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            if (!fetcherInfo.waitList.contains(imageFetchable)) {
                fetcherInfo.waitList.addElement(imageFetchable);
                if (fetcherInfo.numWaiting == 0 && fetcherInfo.numFetchers < fetcherInfo.fetchers.length) {
                    ImageFetcher.createFetchers(fetcherInfo);
                }
                fetcherInfo.waitList.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(ImageFetchable imageFetchable) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            if (fetcherInfo.waitList.contains(imageFetchable)) {
                fetcherInfo.waitList.removeElement(imageFetchable);
            }
        }
    }

    ImageFetcher(ThreadGroup threadGroup, int n2, 1 var3_3) {
        this(threadGroup, n2);
    }
}

