/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteComponentRaster;

public class ByteInterleavedRaster
extends ByteComponentRaster {
    boolean inOrder;
    int dbOffset;
    int dbOffsetPacked;
    boolean packed = false;
    int[] bitMasks;
    int[] bitOffsets;
    private int maxX = this.minX + this.width;
    private int maxY = this.minY + this.height;

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n2) {
        return this.dataOffsets[n2];
    }

    public int getSample(int n2, int n3, int n4) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (this.packed) {
            int n5 = n3 * this.scanlineStride + n2 + this.dbOffsetPacked;
            byte by = this.data[n5];
            return (by & this.bitMasks[n4]) >>> this.bitOffsets[n4];
        }
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride + this.dbOffset;
        return this.data[n6 + this.dataOffsets[n4]] & 0xFF;
    }

    public void setSample(int n2, int n3, int n4, int n5) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (this.packed) {
            int n6 = n3 * this.scanlineStride + n2 + this.dbOffsetPacked;
            int n7 = this.bitMasks[n4];
            byte by = this.data[n6];
            by = (byte)(by & ~n7);
            this.data[n6] = by = (byte)(by | n5 << this.bitOffsets[n4] & n7);
        } else {
            int n8 = n3 * this.scanlineStride + n2 * this.pixelStride + this.dbOffset;
            this.data[n8 + this.dataOffsets[n4]] = (byte)n5;
        }
        this.notifyChanged();
    }

    public void putByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride + this.dataOffsets[n6];
        int n8 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n4) {
                System.arraycopy(byArray, 0, this.data, n7, n4 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(byArray, n8, this.data, n7, n4);
                    n8 += n4;
                    ++n9;
                    n7 += this.scanlineStride;
                }
            }
        } else {
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    this.data[n11] = byArray[n8++];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n7 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[n4 * n5];
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride + this.dataOffsets[n6];
        int n8 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n4) {
                System.arraycopy(this.data, n7, byArray, 0, n4 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(this.data, n7, byArray, n8, n4);
                    n8 += n4;
                    ++n9;
                    n7 += this.scanlineStride;
                }
            }
        } else {
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    byArray[n8++] = this.data[n11];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n7 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n8 = 0;
        if (this.packed) {
            n7 += this.dbOffsetPacked;
            int n9 = this.bitMasks[n6];
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    byte by = this.data[n11];
                    by = (byte)(by & ~n9);
                    int n13 = nArray[n8++];
                    by = (byte)(by | n13 << this.bitOffsets[n6] & n9);
                    this.data[n11++] = by;
                    ++n12;
                }
                n7 += this.scanlineStride;
                ++n10;
            }
        } else {
            n7 += this.dbOffset + this.dataOffsets[n6];
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n7;
                int n16 = 0;
                while (n16 < n4) {
                    this.data[n15] = (byte)nArray[n8++];
                    n15 += this.pixelStride;
                    ++n16;
                }
                n7 += this.scanlineStride;
                ++n14;
            }
        }
        this.notifyChanged();
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5];
        int n7 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n8 = 0;
        if (this.packed) {
            n7 += this.dbOffsetPacked;
            int n9 = this.bitMasks[n6];
            int n10 = this.bitOffsets[n6];
            int n11 = 0;
            while (n11 < n5) {
                int n12 = n7;
                int n13 = 0;
                while (n13 < n4) {
                    byte by = this.data[n12++];
                    nArray2[n8++] = (by & n9) >>> n10;
                    ++n13;
                }
                n7 += this.scanlineStride;
                ++n11;
            }
        } else {
            n7 += this.dbOffset + this.dataOffsets[n6];
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n7;
                int n16 = 0;
                while (n16 < n4) {
                    nArray2[n8++] = this.data[n15] & 0xFF;
                    n15 += this.pixelStride;
                    ++n16;
                }
                n7 += this.scanlineStride;
                ++n14;
            }
        }
        return nArray2;
    }

    public void putByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        if (this.inOrder) {
            n6 += this.dataOffsets[0];
            int n8 = n4 * this.pixelStride;
            if (n8 == this.scanlineStride) {
                System.arraycopy(byArray, 0, this.data, n6, n8 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(byArray, n7, this.data, n6, n8);
                    n7 += n8;
                    ++n9;
                    n6 += this.scanlineStride;
                }
            }
        } else if (this.numDataElements == 1) {
            n6 += this.dataOffsets[0];
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n6;
                int n12 = 0;
                while (n12 < n4) {
                    this.data[n11] = byArray[n7++];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n6 += this.scanlineStride;
            }
        } else if (this.numDataElements == 2) {
            n6 += this.dataOffsets[0];
            int n13 = this.dataOffsets[1] - this.dataOffsets[0];
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n6;
                int n16 = 0;
                while (n16 < n4) {
                    this.data[n15] = byArray[n7++];
                    this.data[n15 + n13] = byArray[n7++];
                    ++n16;
                    n15 += this.pixelStride;
                }
                ++n14;
                n6 += this.scanlineStride;
            }
        } else if (this.numDataElements == 3) {
            n6 += this.dataOffsets[0];
            int n17 = this.dataOffsets[1] - this.dataOffsets[0];
            int n18 = this.dataOffsets[2] - this.dataOffsets[0];
            int n19 = 0;
            while (n19 < n5) {
                int n20 = n6;
                int n21 = 0;
                while (n21 < n4) {
                    this.data[n20] = byArray[n7++];
                    this.data[n20 + n17] = byArray[n7++];
                    this.data[n20 + n18] = byArray[n7++];
                    ++n21;
                    n20 += this.pixelStride;
                }
                ++n19;
                n6 += this.scanlineStride;
            }
        } else if (this.numDataElements == 4) {
            n6 += this.dataOffsets[0];
            int n22 = this.dataOffsets[1] - this.dataOffsets[0];
            int n23 = this.dataOffsets[2] - this.dataOffsets[0];
            int n24 = this.dataOffsets[3] - this.dataOffsets[0];
            int n25 = 0;
            while (n25 < n5) {
                int n26 = n6;
                int n27 = 0;
                while (n27 < n4) {
                    this.data[n26] = byArray[n7++];
                    this.data[n26 + n22] = byArray[n7++];
                    this.data[n26 + n23] = byArray[n7++];
                    this.data[n26 + n24] = byArray[n7++];
                    ++n27;
                    n26 += this.pixelStride;
                }
                ++n25;
                n6 += this.scanlineStride;
            }
        } else {
            int n28 = 0;
            while (n28 < n5) {
                int n29 = n6;
                int n30 = 0;
                while (n30 < n4) {
                    int n31 = 0;
                    while (n31 < this.numDataElements) {
                        this.data[this.dataOffsets[n31] + n29] = byArray[n7++];
                        ++n31;
                    }
                    ++n30;
                    n29 += this.pixelStride;
                }
                ++n28;
                n6 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.numDataElements * n4 * n5];
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        if (this.inOrder) {
            n6 += this.dataOffsets[0];
            int n8 = n4 * this.pixelStride;
            if (this.scanlineStride == n8) {
                System.arraycopy(this.data, n6, byArray, n7, n8 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(this.data, n6, byArray, n7, n8);
                    n7 += n8;
                    ++n9;
                    n6 += this.scanlineStride;
                }
            }
        } else if (this.numDataElements == 1) {
            n6 += this.dataOffsets[0];
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n6;
                int n12 = 0;
                while (n12 < n4) {
                    byArray[n7++] = this.data[n11];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n6 += this.scanlineStride;
            }
        } else if (this.numDataElements == 2) {
            n6 += this.dataOffsets[0];
            int n13 = this.dataOffsets[1] - this.dataOffsets[0];
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n6;
                int n16 = 0;
                while (n16 < n4) {
                    byArray[n7++] = this.data[n15];
                    byArray[n7++] = this.data[n15 + n13];
                    ++n16;
                    n15 += this.pixelStride;
                }
                ++n14;
                n6 += this.scanlineStride;
            }
        } else if (this.numDataElements == 3) {
            n6 += this.dataOffsets[0];
            int n17 = this.dataOffsets[1] - this.dataOffsets[0];
            int n18 = this.dataOffsets[2] - this.dataOffsets[0];
            int n19 = 0;
            while (n19 < n5) {
                int n20 = n6;
                int n21 = 0;
                while (n21 < n4) {
                    byArray[n7++] = this.data[n20];
                    byArray[n7++] = this.data[n20 + n17];
                    byArray[n7++] = this.data[n20 + n18];
                    ++n21;
                    n20 += this.pixelStride;
                }
                ++n19;
                n6 += this.scanlineStride;
            }
        } else if (this.numDataElements == 4) {
            n6 += this.dataOffsets[0];
            int n22 = this.dataOffsets[1] - this.dataOffsets[0];
            int n23 = this.dataOffsets[2] - this.dataOffsets[0];
            int n24 = this.dataOffsets[3] - this.dataOffsets[0];
            int n25 = 0;
            while (n25 < n5) {
                int n26 = n6;
                int n27 = 0;
                while (n27 < n4) {
                    byArray[n7++] = this.data[n26];
                    byArray[n7++] = this.data[n26 + n22];
                    byArray[n7++] = this.data[n26 + n23];
                    byArray[n7++] = this.data[n26 + n24];
                    ++n27;
                    n26 += this.pixelStride;
                }
                ++n25;
                n6 += this.scanlineStride;
            }
        } else {
            int n28 = 0;
            while (n28 < n5) {
                int n29 = n6;
                int n30 = 0;
                while (n30 < n4) {
                    int n31 = 0;
                    while (n31 < this.numDataElements) {
                        byArray[n7++] = this.data[this.dataOffsets[n31] + n29];
                        ++n31;
                    }
                    ++n30;
                    n29 += this.pixelStride;
                }
                ++n28;
                n6 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n7 = 0;
        if (this.packed) {
            n6 += this.dbOffsetPacked;
            int n8 = 0;
            while (n8 < n5) {
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = 0;
                    int n11 = 0;
                    while (n11 < this.numBands) {
                        int n12 = nArray[n7++];
                        n10 |= n12 << this.bitOffsets[n11] & this.bitMasks[n11];
                        ++n11;
                    }
                    this.data[n6 + n9] = (byte)n10;
                    ++n9;
                }
                n6 += this.scanlineStride;
                ++n8;
            }
        } else {
            n6 += this.dbOffset;
            int n13 = this.dataOffsets[0];
            if (this.numBands == 1) {
                int n14 = 0;
                while (n14 < n5) {
                    int n15 = n6 + n13;
                    int n16 = 0;
                    while (n16 < n4) {
                        this.data[n15] = (byte)nArray[n7++];
                        n15 += this.pixelStride;
                        ++n16;
                    }
                    n6 += this.scanlineStride;
                    ++n14;
                }
            } else if (this.numBands == 2) {
                int n17 = this.dataOffsets[1] - n13;
                int n18 = 0;
                while (n18 < n5) {
                    int n19 = n6 + n13;
                    int n20 = 0;
                    while (n20 < n4) {
                        this.data[n19] = (byte)nArray[n7++];
                        this.data[n19 + n17] = (byte)nArray[n7++];
                        n19 += this.pixelStride;
                        ++n20;
                    }
                    n6 += this.scanlineStride;
                    ++n18;
                }
            } else if (this.numBands == 3) {
                int n21 = this.dataOffsets[1] - n13;
                int n22 = this.dataOffsets[2] - n13;
                int n23 = 0;
                while (n23 < n5) {
                    int n24 = n6 + n13;
                    int n25 = 0;
                    while (n25 < n4) {
                        this.data[n24] = (byte)nArray[n7++];
                        this.data[n24 + n21] = (byte)nArray[n7++];
                        this.data[n24 + n22] = (byte)nArray[n7++];
                        n24 += this.pixelStride;
                        ++n25;
                    }
                    n6 += this.scanlineStride;
                    ++n23;
                }
            } else if (this.numBands == 4) {
                int n26 = this.dataOffsets[1] - n13;
                int n27 = this.dataOffsets[2] - n13;
                int n28 = this.dataOffsets[3] - n13;
                int n29 = 0;
                while (n29 < n5) {
                    int n30 = n6 + n13;
                    int n31 = 0;
                    while (n31 < n4) {
                        this.data[n30] = (byte)nArray[n7++];
                        this.data[n30 + n26] = (byte)nArray[n7++];
                        this.data[n30 + n27] = (byte)nArray[n7++];
                        this.data[n30 + n28] = (byte)nArray[n7++];
                        n30 += this.pixelStride;
                        ++n31;
                    }
                    n6 += this.scanlineStride;
                    ++n29;
                }
            } else {
                int n32 = 0;
                while (n32 < n5) {
                    int n33 = n6;
                    int n34 = 0;
                    while (n34 < n4) {
                        int n35 = 0;
                        while (n35 < this.numBands) {
                            this.data[n33 + this.dataOffsets[n35]] = (byte)nArray[n7++];
                            ++n35;
                        }
                        n33 += this.pixelStride;
                        ++n34;
                    }
                    n6 += this.scanlineStride;
                    ++n32;
                }
            }
        }
        this.notifyChanged();
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5 * this.numBands];
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n7 = 0;
        if (this.packed) {
            n6 += this.dbOffsetPacked;
            int n8 = 0;
            while (n8 < n5) {
                int n9 = 0;
                while (n9 < n4) {
                    byte by = this.data[n6 + n9];
                    int n10 = 0;
                    while (n10 < this.numBands) {
                        nArray2[n7++] = (by & this.bitMasks[n10]) >>> this.bitOffsets[n10];
                        ++n10;
                    }
                    ++n9;
                }
                n6 += this.scanlineStride;
                ++n8;
            }
        } else {
            n6 += this.dbOffset;
            int n11 = this.dataOffsets[0];
            if (this.numBands == 1) {
                int n12 = 0;
                while (n12 < n5) {
                    int n13 = n6 + n11;
                    int n14 = 0;
                    while (n14 < n4) {
                        nArray2[n7++] = this.data[n13] & 0xFF;
                        n13 += this.pixelStride;
                        ++n14;
                    }
                    n6 += this.scanlineStride;
                    ++n12;
                }
            } else if (this.numBands == 2) {
                int n15 = this.dataOffsets[1] - n11;
                int n16 = 0;
                while (n16 < n5) {
                    int n17 = n6 + n11;
                    int n18 = 0;
                    while (n18 < n4) {
                        nArray2[n7++] = this.data[n17] & 0xFF;
                        nArray2[n7++] = this.data[n17 + n15] & 0xFF;
                        n17 += this.pixelStride;
                        ++n18;
                    }
                    n6 += this.scanlineStride;
                    ++n16;
                }
            } else if (this.numBands == 3) {
                int n19 = this.dataOffsets[1] - n11;
                int n20 = this.dataOffsets[2] - n11;
                int n21 = 0;
                while (n21 < n5) {
                    int n22 = n6 + n11;
                    int n23 = 0;
                    while (n23 < n4) {
                        nArray2[n7++] = this.data[n22] & 0xFF;
                        nArray2[n7++] = this.data[n22 + n19] & 0xFF;
                        nArray2[n7++] = this.data[n22 + n20] & 0xFF;
                        n22 += this.pixelStride;
                        ++n23;
                    }
                    n6 += this.scanlineStride;
                    ++n21;
                }
            } else if (this.numBands == 4) {
                int n24 = this.dataOffsets[1] - n11;
                int n25 = this.dataOffsets[2] - n11;
                int n26 = this.dataOffsets[3] - n11;
                int n27 = 0;
                while (n27 < n5) {
                    int n28 = n6 + n11;
                    int n29 = 0;
                    while (n29 < n4) {
                        nArray2[n7++] = this.data[n28] & 0xFF;
                        nArray2[n7++] = this.data[n28 + n24] & 0xFF;
                        nArray2[n7++] = this.data[n28 + n25] & 0xFF;
                        nArray2[n7++] = this.data[n28 + n26] & 0xFF;
                        n28 += this.pixelStride;
                        ++n29;
                    }
                    n6 += this.scanlineStride;
                    ++n27;
                }
            } else {
                int n30 = 0;
                while (n30 < n5) {
                    int n31 = n6;
                    int n32 = 0;
                    while (n32 < n4) {
                        int n33 = 0;
                        while (n33 < this.numBands) {
                            nArray2[n7++] = this.data[n31 + this.dataOffsets[n33]] & 0xFF;
                            ++n33;
                        }
                        n31 += this.pixelStride;
                        ++n32;
                    }
                    n6 += this.scanlineStride;
                    ++n30;
                }
            }
        }
        return nArray2;
    }

    private void verify(boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numDataElements) {
            int n4 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[n3];
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        if (this.data.length < n2) {
            throw new RasterFormatException("Data array too small (should be " + n2 + " )");
        }
    }

    private boolean isInterleaved(ComponentSampleModel componentSampleModel) {
        int n2;
        int n3 = this.sampleModel.getNumBands();
        if (n3 == 1) {
            return true;
        }
        int[] nArray = componentSampleModel.getBankIndices();
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n4] != 0) {
                return false;
            }
            ++n4;
        }
        int[] nArray2 = componentSampleModel.getBandOffsets();
        int n5 = n2 = nArray2[0];
        int n6 = 1;
        while (n6 < n3) {
            int n7 = nArray2[n6];
            if (n7 < n2) {
                n2 = n7;
            }
            if (n7 > n5) {
                n5 = n7;
            }
            ++n6;
        }
        return n5 - n2 < componentSampleModel.getPixelStride();
    }

    private void setDataElements(int n2, int n3, int n4, int n5, int n6, int n7, Raster raster) {
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        int n8 = raster.getMinX();
        int n9 = raster.getMinY();
        Object object = null;
        if (raster instanceof ByteInterleavedRaster) {
            ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)raster;
            byte[] byArray = byteInterleavedRaster.getDataStorage();
            if (this.inOrder && byteInterleavedRaster.inOrder && this.pixelStride == byteInterleavedRaster.pixelStride) {
                int n10 = byteInterleavedRaster.getDataOffset(0);
                int n11 = byteInterleavedRaster.getScanlineStride();
                int n12 = byteInterleavedRaster.getPixelStride();
                int n13 = n10 + (n5 - n9) * n11 + (n4 - n8) * n12;
                int n14 = this.dataOffsets[0] + (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
                int n15 = n6 * this.pixelStride;
                int n16 = 0;
                while (n16 < n7) {
                    System.arraycopy(byArray, n13, this.data, n14, n15);
                    n13 += n11;
                    n14 += this.scanlineStride;
                    ++n16;
                }
                this.notifyChanged();
                return;
            }
        }
        int n17 = 0;
        while (n17 < n7) {
            object = raster.getDataElements(n8, n9 + n17, n6, 1, object);
            this.setDataElements(n2, n3 + n17, n6, 1, object);
            ++n17;
        }
        this.notifyChanged();
    }

    public Raster createChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n2, n3, n4, n5, n6, n7, nArray);
        return writableRaster;
    }

    public void setDataElements(int n2, int n3, Raster raster) {
        int n4 = raster.getMinX();
        int n5 = raster.getMinY();
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        int n8 = raster.getWidth();
        int n9 = raster.getHeight();
        if (n6 < this.minX || n7 < this.minY || n6 + n8 > this.maxX || n7 + n9 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n6, n7, n4, n5, n8, n9, raster);
    }

    public void setRect(int n2, int n3, Raster raster) {
        int n4;
        if (!(raster instanceof ByteInterleavedRaster)) {
            super.setRect(n2, n3, raster);
            return;
        }
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        int n9 = n2 + n7;
        int n10 = n3 + n8;
        if (n9 < this.minX) {
            n4 = this.minX - n9;
            n5 -= n4;
            n7 += n4;
            n9 = this.minX;
        }
        if (n10 < this.minY) {
            n4 = this.minY - n10;
            n6 -= n4;
            n8 += n4;
            n10 = this.minY;
        }
        if (n9 + n5 > this.maxX) {
            n5 = this.maxX - n9;
        }
        if (n10 + n6 > this.maxY) {
            n6 = this.maxY - n10;
        }
        this.setDataElements(n9, n10, n7, n8, n5, n6, raster);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new RasterFormatException("negative " + (n2 <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n2, n3);
        return new ByteInterleavedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        this.notifyStolen();
        return new ByteInterleavedRaster(sampleModel, this.dataBuffer, new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object) {
        this.putByteData(n2, n3, n4, n5, (byte[])object);
    }

    public void setDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n5 = 0;
        while (n5 < this.numDataElements) {
            this.data[this.dataOffsets[n5] + n4] = byArray[n5];
            ++n5;
        }
        this.notifyChanged();
    }

    public String toString() {
        return new String("ByteInterleavedRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements + " dataOff[0] = " + this.dataOffsets[0]);
    }

    public ByteInterleavedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object) {
        return this.getByteData(n2, n3, n4, n5, (byte[])object);
    }

    public Object getDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n5 = 0;
        while (n5 < this.numDataElements) {
            byArray[n5] = this.data[this.dataOffsets[n5] + n4];
            ++n5;
        }
        return byArray;
    }

    public ByteInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteInterleavedRaster byteInterleavedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteInterleavedRaster);
        SampleModel sampleModel2;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteInterleavedRasters must have byte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        int n2 = rectangle.x - point.x;
        int n3 = rectangle.y - point.y;
        if (sampleModel instanceof PixelInterleavedSampleModel || sampleModel instanceof ComponentSampleModel && this.isInterleaved((ComponentSampleModel)sampleModel)) {
            sampleModel2 = (ComponentSampleModel)sampleModel;
            this.scanlineStride = ((ComponentSampleModel)sampleModel2).getScanlineStride();
            this.pixelStride = ((ComponentSampleModel)sampleModel2).getPixelStride();
            this.dataOffsets = ((ComponentSampleModel)sampleModel2).getBandOffsets();
            int n4 = 0;
            while (n4 < this.getNumDataElements()) {
                int n5 = n4++;
                this.dataOffsets[n5] = this.dataOffsets[n5] + (n2 * this.pixelStride + n3 * this.scanlineStride);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            sampleModel2 = (SinglePixelPackedSampleModel)sampleModel;
            this.packed = true;
            this.bitMasks = ((SinglePixelPackedSampleModel)sampleModel2).getBitMasks();
            this.bitOffsets = ((SinglePixelPackedSampleModel)sampleModel2).getBitOffsets();
            this.scanlineStride = ((SinglePixelPackedSampleModel)sampleModel2).getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = dataBufferByte.getOffset();
            this.dataOffsets[0] = this.dataOffsets[0] + (n2 * this.pixelStride + n3 * this.scanlineStride);
        } else {
            throw new RasterFormatException("ByteInterleavedRasters must have PixelInterleavedSampleModel, SinglePixelPackedSampleModel or interleaved ComponentSampleModel.  Sample model is " + sampleModel);
        }
        this.bandOffset = this.dataOffsets[0];
        this.dbOffsetPacked = dataBuffer.getOffset() - this.sampleModelTranslateY * this.scanlineStride - this.sampleModelTranslateX * this.pixelStride;
        this.dbOffset = this.dbOffsetPacked - (n2 * this.pixelStride + n3 * this.scanlineStride);
        this.inOrder = false;
        if (this.numDataElements == this.pixelStride) {
            this.inOrder = true;
            int n6 = 1;
            while (n6 < this.numDataElements) {
                if (this.dataOffsets[n6] - this.dataOffsets[0] != n6) {
                    this.inOrder = false;
                    break;
                }
                ++n6;
            }
        }
        this.verify(false);
    }
}

