/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.text.CharacterIterator;
import sun.awt.font.NativeFontWrapper;

public class StandardGlyphVector
extends GlyphVector {
    private Font font;
    public int[] glyphs;
    public int[] charIndices;
    public float[] positions;
    public double[] transforms;
    public int[] txIndices;
    private int flags = -1;
    private FontRenderContext frc;
    private static final int UNINITIALIZED_FLAGS = -1;
    public double[] fontTX;
    public double[] devTX;
    private boolean haveLM;
    private int baseline;
    private float ascent;
    private float descent;
    private float leading;
    private boolean horizontal = true;
    private SoftReference lbcacheRef;
    private SoftReference vbcacheRef;
    public static final int FLAG_USES_VERTICAL_BASELINE = 128;
    public static final int FLAG_USES_VERTICAL_METRICS = 256;
    public static final int FLAG_USES_ALTERNATE_ORIENTATION = 512;

    public int getLayoutFlags() {
        if (this.flags == -1) {
            this.flags = 0;
            if (this.charIndices != null) {
                boolean bl2 = true;
                boolean bl3 = true;
                int n2 = this.charIndices.length;
                int n3 = 0;
                while (n3 < this.charIndices.length && (bl2 || bl3)) {
                    int n4 = this.charIndices[n3];
                    bl2 = bl2 && n4 == n3;
                    bl3 = bl3 && n4 == --n2;
                    ++n3;
                }
                if (bl3) {
                    this.flags |= 4;
                }
                if (!bl3 && !bl2) {
                    this.flags |= 8;
                }
            }
        }
        return this.flags;
    }

    public int getNumGlyphs() {
        return this.glyphs.length;
    }

    public int hashCode() {
        return this.font.hashCode() ^ this.glyphs.length;
    }

    private void clearCaches() {
        this.lbcacheRef = null;
        this.vbcacheRef = null;
    }

    private void initLM() {
        if (!this.haveLM) {
            float[] fArray = new float[4];
            NativeFontWrapper.getFontMetrics(this.font, this.fontTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), fArray);
            this.haveLM = true;
            this.ascent = fArray[0];
            this.descent = fArray[1];
            this.leading = fArray[2];
        }
    }

    private void initPositions() {
        if (this.positions == null) {
            this.performDefaultLayout();
        }
    }

    private void initTX() {
        float f2 = this.font.getSize2D();
        AffineTransform affineTransform = this.font.getTransform();
        affineTransform.scale(f2, f2);
        this.fontTX = new double[6];
        affineTransform.getMatrix(this.fontTX);
        AffineTransform affineTransform2 = this.frc.getTransform();
        if (!affineTransform2.isIdentity()) {
            this.devTX = new double[6];
            affineTransform2.getMatrix(this.devTX);
            this.devTX[5] = 0.0;
            this.devTX[4] = 0.0;
        }
    }

    public void performDefaultLayout() {
        this.clearCaches();
        NativeFontWrapper.layoutGlyphVector(this.font, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), this);
    }

    public float[] getGlyphInfo() {
        return NativeFontWrapper.getGlyphInfo(this.font, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
    }

    public int getGlyphCharIndex(int n2) {
        return this.charIndices == null ? n2 : this.charIndices[n2];
    }

    public int getGlyphCode(int n2) {
        return this.glyphs[n2];
    }

    private void addFlags(int n2) {
        this.flags = this.getLayoutFlags() | n2;
    }

    private void clearCaches(int n2) {
        Shape[] shapeArray;
        if (this.lbcacheRef != null && (shapeArray = (Shape[])this.lbcacheRef.get()) != null) {
            shapeArray[n2] = null;
        }
        if (this.vbcacheRef != null && (shapeArray = (Shape[])this.vbcacheRef.get()) != null) {
            shapeArray[n2] = null;
        }
    }

    private void clearFlags(int n2) {
        this.flags = this.getLayoutFlags() & ~n2;
    }

    public float[] getGlyphPositions(int n2, int n3, float[] fArray) {
        if (n3 < 0) {
            throw new IllegalArgumentException("numEntries = " + n3);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex = " + n2);
        }
        if (n2 > this.glyphs.length + 1 - n3) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries = " + (n2 + n3));
        }
        return this.internalGetGlyphPositions(n2, n3, fArray);
    }

    float[] internalGetGlyphPositions(int n2, int n3, float[] fArray) {
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            fArray2 = new float[n3 * 2];
        }
        this.initPositions();
        int n4 = 0;
        while (n4 < n3) {
            fArray2[n4 * 2] = this.positions[(n4 + n2) * 2];
            fArray2[n4 * 2 + 1] = this.positions[(n4 + n2) * 2 + 1];
            ++n4;
        }
        return fArray2;
    }

    public int[] getGlyphCharIndices(int n2, int n3, int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4 + n2;
            nArray2[n4] = this.charIndices == null ? n5 : this.charIndices[n5];
            ++n4;
        }
        return nArray2;
    }

    public int[] getGlyphCodes(int n2, int n3, int[] nArray) {
        if (n3 < 0) {
            throw new IllegalArgumentException("numEntries = " + n3);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex = " + n2);
        }
        if (n2 > this.glyphs.length - n3) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries = " + (n2 + n3));
        }
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            nArray2[n4] = this.glyphs[n4 + n2];
            ++n4;
        }
        return nArray2;
    }

    public void setGlyphPositions(float[] fArray) {
        int n2 = this.glyphs.length * 2 + 2;
        if (fArray.length != n2) {
            throw new IllegalArgumentException("srcPositions.length != " + n2);
        }
        this.clearCaches();
        if (this.positions == null) {
            this.positions = (float[])fArray.clone();
        } else {
            System.arraycopy(fArray, 0, this.positions, 0, n2);
        }
    }

    public float[] getGlyphPositions(float[] fArray) {
        return this.internalGetGlyphPositions(0, this.glyphs.length + 1, fArray);
    }

    public void setGlyphPositions(float[] fArray, int n2, int n3, int n4) {
        if (n4 < 0) {
            throw new IllegalArgumentException("numEntries = " + n4);
        }
        this.clearCaches();
        this.initPositions();
        System.arraycopy(fArray, n2, this.positions, n3 * 2, n4 * 2);
    }

    public Font getFont() {
        return this.font;
    }

    public Shape getOutline() {
        return this.getOutline(0.0f, 0.0f);
    }

    public Shape getOutline(float f2, float f3) {
        this.initPositions();
        return NativeFontWrapper.getGlyphVectorOutline(this, this.font, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), f2, f3);
    }

    public Shape getGlyphLogicalBounds(int n2) {
        Shape shape;
        Shape[] shapeArray;
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n2);
        }
        if (this.lbcacheRef == null || (shapeArray = (Shape[])this.lbcacheRef.get()) == null) {
            shapeArray = new Shape[this.glyphs.length];
            this.lbcacheRef = new SoftReference(shapeArray);
        }
        if ((shape = shapeArray[n2]) == null) {
            this.initPositions();
            shapeArray[n2] = shape = NativeFontWrapper.getGlyphLogicalBounds(this.font, n2, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
        }
        return shape;
    }

    public Shape getGlyphOutline(int n2) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n2);
        }
        this.initPositions();
        return NativeFontWrapper.getGlyphOutline(this, n2, this.font, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), 0.0f, 0.0f);
    }

    public Shape getGlyphVisualBounds(int n2) {
        Shape shape;
        Shape[] shapeArray;
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n2);
        }
        if (this.vbcacheRef == null || (shapeArray = (Shape[])this.vbcacheRef.get()) == null) {
            shapeArray = new Shape[this.glyphs.length];
            this.vbcacheRef = new SoftReference(shapeArray);
        }
        if ((shape = shapeArray[n2]) == null) {
            this.initPositions();
            shapeArray[n2] = shape = NativeFontWrapper.getGlyphVisualBounds(this.font, n2, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
        }
        return shape;
    }

    public Shape getGlyphOutline(int n2, float f2, float f3) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n2);
        }
        this.initPositions();
        return NativeFontWrapper.getGlyphOutline(this, n2, this.font, this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), f2, f3);
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n2) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n2);
        }
        return null;
    }

    public GlyphMetrics getGlyphMetrics(int n2) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n2);
        }
        float[] fArray = new float[6];
        NativeFontWrapper.getGlyphMetrics(this.font, this.glyphs[n2], this.fontTX, this.devTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), fArray);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[3];
        float f6 = fArray[4];
        float f7 = fArray[5];
        GlyphMetrics glyphMetrics = new GlyphMetrics(this.horizontal, f2, f3, new Rectangle2D.Float(f4, f5, f6, f7), 0);
        return glyphMetrics;
    }

    public StandardGlyphVector(GlyphVector glyphVector) {
        if (glyphVector instanceof StandardGlyphVector) {
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)glyphVector;
            this.font = standardGlyphVector.font;
            this.frc = standardGlyphVector.frc;
            this.glyphs = standardGlyphVector.glyphs;
            this.charIndices = standardGlyphVector.charIndices;
            if (standardGlyphVector.positions != null) {
                this.positions = (float[])standardGlyphVector.positions.clone();
            }
            if (standardGlyphVector.txIndices != null) {
                this.txIndices = (int[])standardGlyphVector.txIndices.clone();
                this.transforms = (double[])standardGlyphVector.transforms.clone();
            }
            this.initTX();
        } else {
            this.font = glyphVector.getFont();
            this.frc = glyphVector.getFontRenderContext();
            int n2 = glyphVector.getNumGlyphs();
            this.glyphs = glyphVector.getGlyphCodes(0, n2, null);
            this.flags = glyphVector.getLayoutFlags() & 0xF;
            this.positions = glyphVector.getGlyphPositions(0, n2 + 1, null);
            if ((this.flags & 8) != 0) {
                this.charIndices = glyphVector.getGlyphCharIndices(0, n2, null);
            }
            if ((this.flags & 1) != 0) {
                AffineTransform[] affineTransformArray = new AffineTransform[n2];
                int n3 = 0;
                while (n3 < n2) {
                    affineTransformArray[n3] = glyphVector.getGlyphTransform(n3);
                    ++n3;
                }
                this.setGlyphTransforms(affineTransformArray);
            }
            this.initTX();
        }
    }

    public boolean equals(GlyphVector glyphVector) {
        if (this == glyphVector) {
            return true;
        }
        if (glyphVector == null) {
            return false;
        }
        try {
            int n2;
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)glyphVector;
            if (this.glyphs.length != standardGlyphVector.glyphs.length) {
                return false;
            }
            int n3 = 0;
            while (n3 < this.glyphs.length) {
                if (this.glyphs[n3] != standardGlyphVector.glyphs[n3]) {
                    return false;
                }
                ++n3;
            }
            if (!this.font.equals(standardGlyphVector.font)) {
                return false;
            }
            if (!this.frc.equals(standardGlyphVector.frc)) {
                return false;
            }
            if (standardGlyphVector.positions == null != (this.positions == null)) {
                if (this.positions == null) {
                    this.performDefaultLayout();
                } else {
                    standardGlyphVector.performDefaultLayout();
                }
            }
            if (this.positions != null) {
                n2 = 0;
                while (n2 < this.positions.length) {
                    if (this.positions[n2] != standardGlyphVector.positions[n2]) {
                        return false;
                    }
                    ++n2;
                }
            }
            if (this.txIndices == null != (standardGlyphVector.txIndices == null)) {
                return false;
            }
            if (this.txIndices != null) {
                if (this.transforms.length != standardGlyphVector.transforms.length) {
                    return false;
                }
                n2 = 0;
                while (n2 < this.glyphs.length) {
                    int n4;
                    int n5 = this.txIndices[n2];
                    if (n5 == 0 != ((n4 = standardGlyphVector.txIndices[n2]) == 0)) {
                        return false;
                    }
                    if (n5 != 0) {
                        n5 = (n5 - 1) * 6;
                        n4 = (n4 - 1) * 6;
                        int n6 = 0;
                        while (n6 < 6) {
                            if (this.transforms[n5++] != standardGlyphVector.transforms[n4++]) {
                                return false;
                            }
                            ++n6;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    public AffineTransform[] getGlyphTransforms() {
        return this.getGlyphTransforms(0, this.glyphs.length, null);
    }

    public AffineTransform getGlyphTransform(int n2) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n2);
        }
        if (this.txIndices == null || this.txIndices[n2] == 0) {
            return new AffineTransform();
        }
        int n3 = (this.txIndices[n2] - 1) * 6;
        return new AffineTransform(this.transforms[n3 + 0], this.transforms[n3 + 1], this.transforms[n3 + 2], this.transforms[n3 + 3], this.transforms[n3 + 4], this.transforms[n3 + 5]);
    }

    public void setGlyphTransform(int n2, AffineTransform affineTransform) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("glyphIndex = " + n2);
        }
        this.clearCaches(n2);
        double[] dArray = new double[6];
        boolean bl2 = true;
        if (affineTransform == null) {
            dArray[3] = 1.0;
            dArray[0] = 1.0;
        } else {
            bl2 = affineTransform.isIdentity();
            affineTransform.getMatrix(dArray);
        }
        if (this.txIndices == null) {
            if (bl2) {
                return;
            }
            this.txIndices = new int[this.glyphs.length];
            this.txIndices[n2] = 1;
            this.transforms = dArray;
        } else {
            int n3;
            int n4;
            boolean bl3 = false;
            int n5 = -1;
            if (bl2) {
                n5 = 0;
            } else {
                bl3 = true;
                n4 = 0;
                while (n4 < this.transforms.length) {
                    block23: {
                        n3 = 0;
                        while (n3 < 6) {
                            if (this.transforms[n4 + n3] == dArray[n3]) {
                                ++n3;
                                continue;
                            }
                            break block23;
                        }
                        bl3 = false;
                        break;
                    }
                    n4 += 6;
                }
                n5 = n4 / 6 + 1;
            }
            n4 = this.txIndices[n2];
            if (n5 != n4) {
                int n6;
                n3 = 0;
                if (n4 != 0) {
                    n3 = 1;
                    int n7 = this.txIndices[n2];
                    n6 = 0;
                    while (n6 < this.txIndices.length) {
                        if (n6 != n2 && this.txIndices[n6] == n7) {
                            n3 = 0;
                            break;
                        }
                        ++n6;
                    }
                }
                if (n3 != 0 && bl3) {
                    System.arraycopy(dArray, 0, this.transforms, (n5 - 1) * 6, 6);
                } else if (n3 != 0) {
                    if (this.transforms.length == 6) {
                        this.transforms = null;
                        this.txIndices = null;
                        this.clearFlags(1);
                        return;
                    }
                    double[] dArray2 = new double[this.transforms.length - 6];
                    System.arraycopy(this.transforms, 0, dArray2, 0, (n4 - 1) * 6);
                    System.arraycopy(this.transforms, n4 * 6, dArray2, (n4 - 1) * 6, this.transforms.length - n4 * 6);
                    this.transforms = dArray2;
                    n6 = 0;
                    while (n6 < this.txIndices.length) {
                        if (this.txIndices[n6] > n4) {
                            int n8 = n6;
                            this.txIndices[n8] = this.txIndices[n8] - 1;
                        }
                        ++n6;
                    }
                } else if (bl3) {
                    double[] dArray3 = new double[this.transforms.length + 6];
                    System.arraycopy(this.transforms, 0, dArray3, 0, this.transforms.length);
                    System.arraycopy(dArray, 0, dArray3, this.transforms.length, 6);
                    this.transforms = dArray3;
                }
                this.txIndices[n2] = n5;
            }
        }
        this.addFlags(1);
    }

    public void setGlyphTransforms(AffineTransform[] affineTransformArray) {
        this.setGlyphTransforms(affineTransformArray, 0, 0, this.glyphs.length);
    }

    public void setGlyphTransforms(AffineTransform[] affineTransformArray, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n3 + n4;
        while (n5 < n6) {
            this.setGlyphTransform(n5, affineTransformArray[n2 + n5]);
            ++n5;
        }
    }

    public Point2D getGlyphPosition(int n2) {
        this.initPositions();
        return new Point2D.Float(this.positions[n2 * 2], this.positions[n2 * 2 + 1]);
    }

    public void setGlyphPosition(int n2, Point2D point2D) {
        this.initPositions();
        this.positions[n2 * 2] = (float)point2D.getX();
        this.positions[n2 * 2 + 1] = (float)point2D.getY();
        this.clearCaches(n2);
        this.addFlags(2);
    }

    public Rectangle2D getLogicalBounds() {
        float f2;
        float f3;
        float f4;
        float f5;
        this.initLM();
        if (this.horizontal) {
            f5 = 0.0f;
            f4 = -this.ascent;
            f3 = 0.0f;
            f2 = this.descent + this.leading;
            if (this.glyphs.length > 0) {
                this.initPositions();
                f3 = this.positions[this.positions.length - 2];
            }
        } else {
            f4 = 0.0f;
            f3 = this.ascent;
            f2 = 0.0f;
            f5 = -this.descent - this.leading;
            if (this.glyphs.length > 0) {
                this.initPositions();
                f2 = this.positions[this.positions.length - 1];
            }
        }
        return new Rectangle2D.Float(f5, f4, f3 - f5, f2 - f4);
    }

    public Rectangle2D getVisualBounds() {
        this.initPositions();
        return NativeFontWrapper.getVisualBounds(this.font, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
    }

    public Object clone() {
        try {
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)super.clone();
            standardGlyphVector.clearCaches();
            if (this.positions != null) {
                standardGlyphVector.positions = (float[])this.positions.clone();
            }
            if (this.txIndices != null) {
                standardGlyphVector.txIndices = (int[])this.txIndices.clone();
                standardGlyphVector.transforms = (double[])this.transforms.clone();
            }
            return standardGlyphVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public Rectangle getGlyphPixelBounds(int n2, FontRenderContext fontRenderContext, float f2, float f3) {
        double[] dArray;
        if (fontRenderContext == null) {
            fontRenderContext = this.frc;
            dArray = this.devTX;
        } else {
            dArray = new double[6];
            AffineTransform affineTransform = fontRenderContext.getTransform();
            affineTransform.getMatrix(dArray);
        }
        this.initPositions();
        return NativeFontWrapper.getGlyphPixelBounds(this.font, n2, f2, f3, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, dArray, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
    }

    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f2, float f3) {
        double[] dArray;
        if (fontRenderContext == null) {
            fontRenderContext = this.frc;
            dArray = this.devTX;
        } else {
            dArray = new double[6];
            AffineTransform affineTransform = fontRenderContext.getTransform();
            affineTransform.getMatrix(dArray);
        }
        this.initPositions();
        return NativeFontWrapper.getPixelBounds(this.font, f2, f3, this.glyphs, this.positions, this.transforms, this.txIndices, this.fontTX, dArray, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics());
    }

    public StandardGlyphVector(Font font, char[] cArray, int n2, int n3, int n4, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateAndLayoutGlyphVector(this.font, cArray, n2, n3, n4, this.fontTX, this.devTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, char[] cArray, int n2, int n3, FontRenderContext fontRenderContext) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException("start or count out of bounds");
        }
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, n2, n3, this.fontTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, char[] cArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, 0, cArray.length, this.fontTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, int[] nArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = nArray;
        this.frc = fontRenderContext;
        this.initTX();
    }

    public AffineTransform[] getGlyphTransforms(int n2, int n3, AffineTransform[] affineTransformArray) {
        if (this.txIndices != null) {
            int n4;
            int n5;
            boolean bl2 = true;
            if (n2 != 0 || n3 != this.glyphs.length) {
                bl2 = false;
                n5 = n2;
                n4 = n2 + n3;
                while (n5 < n4) {
                    if (this.txIndices[n5] != 0) {
                        bl2 = true;
                        break;
                    }
                    ++n5;
                }
            }
            if (bl2) {
                if (affineTransformArray == null) {
                    affineTransformArray = new AffineTransform[n3];
                }
                n5 = n2;
                n4 = n2 + n3;
                while (n5 < n4) {
                    int n6;
                    if (affineTransformArray[n5] == null && (n6 = this.txIndices[n5]) != 0) {
                        n6 = n6 * 6 - 6;
                        AffineTransform affineTransform = new AffineTransform(this.transforms[n6], this.transforms[n6 + 1], this.transforms[n6 + 2], this.transforms[n6 + 3], this.transforms[n6 + 4], this.transforms[n6 + 5]);
                        int n7 = n5;
                        while (n7 < n4) {
                            if (this.txIndices[n7] == n6) {
                                affineTransformArray[n7] = affineTransform;
                            }
                            ++n7;
                        }
                    }
                    ++n5;
                }
                return affineTransformArray;
            }
        }
        return null;
    }

    public static StandardGlyphVector getStandardGV(GlyphVector glyphVector) {
        if (glyphVector instanceof StandardGlyphVector) {
            return (StandardGlyphVector)glyphVector;
        }
        return new StandardGlyphVector(glyphVector);
    }

    public void pixellate(FontRenderContext fontRenderContext, Point2D point2D, Point point) {
        if (fontRenderContext == null) {
            fontRenderContext = this.frc;
        }
        AffineTransform affineTransform = fontRenderContext.getTransform();
        affineTransform.transform(point2D, point2D);
        point.x = (int)point2D.getX();
        point.y = (int)point2D.getY();
        point2D.setLocation(point.x, point.y);
        try {
            affineTransform.inverseTransform(point2D, point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException("must be able to invert frc transform");
        }
    }

    public StandardGlyphVector(Font font, String string, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateGlyphVector(this.font, string.toCharArray(), 0, string.length(), this.fontTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, CharacterIterator characterIterator, FontRenderContext fontRenderContext) {
        char[] cArray = new char[characterIterator.getEndIndex() - characterIterator.getBeginIndex()];
        char c2 = characterIterator.first();
        while (c2 != '\uffff') {
            cArray[characterIterator.getIndex() - characterIterator.getBeginIndex()] = c2;
            c2 = characterIterator.next();
        }
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        this.initTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, 0, cArray.length, this.fontTX, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }
}

