/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathException;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XObjectFactory;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XObject
extends Expression
implements Serializable,
Cloneable {
    protected Object m_obj;
    public static final int CLASS_NULL = -1;
    public static final int CLASS_UNKNOWN = 0;
    public static final int CLASS_BOOLEAN = 1;
    public static final int CLASS_NUMBER = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_NODESET = 4;
    public static final int CLASS_RTREEFRAG = 5;
    public static final int CLASS_UNRESOLVEDVARIABLE = 600;

    public double num() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return 0.0;
    }

    public double numWithSideEffects() throws TransformerException {
        return this.num();
    }

    public int getType() {
        return 0;
    }

    public int rtf() {
        return -1;
    }

    public XObject() {
    }

    public void destruct() {
        if (null != this.m_obj) {
            this.allowDetachToRelease(true);
            this.detach();
            this.m_obj = null;
        }
    }

    public void detach() {
    }

    public boolean bool() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return false;
    }

    public boolean boolWithSideEffects() throws TransformerException {
        return this.bool();
    }

    protected void error(int n2) throws TransformerException {
        this.error(n2, null);
    }

    public void allowDetachToRelease(boolean bl2) {
    }

    public Object object() {
        return this.m_obj;
    }

    protected void error(int n2, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n2, objectArray);
        throw new XPathException(string);
    }

    public XObject(Object object) {
        this.m_obj = object;
    }

    public String getTypeString() {
        return "#UNKNOWN (" + this.object().getClass().getName() + ")";
    }

    public String str() {
        return this.m_obj != null ? this.m_obj.toString() : "";
    }

    public String toString() {
        return this.str();
    }

    public void fixupVariables(Vector vector, int n2) {
    }

    public DTMIterator iter() throws TransformerException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append(this.str());
    }

    public XMLString xstr() {
        return XMLStringFactoryImpl.getFactory().newstr(this.str());
    }

    public NodeSetDTM mutableNodeset() throws TransformerException {
        this.error(20, new Object[]{this.getTypeString()});
        return (NodeSetDTM)this.m_obj;
    }

    public int rtf(XPathContext xPathContext) {
        int n2 = this.rtf();
        if (-1 == n2) {
            DTM dTM = xPathContext.createDocumentFragment();
            dTM.appendTextChild(this.str());
            n2 = dTM.getDocument();
        }
        return n2;
    }

    public boolean equals(XObject xObject) {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        if (null != this.m_obj) {
            return this.m_obj.equals(xObject.m_obj);
        }
        return xObject.m_obj == null;
    }

    public boolean greaterThan(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.lessThan(this);
        }
        return this.num() > xObject.num();
    }

    public boolean greaterThanOrEqual(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.lessThanOrEqual(this);
        }
        return this.num() >= xObject.num();
    }

    public boolean lessThan(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.greaterThan(this);
        }
        return this.num() < xObject.num();
    }

    public boolean lessThanOrEqual(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.greaterThanOrEqual(this);
        }
        return this.num() <= xObject.num();
    }

    public boolean notEquals(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.notEquals(this);
        }
        return !this.equals(xObject);
    }

    public DocumentFragment rtree() {
        return null;
    }

    public NodeList nodelist() throws TransformerException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public NodeIterator nodeset() throws TransformerException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        this.xstr().dispatchCharactersEvents(contentHandler);
    }

    public Object castToType(int n2, XPathContext xPathContext) throws TransformerException {
        Object object;
        switch (n2) {
            case 3: {
                object = this.str();
                break;
            }
            case 2: {
                object = new Double(this.num());
                break;
            }
            case 4: {
                object = this.iter();
                break;
            }
            case 1: {
                object = new Boolean(this.bool());
                break;
            }
            case 0: {
                object = this.m_obj;
                break;
            }
            default: {
                this.error(21, new Object[]{this.getTypeString(), Integer.toString(n2)});
                object = null;
            }
        }
        return object;
    }

    public static XObject create(Object object) {
        return XObjectFactory.create(object);
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this;
    }

    public DocumentFragment rtree(XPathContext xPathContext) {
        DocumentFragment documentFragment = null;
        int n2 = this.rtf();
        if (-1 == n2) {
            DTM dTM = xPathContext.createDocumentFragment();
            dTM.appendTextChild(this.str());
            documentFragment = (DocumentFragment)dTM.getNode(dTM.getDocument());
        } else {
            DTM dTM = xPathContext.getDTM(n2);
            documentFragment = (DocumentFragment)dTM.getNode(dTM.getDocument());
        }
        return documentFragment;
    }

    public static XObject create(Object object, XPathContext xPathContext) {
        return XObjectFactory.create(object, xPathContext);
    }
}

