/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.lang.reflect.Method;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.IntStack;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.SourceTreeManager;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.OneStepIteratorForward;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.XMLReader;

public class XPathContext
extends DTMManager {
    private DTMManager m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
    SourceLocator[] m_saxLocations = new SourceLocator[4096];
    int m_saxLocationsTop = 0;
    private Object m_owner;
    private Method m_ownerGetErrorListener;
    private ExtensionsTable m_extensionsTable = new ExtensionsTable();
    private VariableStack m_variableStacks = new VariableStack();
    private SourceTreeManager m_sourceTreeManager = new SourceTreeManager();
    private ErrorListener m_errorListener;
    private ErrorListener m_defaultErrorListener;
    private URIResolver m_uriResolver;
    public XMLReader m_primaryReader;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    private Stack m_contextNodeLists = new Stack();
    public static final int RECURSIONLIMIT = 4096;
    private int[] m_currentNodes = new int[4096];
    protected int m_currentNodesFirstFree = 0;
    private NodeVector m_iteratorRoots = new NodeVector();
    private NodeVector m_predicateRoots = new NodeVector();
    private int[] m_currentExpressionNodes = new int[4096];
    protected int m_currentExpressionNodesFirstFree = 0;
    private IntStack m_predicatePos = new IntStack();
    private PrefixResolver[] m_prefixResolvers = new PrefixResolver[4096];
    private int m_prefixResolversTop = 0;
    private Stack m_axesIteratorStack = new Stack();
    XPathExpressionContext expressionContext = new XPathExpressionContext(this);

    public final int getContextNode() {
        return this.getCurrentNode();
    }

    public final int getCurrentExpressionNode() {
        return this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree - 1];
    }

    public int getCurrentExpressionNodesFirstFree() {
        return this.m_currentExpressionNodesFirstFree;
    }

    public final int getCurrentNode() {
        return this.m_currentNodes[this.m_currentNodesFirstFree - 1];
    }

    public int getCurrentNodeFirstFree() {
        return this.m_currentNodesFirstFree;
    }

    public final int getIteratorRoot() {
        return this.m_iteratorRoots.peepOrNull();
    }

    public final int getPredicatePos() {
        return this.m_predicatePos.peek();
    }

    public final int getPredicateRoot() {
        return this.m_predicateRoots.peepOrNull();
    }

    public XPathContext() {
        this.m_prefixResolvers[this.m_prefixResolversTop++] = null;
        this.m_currentNodes[this.m_currentNodesFirstFree++] = -1;
        this.m_currentNodes[this.m_currentExpressionNodesFirstFree++] = -1;
        this.m_saxLocations[this.m_saxLocationsTop++] = null;
    }

    public final void popContextNodeList() {
        this.m_contextNodeLists.pop();
    }

    public final void popCurrentExpressionNode() {
        --this.m_currentExpressionNodesFirstFree;
    }

    public final void popCurrentNode() {
        --this.m_currentNodesFirstFree;
    }

    public final void popCurrentNodeAndExpression() {
        --this.m_currentNodesFirstFree;
        --this.m_currentExpressionNodesFirstFree;
    }

    public final void popExpressionState() {
        --this.m_currentNodesFirstFree;
        --this.m_currentExpressionNodesFirstFree;
        --this.m_prefixResolversTop;
    }

    public final void popIteratorRoot() {
        this.m_iteratorRoots.popQuick();
    }

    public final void popNamespaceContext() {
        --this.m_prefixResolversTop;
    }

    public final void popPredicatePos() {
        this.m_predicatePos.pop();
    }

    public final void popPredicateRoot() {
        this.m_predicateRoots.popQuick();
    }

    public void popSAXLocator() {
        --this.m_saxLocationsTop;
    }

    public final void popSubContextList() {
        this.m_axesIteratorStack.pop();
    }

    public final void pushNamespaceContextNull() {
        ++this.m_prefixResolversTop;
    }

    public void pushSAXLocatorNull() {
        ++this.m_saxLocationsTop;
    }

    public void reset() {
        this.m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
    }

    public int[] getCurrentExpressionNodeStack() {
        return this.m_currentExpressionNodes;
    }

    public int[] getCurrentNodeStack() {
        return this.m_currentNodes;
    }

    public final void pushCurrentExpressionNode(int n2) {
        this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree++] = n2;
    }

    public final void pushCurrentNode(int n2) {
        this.m_currentNodes[this.m_currentNodesFirstFree++] = n2;
    }

    public final void pushIteratorRoot(int n2) {
        this.m_iteratorRoots.push(n2);
    }

    public final void pushPredicatePos(int n2) {
        this.m_predicatePos.push(n2);
    }

    public final void pushPredicateRoot(int n2) {
        this.m_predicateRoots.push(n2);
    }

    public final void pushCurrentNodeAndExpression(int n2, int n3) {
        this.m_currentNodes[this.m_currentNodesFirstFree++] = n2;
        this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree++] = n2;
    }

    public void setCurrentExpressionNodeStack(int[] nArray) {
        this.m_currentExpressionNodes = nArray;
    }

    public void setCurrentNodeStack(int[] nArray) {
        this.m_currentNodes = nArray;
    }

    public Object getOwnerObject() {
        return this.m_owner;
    }

    public XPathContext(Object object) {
        this.m_owner = object;
        try {
            this.m_ownerGetErrorListener = this.m_owner.getClass().getMethod("getErrorListener", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.m_prefixResolvers[this.m_prefixResolversTop++] = null;
        this.m_currentNodes[this.m_currentNodesFirstFree++] = -1;
        this.m_currentNodes[this.m_currentExpressionNodesFirstFree++] = -1;
        this.m_saxLocations[this.m_saxLocationsTop++] = null;
    }

    private void assertion(boolean bl2, String string) throws TransformerException {
        ErrorListener errorListener = this.getErrorListener();
        if (errorListener != null) {
            errorListener.fatalError(new TransformerException(XSLMessages.createMessage(30, new Object[]{string}), (SAXSourceLocator)this.getSAXLocator()));
        }
    }

    public Stack getAxesIteratorStackStacks() {
        return this.m_axesIteratorStack;
    }

    public Stack getContextNodeListsStack() {
        return this.m_contextNodeLists;
    }

    public void setAxesIteratorStackStacks(Stack stack) {
        this.m_axesIteratorStack = stack;
    }

    public void setContextNodeListsStack(Stack stack) {
        this.m_contextNodeLists = stack;
    }

    public final ErrorListener getErrorListener() {
        if (null != this.m_errorListener) {
            return this.m_errorListener;
        }
        ErrorListener errorListener = null;
        try {
            if (null != this.m_ownerGetErrorListener) {
                errorListener = (ErrorListener)this.m_ownerGetErrorListener.invoke(this.m_owner, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == errorListener) {
            if (null == this.m_defaultErrorListener) {
                this.m_defaultErrorListener = new DefaultErrorHandler();
            }
            errorListener = this.m_defaultErrorListener;
        }
        return errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException(XSLMessages.createXPATHMessage(75, null));
        }
        this.m_errorListener = errorListener;
    }

    public SourceLocator getSAXLocator() {
        return this.m_saxLocations[this.m_saxLocationsTop - 1];
    }

    public void pushSAXLocator(SourceLocator sourceLocator) {
        this.m_saxLocations[this.m_saxLocationsTop++] = sourceLocator;
    }

    public void setSAXLocator(SourceLocator sourceLocator) {
        this.m_saxLocations[this.m_saxLocationsTop - 1] = sourceLocator;
    }

    public final URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public ExtensionsTable getExtensionsTable() {
        return this.m_extensionsTable;
    }

    void setExtensionsTable(ExtensionsTable extensionsTable) {
        this.m_extensionsTable = extensionsTable;
    }

    public DTM createDocumentFragment() {
        return this.m_dtmManager.createDocumentFragment();
    }

    public DTM getDTM(int n2) {
        return this.m_dtmManager.getDTM(n2);
    }

    public int getDTMIdentity(DTM dTM) {
        return this.m_dtmManager.getDTMIdentity(dTM);
    }

    public boolean release(DTM dTM, boolean bl2) {
        return this.m_dtmManager.release(dTM, bl2);
    }

    public final DTMIterator getContextNodeList() {
        if (this.m_contextNodeLists.size() > 0) {
            return (DTMIterator)this.m_contextNodeLists.peek();
        }
        return null;
    }

    public final DTMIterator getContextNodes() {
        try {
            DTMIterator dTMIterator = this.getContextNodeList();
            if (null != dTMIterator) {
                return dTMIterator.cloneWithReset();
            }
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public DTMIterator createDTMIterator(int n2) {
        OneStepIteratorForward oneStepIteratorForward = new OneStepIteratorForward(13);
        oneStepIteratorForward.setRoot(n2, this);
        return oneStepIteratorForward;
    }

    public final void pushContextNodeList(DTMIterator dTMIterator) {
        this.m_contextNodeLists.push(dTMIterator);
    }

    public DTMManager getDTMManager() {
        return this.m_dtmManager;
    }

    public final PrefixResolver getNamespaceContext() {
        return this.m_prefixResolvers[this.m_prefixResolversTop - 1];
    }

    public final void pushExpressionState(int n2, int n3, PrefixResolver prefixResolver) {
        this.m_currentNodes[this.m_currentNodesFirstFree++] = n2;
        this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree++] = n2;
        this.m_prefixResolvers[this.m_prefixResolversTop++] = prefixResolver;
    }

    public final void pushNamespaceContext(PrefixResolver prefixResolver) {
        this.m_prefixResolvers[this.m_prefixResolversTop++] = prefixResolver;
    }

    public final void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_prefixResolvers[this.m_prefixResolversTop - 1] = prefixResolver;
    }

    public final SourceTreeManager getSourceTreeManager() {
        return this.m_sourceTreeManager;
    }

    public void setSourceTreeManager(SourceTreeManager sourceTreeManager) {
        this.m_sourceTreeManager = sourceTreeManager;
    }

    public final VariableStack getVarStack() {
        return this.m_variableStacks;
    }

    public final void setVarStack(VariableStack variableStack) {
        this.m_variableStacks = variableStack;
    }

    public LocPathIterator getCurrentNodeList() {
        int n2 = this.m_axesIteratorStack.size() - 1;
        while (n2 >= 0) {
            PredicatedNodeTest predicatedNodeTest = (PredicatedNodeTest)this.m_axesIteratorStack.elementAt(n2);
            LocPathIterator locPathIterator = predicatedNodeTest.getLocPathIterator();
            if (locPathIterator.getIsTopLevel()) {
                return locPathIterator;
            }
            --n2;
        }
        return null;
    }

    public SubContextList getSubContextList() {
        return this.m_axesIteratorStack.isEmpty() ? null : (SubContextList)this.m_axesIteratorStack.peek();
    }

    public final void pushSubContextList(SubContextList subContextList) {
        this.m_axesIteratorStack.push(subContextList);
    }

    public int getDTMHandleFromNode(Node node) {
        return this.m_dtmManager.getDTMHandleFromNode(node);
    }

    public final XMLReader getPrimaryReader() {
        return this.m_primaryReader;
    }

    public void setPrimaryReader(XMLReader xMLReader) {
        this.m_primaryReader = xMLReader;
    }

    public DTMIterator createDTMIterator(Object object, int n2) {
        return this.m_dtmManager.createDTMIterator(object, n2);
    }

    public DTMIterator createDTMIterator(int n2, DTMFilter dTMFilter, boolean bl2) {
        return this.m_dtmManager.createDTMIterator(n2, dTMFilter, bl2);
    }

    static DTMManager access$000(XPathContext xPathContext) {
        return xPathContext.m_dtmManager;
    }

    static VariableStack access$100(XPathContext xPathContext) {
        return xPathContext.m_variableStacks;
    }

    public DTM getDTM(Source source, boolean bl2, DTMWSFilter dTMWSFilter, boolean bl3, boolean bl4) {
        return this.m_dtmManager.getDTM(source, bl2, dTMWSFilter, bl3, bl4);
    }

    public DTMIterator createDTMIterator(String string, PrefixResolver prefixResolver) {
        return this.m_dtmManager.createDTMIterator(string, prefixResolver);
    }

    public class XPathExpressionContext
    implements ExpressionContext {
        private final XPathContext this$0;

        public DTMManager getDTMManager() {
            return XPathContext.access$000(this.this$0);
        }

        public XPathContext getXPathContext() {
            return this.this$0;
        }

        public XPathExpressionContext(XPathContext xPathContext) {
            this.this$0 = xPathContext;
        }

        public Node getContextNode() {
            int n2 = this.this$0.getCurrentNode();
            return this.this$0.getDTM(n2).getNode(n2);
        }

        public double toNumber(Node node) {
            int n2 = this.this$0.getDTMHandleFromNode(node);
            DTM dTM = this.this$0.getDTM(n2);
            XString xString = (XString)dTM.getStringValue(n2);
            return xString.num();
        }

        public NodeIterator getContextNodes() {
            return new DTMNodeIterator(this.this$0.getContextNodeList());
        }

        public String toString(Node node) {
            int n2 = this.this$0.getDTMHandleFromNode(node);
            DTM dTM = this.this$0.getDTM(n2);
            XMLString xMLString = dTM.getStringValue(n2);
            return xMLString.toString();
        }

        public final XObject getVariableOrParam(QName qName) throws TransformerException {
            return XPathContext.access$100(this.this$0).getVariableOrParam(this.this$0, qName);
        }
    }
}

