/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.util.Locale;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TreeWalker {
    private Node startPoint;
    private Node current;

    public void reset() {
        this.current = this.startPoint;
    }

    public Node getCurrent() {
        return this.current;
    }

    public Node getNext() {
        if (this.current == null) {
            return null;
        }
        switch (this.current.getNodeType()) {
            case 1: 
            case 5: 
            case 9: 
            case 11: {
                Node node = this.current.getFirstChild();
                if (node != null) {
                    this.current = node;
                    return node;
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                Node node;
                Node node2 = this.current;
                while (node2 != null && node2 != this.startPoint) {
                    node = node2.getNextSibling();
                    if (node != null) {
                        this.current = node;
                        return node;
                    }
                    node2 = node2.getParentNode();
                }
                this.current = null;
                return null;
            }
        }
        throw new InternalError(((NodeBase)this.startPoint).getMessage("TW-000", new Object[]{Short.toString(this.current.getNodeType())}));
    }

    public Node removeCurrent() {
        if (this.current == null) {
            throw new IllegalStateException(((NodeBase)this.startPoint).getMessage("TW-001"));
        }
        Node node = this.current;
        Node node2 = this.current.getParentNode();
        Node node3 = null;
        if (node2 == null) {
            throw new IllegalStateException(((NodeBase)this.startPoint).getMessage("TW-002"));
        }
        Node node4 = this.current;
        while (node4 != null && node4 != this.startPoint) {
            node3 = node4.getNextSibling();
            if (node3 != null) {
                this.current = node3;
                break;
            }
            node4 = node4.getParentNode();
        }
        node2.removeChild(node);
        return node3;
    }

    public TreeWalker(Node node) {
        if (node == null) {
            throw new IllegalArgumentException(XmlDocument.catalog.getMessage(Locale.getDefault(), "TW-004"));
        }
        if (!(node instanceof NodeBase)) {
            throw new IllegalArgumentException(XmlDocument.catalog.getMessage(Locale.getDefault(), "TW-003"));
        }
        this.startPoint = this.current = node;
    }

    public Element getNextElement(String string) {
        Node node = this.getNext();
        while (node != null) {
            if (node.getNodeType() == 1 && (string == null || string.equals(node.getNodeName()))) {
                return (Element)node;
            }
            node = this.getNext();
        }
        this.current = null;
        return null;
    }

    public Element getNextElement(String string, String string2) {
        Node node = this.getNext();
        while (node != null) {
            if (node.getNodeType() == 1 && (string == null || string.equals(node.getNamespaceURI())) && (string2 == null || string2.equals(node.getLocalName()))) {
                return (Element)node;
            }
            node = this.getNext();
        }
        this.current = null;
        return null;
    }
}

