/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.PathPlaceHolder;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
    protected int selectionMode = 4;
    protected TreePath leadPath;
    protected int leadIndex = -1;
    protected int leadRow = -1;
    private Hashtable uniquePaths = new Hashtable();
    private Hashtable lastPaths = new Hashtable();
    private TreePath[] tempPaths = new TreePath[1];
    static Class class$javax$swing$event$TreeSelectionListener;

    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    public int getMaxSelectionRow() {
        return this.listSelectionModel.getMaxSelectionIndex();
    }

    public int getMinSelectionRow() {
        return this.listSelectionModel.getMinSelectionIndex();
    }

    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.length;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void clearSelection() {
        if (this.selection != null) {
            int n2 = this.selection.length;
            boolean[] blArray = new boolean[n2];
            int n3 = 0;
            while (n3 < n2) {
                blArray[n3] = false;
                ++n3;
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, this.selection, blArray, this.leadPath, null);
            this.leadPath = null;
            this.leadRow = -1;
            this.leadIndex = -1;
            this.uniquePaths.clear();
            this.selection = null;
            this.resetRowSelection();
            this.fireValueChanged(treeSelectionEvent);
        }
    }

    protected void insureRowContinuity() {
        if (this.selectionMode == 2 && this.selection != null && this.rowMapper != null) {
            DefaultListSelectionModel defaultListSelectionModel = this.listSelectionModel;
            int n2 = defaultListSelectionModel.getMinSelectionIndex();
            if (n2 != -1) {
                int n3 = n2;
                int n4 = defaultListSelectionModel.getMaxSelectionIndex();
                while (n3 <= n4) {
                    if (!defaultListSelectionModel.isSelectedIndex(n3)) {
                        if (n3 != n2) {
                            TreePath[] treePathArray = new TreePath[n3 - n2];
                            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
                            int n5 = 0;
                            while (n5 < nArray.length) {
                                if (nArray[n5] < n3) {
                                    treePathArray[nArray[n5] - n2] = this.selection[n5];
                                }
                                ++n5;
                            }
                            this.setSelectionPaths(treePathArray);
                            break;
                        }
                        this.clearSelection();
                    }
                    ++n3;
                }
            }
        } else if (this.selectionMode == 1 && this.selection != null && this.selection.length > 1) {
            this.setSelectionPath(this.selection[0]);
        }
    }

    protected void insureUniqueness() {
    }

    public void resetRowSelection() {
        this.listSelectionModel.clearSelection();
        if (this.selection != null && this.rowMapper != null) {
            boolean bl2 = false;
            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
            int n2 = 0;
            int n3 = this.selection.length;
            while (n2 < n3) {
                int n4 = nArray[n2];
                if (n4 != -1) {
                    this.listSelectionModel.addSelectionInterval(n4, n4);
                }
                ++n2;
            }
            if (this.leadIndex != -1 && nArray != null) {
                this.leadRow = nArray[this.leadIndex];
            } else if (this.leadPath != null) {
                this.tempPaths[0] = this.leadPath;
                nArray = this.rowMapper.getRowsForPaths(this.tempPaths);
                this.leadRow = nArray != null ? nArray[0] : -1;
            } else {
                this.leadRow = -1;
            }
            this.insureRowContinuity();
        } else {
            this.leadRow = -1;
        }
    }

    protected void updateLeadIndex() {
        if (this.leadPath != null) {
            if (this.selection == null) {
                this.leadPath = null;
                this.leadRow = -1;
                this.leadIndex = -1;
            } else {
                this.leadIndex = -1;
                this.leadRow = -1;
                int n2 = this.selection.length - 1;
                while (n2 >= 0) {
                    if (this.selection[n2] == this.leadPath) {
                        this.leadIndex = n2;
                        break;
                    }
                    --n2;
                }
            }
        } else {
            this.leadIndex = -1;
        }
    }

    public boolean isSelectionEmpty() {
        return this.selection == null;
    }

    public int[] getSelectionRows() {
        if (this.rowMapper != null && this.selection != null) {
            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
            if (nArray != null) {
                int n2 = 0;
                int n3 = nArray.length - 1;
                while (n3 >= 0) {
                    if (nArray[n3] == -1) {
                        ++n2;
                    }
                    --n3;
                }
                if (n2 > 0) {
                    if (n2 == nArray.length) {
                        nArray = null;
                    } else {
                        int[] nArray2 = new int[nArray.length - n2];
                        int n4 = nArray.length - 1;
                        int n5 = 0;
                        while (n4 >= 0) {
                            if (nArray[n4] != -1) {
                                nArray2[n5++] = nArray[n4];
                            }
                            --n4;
                        }
                        nArray = nArray2;
                    }
                }
            }
            return nArray;
        }
        return null;
    }

    public void setSelectionMode(int n2) {
        int n3 = this.selectionMode;
        this.selectionMode = n2;
        if (this.selectionMode != 1 && this.selectionMode != 2 && this.selectionMode != 4) {
            this.selectionMode = 4;
        }
        if (n3 != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(n3), new Integer(this.selectionMode));
        }
    }

    public boolean isRowSelected(int n2) {
        return this.listSelectionModel.isSelectedIndex(n2);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        if (objectArray.length > 0 && objectArray[0].equals("rowMapper")) {
            this.rowMapper = (RowMapper)objectArray[1];
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.rowMapper != null && this.rowMapper instanceof Serializable ? new Object[]{"rowMapper", this.rowMapper} : new Object[]{};
        objectOutputStream.writeObject(objectArray);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultTreeSelectionModel defaultTreeSelectionModel = (DefaultTreeSelectionModel)super.clone();
        defaultTreeSelectionModel.changeSupport = null;
        if (this.selection != null) {
            int n2 = this.selection.length;
            defaultTreeSelectionModel.selection = new TreePath[n2];
            System.arraycopy(this.selection, 0, defaultTreeSelectionModel.selection, 0, n2);
        }
        defaultTreeSelectionModel.listenerList = new EventListenerList();
        defaultTreeSelectionModel.listSelectionModel = (DefaultListSelectionModel)this.listSelectionModel.clone();
        defaultTreeSelectionModel.uniquePaths = new Hashtable();
        defaultTreeSelectionModel.lastPaths = new Hashtable();
        defaultTreeSelectionModel.tempPaths = new TreePath[1];
        return defaultTreeSelectionModel;
    }

    public String toString() {
        int n2 = this.getSelectionCount();
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.rowMapper != null ? this.rowMapper.getRowsForPaths(this.selection) : null;
        stringBuffer.append(this.getClass().getName() + " " + this.hashCode() + " [ ");
        int n3 = 0;
        while (n3 < n2) {
            if (nArray != null) {
                stringBuffer.append(this.selection[n3].toString() + "@" + Integer.toString(nArray[n3]) + " ");
            } else {
                stringBuffer.append(this.selection[n3].toString() + " ");
            }
            ++n3;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$TreeSelectionListener == null ? DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener") : class$javax$swing$event$TreeSelectionListener)) {
                ((TreeSelectionListener)objectArray[n2 + 1]).valueChanged(treeSelectionEvent);
            }
            n2 -= 2;
        }
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.listenerList.getListeners(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener, treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener, treeSelectionListener);
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
        this.resetRowSelection();
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public TreePath getSelectionPath() {
        if (this.selection != null) {
            return this.selection[0];
        }
        return null;
    }

    public TreePath[] getSelectionPaths() {
        if (this.selection != null) {
            int n2 = this.selection.length;
            TreePath[] treePathArray = new TreePath[n2];
            System.arraycopy(this.selection, 0, treePathArray, 0, n2);
            return treePathArray;
        }
        return null;
    }

    public void addSelectionPath(TreePath treePath) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.addSelectionPaths(treePathArray);
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.removeSelectionPaths(treePathArray);
        }
    }

    public void setSelectionPath(TreePath treePath) {
        if (treePath == null) {
            this.setSelectionPaths(null);
        } else {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.setSelectionPaths(treePathArray);
        }
    }

    public boolean isPathSelected(TreePath treePath) {
        return treePath != null ? this.uniquePaths.get(treePath) != null : false;
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        int n2;
        int n3 = n2 = treePathArray == null ? 0 : treePathArray.length;
        if (n2 > 0) {
            if (this.selectionMode == 1) {
                this.setSelectionPaths(treePathArray);
            } else if (this.selectionMode == 2 && !this.canPathsBeAdded(treePathArray)) {
                if (this.arePathsContiguous(treePathArray)) {
                    this.setSelectionPaths(treePathArray);
                } else {
                    TreePath[] treePathArray2 = new TreePath[]{treePathArray[0]};
                    this.setSelectionPaths(treePathArray2);
                }
            } else {
                TreePath treePath = this.leadPath;
                Vector vector = null;
                int n4 = this.selection == null ? 0 : this.selection.length;
                this.lastPaths.clear();
                int n5 = 0;
                int n6 = 0;
                while (n5 < n2) {
                    if (treePathArray[n5] != null) {
                        if (this.uniquePaths.get(treePathArray[n5]) == null) {
                            ++n6;
                            if (vector == null) {
                                vector = new Vector();
                            }
                            vector.addElement(new PathPlaceHolder(treePathArray[n5], true));
                            this.uniquePaths.put(treePathArray[n5], Boolean.TRUE);
                            this.lastPaths.put(treePathArray[n5], Boolean.TRUE);
                        }
                        this.leadPath = treePathArray[n5];
                    }
                    ++n5;
                }
                if (this.leadPath == null) {
                    this.leadPath = treePath;
                }
                if (n6 > 0) {
                    TreePath[] treePathArray3 = new TreePath[n4 + n6];
                    if (n4 > 0) {
                        System.arraycopy(this.selection, 0, treePathArray3, 0, n4);
                    }
                    if (n6 != treePathArray.length) {
                        Enumeration enumeration = this.lastPaths.keys();
                        n5 = n4;
                        while (enumeration.hasMoreElements()) {
                            treePathArray3[n5++] = (TreePath)enumeration.nextElement();
                        }
                    } else {
                        System.arraycopy(treePathArray, 0, treePathArray3, n4, n6);
                    }
                    this.selection = treePathArray3;
                    this.insureUniqueness();
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(vector, treePath);
                } else {
                    this.leadPath = treePath;
                }
                this.lastPaths.clear();
            }
        }
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null && this.selection != null && treePathArray.length > 0) {
            if (!this.canPathsBeRemoved(treePathArray)) {
                this.clearSelection();
            } else {
                Vector vector = null;
                int n2 = treePathArray.length - 1;
                while (n2 >= 0) {
                    if (treePathArray[n2] != null && this.uniquePaths.get(treePathArray[n2]) != null) {
                        if (vector == null) {
                            vector = new Vector(treePathArray.length);
                        }
                        this.uniquePaths.remove(treePathArray[n2]);
                        vector.addElement(new PathPlaceHolder(treePathArray[n2], false));
                    }
                    --n2;
                }
                if (vector != null) {
                    int n3 = vector.size();
                    TreePath treePath = this.leadPath;
                    if (n3 == this.selection.length) {
                        this.selection = null;
                    } else {
                        Enumeration enumeration = this.uniquePaths.keys();
                        int n4 = 0;
                        this.selection = new TreePath[this.selection.length - n3];
                        while (enumeration.hasMoreElements()) {
                            this.selection[n4++] = (TreePath)enumeration.nextElement();
                        }
                    }
                    this.leadPath = this.leadPath != null && this.uniquePaths.get(this.leadPath) == null ? (this.selection != null ? this.selection[this.selection.length - 1] : null) : (this.selection != null ? this.selection[this.selection.length - 1] : null);
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(vector, treePath);
                }
            }
        }
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        int n2;
        TreePath[] treePathArray2 = treePathArray;
        int n3 = treePathArray2 == null ? 0 : treePathArray2.length;
        if (n3 + (n2 = this.selection == null ? 0 : this.selection.length) != 0) {
            Object object;
            TreePath[] treePathArray3;
            if (this.selectionMode == 1) {
                if (n3 > 1) {
                    treePathArray2 = new TreePath[]{treePathArray[0]};
                    n3 = 1;
                }
            } else if (this.selectionMode == 2 && n3 > 0 && !this.arePathsContiguous(treePathArray2)) {
                treePathArray2 = new TreePath[]{treePathArray[0]};
                n3 = 1;
            }
            int n4 = 0;
            TreePath treePath = this.leadPath;
            Vector vector = new Vector(n3 + n2);
            this.lastPaths.clear();
            this.leadPath = null;
            int n5 = 0;
            while (n5 < n3) {
                if (treePathArray2[n5] != null && this.lastPaths.get(treePathArray2[n5]) == null) {
                    ++n4;
                    this.lastPaths.put(treePathArray2[n5], Boolean.TRUE);
                    if (this.uniquePaths.get(treePathArray2[n5]) == null) {
                        vector.addElement(new PathPlaceHolder(treePathArray2[n5], true));
                    }
                    this.leadPath = treePathArray2[n5];
                }
                ++n5;
            }
            if (n4 == 0) {
                treePathArray3 = null;
            } else if (n4 != n3) {
                object = this.lastPaths.keys();
                treePathArray3 = new TreePath[n4];
                n4 = 0;
                while (object.hasMoreElements()) {
                    treePathArray3[n4++] = (TreePath)object.nextElement();
                }
            } else {
                treePathArray3 = new TreePath[treePathArray2.length];
                System.arraycopy(treePathArray2, 0, treePathArray3, 0, treePathArray2.length);
            }
            int n6 = 0;
            while (n6 < n2) {
                if (this.selection[n6] != null && this.lastPaths.get(this.selection[n6]) == null) {
                    vector.addElement(new PathPlaceHolder(this.selection[n6], false));
                }
                ++n6;
            }
            this.selection = treePathArray3;
            object = this.uniquePaths;
            this.uniquePaths = this.lastPaths;
            this.lastPaths = object;
            this.lastPaths.clear();
            if (this.selection != null) {
                this.insureUniqueness();
            }
            this.updateLeadIndex();
            this.resetRowSelection();
            if (vector.size() > 0) {
                this.notifyPathChange(vector, treePath);
            }
        }
    }

    protected boolean arePathsContiguous(TreePath[] treePathArray) {
        if (this.rowMapper == null || treePathArray.length < 2) {
            return true;
        }
        BitSet bitSet = new BitSet(32);
        int n2 = treePathArray.length;
        int n3 = 0;
        TreePath[] treePathArray2 = new TreePath[]{treePathArray[0]};
        int n4 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        int n5 = 0;
        while (n5 < n2) {
            if (treePathArray[n5] != null) {
                treePathArray2[0] = treePathArray[n5];
                int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
                if (nArray == null) {
                    return false;
                }
                int n6 = nArray[0];
                if (n6 == -1 || n6 < n4 - n2 || n6 > n4 + n2) {
                    return false;
                }
                if (n6 < n4) {
                    n4 = n6;
                }
                if (!bitSet.get(n6)) {
                    bitSet.set(n6);
                    ++n3;
                }
            }
            ++n5;
        }
        int n7 = n3 + n4;
        n5 = n4;
        while (n5 < n7) {
            if (!bitSet.get(n5)) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    protected boolean canPathsBeAdded(TreePath[] treePathArray) {
        int n2;
        if (treePathArray == null || treePathArray.length == 0 || this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        DefaultListSelectionModel defaultListSelectionModel = this.listSelectionModel;
        int n3 = defaultListSelectionModel.getMinSelectionIndex();
        int n4 = defaultListSelectionModel.getMaxSelectionIndex();
        TreePath[] treePathArray2 = new TreePath[1];
        if (n3 != -1) {
            n2 = n3;
            while (n2 <= n4) {
                if (defaultListSelectionModel.isSelectedIndex(n2)) {
                    bitSet.set(n2);
                }
                ++n2;
            }
        } else {
            treePathArray2[0] = treePathArray[0];
            n3 = n4 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        }
        n2 = treePathArray.length - 1;
        while (n2 >= 0) {
            if (treePathArray[n2] != null) {
                treePathArray2[0] = treePathArray[n2];
                int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
                if (nArray == null) {
                    return false;
                }
                int n5 = nArray[0];
                n3 = Math.min(n5, n3);
                n4 = Math.max(n5, n4);
                if (n5 == -1) {
                    return false;
                }
                bitSet.set(n5);
            }
            --n2;
        }
        n2 = n3;
        while (n2 <= n4) {
            if (!bitSet.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean canPathsBeRemoved(TreePath[] treePathArray) {
        if (this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        int n2 = treePathArray.length;
        int n3 = -1;
        int n4 = 0;
        TreePath[] treePathArray2 = new TreePath[1];
        this.lastPaths.clear();
        int n5 = 0;
        while (n5 < n2) {
            if (treePathArray[n5] != null) {
                this.lastPaths.put(treePathArray[n5], Boolean.TRUE);
            }
            ++n5;
        }
        n5 = this.selection.length - 1;
        while (n5 >= 0) {
            if (this.lastPaths.get(this.selection[n5]) == null) {
                treePathArray2[0] = this.selection[n5];
                int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
                if (nArray != null && nArray[0] != -1 && !bitSet.get(nArray[0])) {
                    ++n4;
                    n3 = n3 == -1 ? nArray[0] : Math.min(n3, nArray[0]);
                    bitSet.set(nArray[0]);
                }
            }
            --n5;
        }
        this.lastPaths.clear();
        if (n4 > 1) {
            n5 = n3 + n4 - 1;
            while (n5 >= n3) {
                if (!bitSet.get(n5)) {
                    return false;
                }
                --n5;
            }
        }
        return true;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    protected void notifyPathChange(Vector vector, TreePath treePath) {
        int n2 = vector.size();
        boolean[] blArray = new boolean[n2];
        TreePath[] treePathArray = new TreePath[n2];
        int n3 = 0;
        while (n3 < n2) {
            PathPlaceHolder pathPlaceHolder = (PathPlaceHolder)vector.elementAt(n3);
            blArray[n3] = pathPlaceHolder.isNew;
            treePathArray[n3] = pathPlaceHolder.path;
            ++n3;
        }
        TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathArray, blArray, treePath, this.leadPath);
        this.fireValueChanged(treeSelectionEvent);
    }
}

