/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.text.rtf.AbstractFilter;

abstract class RTFParser
extends AbstractFilter {
    public int level = 0;
    private int state = 0;
    private StringBuffer currentCharacters = new StringBuffer();
    private String pendingKeyword = null;
    private int pendingCharacter;
    private long binaryBytesLeft;
    ByteArrayOutputStream binaryBuf;
    private boolean[] savedSpecials;
    protected PrintStream warnings;
    private final int S_text = 0;
    private final int S_backslashed = 1;
    private final int S_token = 2;
    private final int S_parameter = 3;
    private final int S_aftertick = 4;
    private final int S_aftertickc = 5;
    private final int S_inblob = 6;
    static final boolean[] rtfSpecialsTable = (boolean[])AbstractFilter.noSpecialsTable.clone();

    static {
        RTFParser.rtfSpecialsTable[10] = true;
        RTFParser.rtfSpecialsTable[13] = true;
        RTFParser.rtfSpecialsTable[123] = true;
        RTFParser.rtfSpecialsTable[125] = true;
        RTFParser.rtfSpecialsTable[92] = true;
    }

    public RTFParser() {
        this.specialsTable = rtfSpecialsTable;
    }

    public abstract void begingroup();

    public void close() throws IOException {
        this.flush();
        if (this.state != 0 || this.level > 0) {
            this.warning("Truncated RTF file.");
            while (this.level > 0) {
                this.endgroup();
                --this.level;
            }
        }
        super.close();
    }

    public abstract void endgroup();

    public void flush() throws IOException {
        super.flush();
        if (this.state == 0 && this.currentCharacters.length() > 0) {
            this.handleText(this.currentCharacters.toString());
            this.currentCharacters = new StringBuffer();
        }
    }

    public void handleText(char c2) {
        this.handleText(String.valueOf(c2));
    }

    public void write(char c2) throws IOException {
        switch (this.state) {
            case 0: {
                if (c2 == '\n' || c2 == '\r') break;
                if (c2 == '{') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    ++this.level;
                    this.begingroup();
                    break;
                }
                if (c2 == '}') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    if (this.level == 0) {
                        throw new IOException("Too many close-groups in RTF text");
                    }
                    this.endgroup();
                    --this.level;
                    break;
                }
                if (c2 == '\\') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    this.state = 1;
                    break;
                }
                this.currentCharacters.append(c2);
                break;
            }
            case 1: {
                if (c2 == '\'') {
                    this.state = 4;
                    break;
                }
                if (!Character.isLetter(c2)) {
                    char[] cArray = new char[]{c2};
                    if (!this.handleKeyword(new String(cArray))) {
                        this.warning("Unknown keyword: " + cArray + " (" + (byte)c2 + ")");
                    }
                    this.state = 0;
                    this.pendingKeyword = null;
                    break;
                }
                this.state = 2;
            }
            case 2: {
                if (Character.isLetter(c2)) {
                    this.currentCharacters.append(c2);
                    break;
                }
                this.pendingKeyword = this.currentCharacters.toString();
                this.currentCharacters = new StringBuffer();
                if (Character.isDigit(c2) || c2 == '-') {
                    this.state = 3;
                    this.currentCharacters.append(c2);
                    break;
                }
                boolean bl2 = this.handleKeyword(this.pendingKeyword);
                if (!bl2) {
                    this.warning("Unknown keyword: " + this.pendingKeyword);
                }
                this.pendingKeyword = null;
                this.state = 0;
                if (Character.isWhitespace(c2)) break;
                this.write(c2);
                break;
            }
            case 3: {
                if (Character.isDigit(c2)) {
                    this.currentCharacters.append(c2);
                    break;
                }
                if (this.pendingKeyword.equals("bin")) {
                    long l2 = Long.parseLong(this.currentCharacters.toString());
                    this.pendingKeyword = null;
                    this.state = 6;
                    this.binaryBytesLeft = l2;
                    this.binaryBuf = this.binaryBytesLeft > Integer.MAX_VALUE ? new ByteArrayOutputStream(Integer.MAX_VALUE) : new ByteArrayOutputStream((int)this.binaryBytesLeft);
                    this.savedSpecials = this.specialsTable;
                    this.specialsTable = AbstractFilter.allSpecialsTable;
                    break;
                }
                int n2 = Integer.parseInt(this.currentCharacters.toString());
                boolean bl3 = this.handleKeyword(this.pendingKeyword, n2);
                if (!bl3) {
                    this.warning("Unknown keyword: " + this.pendingKeyword + " (param " + this.currentCharacters + ")");
                }
                this.pendingKeyword = null;
                this.currentCharacters = new StringBuffer();
                this.state = 0;
                if (Character.isWhitespace(c2)) break;
                this.write(c2);
                break;
            }
            case 4: {
                if (Character.digit(c2, 16) == -1) {
                    this.state = 0;
                    break;
                }
                this.pendingCharacter = Character.digit(c2, 16);
                this.state = 5;
                break;
            }
            case 5: {
                this.state = 0;
                if (Character.digit(c2, 16) == -1) break;
                this.pendingCharacter = this.pendingCharacter * 16 + Character.digit(c2, 16);
                c2 = this.translationTable[this.pendingCharacter];
                if (c2 == '\u0000') break;
                this.handleText(c2);
                break;
            }
            case 6: {
                this.binaryBuf.write(c2);
                --this.binaryBytesLeft;
                if (this.binaryBytesLeft != 0L) break;
                this.state = 0;
                this.specialsTable = this.savedSpecials;
                this.savedSpecials = null;
                this.handleBinaryBlob(this.binaryBuf.toByteArray());
                this.binaryBuf = null;
            }
        }
    }

    public void writeSpecial(int n2) throws IOException {
        this.write((char)n2);
    }

    public abstract void handleBinaryBlob(byte[] var1);

    public abstract void handleText(String var1);

    protected void warning(String string) {
        if (this.warnings != null) {
            this.warnings.println(string);
        }
    }

    public void write(String string) throws IOException {
        if (this.state != 0) {
            int n2 = 0;
            int n3 = string.length();
            while (n2 < n3 && this.state != 0) {
                this.write(string.charAt(n2));
                ++n2;
            }
            if (n2 >= n3) {
                return;
            }
            string = string.substring(n2);
        }
        if (this.currentCharacters.length() > 0) {
            this.currentCharacters.append(string);
        } else {
            this.handleText(string);
        }
    }

    public abstract boolean handleKeyword(String var1);

    public abstract boolean handleKeyword(String var1, int var2);
}

