/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.StyleSheet;

public class ParagraphView
extends javax.swing.text.ParagraphView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private CSS.LengthValue cssWidth;
    private CSS.LengthValue cssHeight;

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            super.setPropertiesFromAttributes();
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            Object object = this.attr.getAttribute(CSS.Attribute.TEXT_ALIGN);
            if (object != null) {
                String string = object.toString();
                if (string.equals("left")) {
                    this.setJustification(0);
                } else if (string.equals("center")) {
                    this.setJustification(1);
                } else if (string.equals("right")) {
                    this.setJustification(2);
                } else if (string.equals("justify")) {
                    this.setJustification(3);
                }
            }
            this.cssWidth = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.WIDTH);
            this.cssHeight = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.HEIGHT);
        }
    }

    public boolean isVisible() {
        View view;
        int n2 = this.getLayoutViewCount() - 1;
        int n3 = 0;
        while (n3 < n2) {
            view = this.getLayoutView(n3);
            if (view.isVisible()) {
                return true;
            }
            ++n3;
        }
        if (n2 > 0 && (view = this.getLayoutView(n2)).getEndOffset() - view.getStartOffset() == 1) {
            return false;
        }
        if (this.getStartOffset() == this.getDocument().getLength()) {
            boolean bl2 = false;
            Container container = this.getContainer();
            if (container instanceof JTextComponent) {
                bl2 = ((JTextComponent)container).isEditable();
            }
            if (!bl2) {
                return false;
            }
        }
        return true;
    }

    public float getMaximumSpan(int n2) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMaximumSpan(n2);
    }

    public float getMinimumSpan(int n2) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMinimumSpan(n2);
    }

    public float getPreferredSpan(int n2) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getPreferredSpan(n2);
    }

    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    public ParagraphView(Element element) {
        super(element);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, shape);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        if (!BlockView.spanSetFromAttributes(n2, sizeRequirements = super.calculateMinorAxisRequirements(n2, sizeRequirements), this.cssWidth, this.cssHeight)) {
            float f2 = 0.0f;
            int n3 = this.getLayoutViewCount();
            int n4 = 0;
            while (n4 < n3) {
                View view = this.getLayoutView(n4);
                if (view instanceof InlineView) {
                    float f3 = ((InlineView)view).getLongestWordSpan();
                    f2 = Math.max(f3, f2);
                } else {
                    f2 = Math.max(view.getMinimumSpan(n2), f2);
                }
                ++n4;
            }
            sizeRequirements.minimum = Math.max(sizeRequirements.minimum, (int)f2);
            sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
            sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
        } else {
            int n5 = n2 == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n5;
            sizeRequirements.preferred -= n5;
            sizeRequirements.maximum -= n5;
        }
        return sizeRequirements;
    }
}

