/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;

public class ObjectView
extends ComponentView {
    protected Component createComponent() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.CLASSID);
        try {
            Class clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            Object object = clazz.newInstance();
            if (object instanceof Component) {
                Component component = (Component)object;
                this.setParameters(component, attributeSet);
                return component;
            }
        }
        catch (Throwable throwable) {}
        return this.getUnloadableRepresentation();
    }

    Component getUnloadableRepresentation() {
        JLabel jLabel = new JLabel("??");
        ((Component)jLabel).setForeground(Color.red);
        return jLabel;
    }

    public ObjectView(Element element) {
        super(element);
    }

    private Class getClass(String string) throws ClassNotFoundException {
        Class clazz = this.getDocument().getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Class clazz2 = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
        return clazz2;
    }

    private void setParameters(Component component, AttributeSet attributeSet) {
        BeanInfo beanInfo;
        Class clazz = component.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            System.err.println("introspector failed, ex: " + introspectionException);
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n2 = 0;
        while (n2 < propertyDescriptorArray.length) {
            Object object = attributeSet.getAttribute(propertyDescriptorArray[n2].getName());
            if (object instanceof String) {
                String string = (String)object;
                Method method = propertyDescriptorArray[n2].getWriteMethod();
                if (method == null) {
                    return;
                }
                Class[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    return;
                }
                Object[] objectArray = new String[]{string};
                try {
                    method.invoke(component, objectArray);
                }
                catch (Exception exception) {
                    System.err.println("Invocation failed");
                }
            }
            ++n2;
        }
    }
}

