/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.StringTokenizer;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HTML;

class FrameSetView
extends BoxView {
    String[] children;
    int[] percentChildren;
    int[] absoluteChildren;
    int[] relativeChildren;
    int percentTotals;
    int absoluteTotals;
    int relativeTotals;

    private void init() {
        this.percentChildren = new int[this.children.length];
        this.relativeChildren = new int[this.children.length];
        this.absoluteChildren = new int[this.children.length];
        int n2 = 0;
        while (n2 < this.children.length) {
            this.percentChildren[n2] = -1;
            this.relativeChildren[n2] = -1;
            this.absoluteChildren[n2] = -1;
            if (this.children[n2].endsWith("*")) {
                if (this.children[n2].length() > 1) {
                    this.relativeChildren[n2] = Integer.parseInt(this.children[n2].substring(0, this.children[n2].length() - 1));
                    this.relativeTotals += this.relativeChildren[n2];
                } else {
                    this.relativeChildren[n2] = 1;
                    ++this.relativeTotals;
                }
            } else if (this.children[n2].indexOf(37) != -1) {
                this.percentChildren[n2] = this.parseDigits(this.children[n2]);
                this.percentTotals += this.percentChildren[n2];
            } else {
                this.absoluteChildren[n2] = Integer.parseInt(this.children[n2]);
            }
            ++n2;
        }
        if (this.percentTotals > 100) {
            int n3 = 0;
            while (n3 < this.percentChildren.length) {
                if (this.percentChildren[n3] > 0) {
                    this.percentChildren[n3] = this.percentChildren[n3] * 100 / this.percentTotals;
                }
                ++n3;
            }
            this.percentTotals = 100;
        }
    }

    protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateTiledPositions(n2, null, this.getChildRequests(n2, n3), nArray, nArray2);
    }

    private void spread(int n2, int[] nArray) {
        block14: {
            int n3;
            block13: {
                if (n2 == 0) {
                    return;
                }
                int n4 = 0;
                n3 = n2;
                int n5 = 0;
                while (n5 < nArray.length) {
                    if (this.absoluteChildren[n5] > 0) {
                        nArray[n5] = this.absoluteChildren[n5];
                        n3 -= nArray[n5];
                    }
                    ++n5;
                }
                n4 = n3;
                int n6 = 0;
                while (n6 < nArray.length) {
                    if (this.percentChildren[n6] > 0 && n4 > 0) {
                        nArray[n6] = this.percentChildren[n6] * n4 / 100;
                        n3 -= nArray[n6];
                    } else if (this.percentChildren[n6] > 0 && n4 <= 0) {
                        nArray[n6] = n2 / nArray.length;
                        n3 -= nArray[n6];
                    }
                    ++n6;
                }
                if (n3 <= 0 || this.relativeTotals <= 0) break block13;
                int n7 = 0;
                while (n7 < nArray.length) {
                    if (this.relativeChildren[n7] > 0) {
                        nArray[n7] = n3 * this.relativeChildren[n7] / this.relativeTotals;
                    }
                    ++n7;
                }
                break block14;
            }
            if (n3 <= 0) break block14;
            float f2 = n2 - n3;
            float[] fArray = new float[nArray.length];
            n3 = n2;
            int n8 = 0;
            while (n8 < nArray.length) {
                fArray[n8] = (float)nArray[n8] / f2 * 100.0f;
                nArray[n8] = (int)((float)n2 * fArray[n8] / 100.0f);
                n3 -= nArray[n8];
                ++n8;
            }
            int n9 = 0;
            while (n3 != 0) {
                if (n3 < 0) {
                    int n10 = n9++;
                    nArray[n10] = nArray[n10] - 1;
                    ++n3;
                } else {
                    int n11 = n9++;
                    nArray[n11] = nArray[n11] + 1;
                    --n3;
                }
                if (n9 != nArray.length) continue;
                n9 = 0;
            }
        }
    }

    private int parseDigits(String string) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if (Character.isDigit(c2)) {
                n2 = n2 * 10 + Character.digit(c2, 10);
            }
            ++n3;
        }
        return n2;
    }

    protected SizeRequirements[] getChildRequests(int n2, int n3) {
        int[] nArray = new int[this.children.length];
        this.spread(n2, nArray);
        int n4 = this.getViewCount();
        SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            View view = this.getView(n5);
            if (view instanceof FrameView || view instanceof FrameSetView) {
                sizeRequirementsArray[n5] = new SizeRequirements((int)view.getMinimumSpan(n3), nArray[n6], (int)view.getMaximumSpan(n3), 0.5f);
                ++n6;
            } else {
                int n7 = (int)view.getMinimumSpan(n3);
                int n8 = (int)view.getPreferredSpan(n3);
                int n9 = (int)view.getMaximumSpan(n3);
                float f2 = view.getAlignment(n3);
                sizeRequirementsArray[n5] = new SizeRequirements(n7, n8, n9, f2);
            }
            ++n5;
        }
        return sizeRequirementsArray;
    }

    public FrameSetView(Element element, int n2) {
        super(element, n2);
        this.children = n2 == 1 ? this.parseRowColSpec(HTML.Attribute.ROWS) : this.parseRowColSpec(HTML.Attribute.COLS);
        this.init();
    }

    private String[] parseRowColSpec(HTML.Attribute attribute) {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = "*";
        if (attributeSet != null && attributeSet.getAttribute(attribute) != null) {
            string = (String)attributeSet.getAttribute(attribute);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = stringTokenizer.nextToken().trim();
            if (stringArray[n3].equals("100%")) {
                stringArray[n3] = "*";
            }
            ++n3;
        }
        return stringArray;
    }
}

