/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public abstract class View
implements SwingConstants {
    public static final int BadBreakWeight = 0;
    public static final int GoodBreakWeight = 1000;
    public static final int ExcellentBreakWeight = 2000;
    public static final int ForcedBreakWeight = 3000;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    static final Position.Bias[] sharedBiasReturn = new Position.Bias[1];
    private View parent;
    private Element elem;

    public int getEndOffset() {
        return this.elem.getEndOffset();
    }

    public int getStartOffset() {
        return this.elem.getStartOffset();
    }

    public int getViewCount() {
        return 0;
    }

    public void removeAll() {
        this.replace(0, this.getViewCount(), null);
    }

    public boolean isVisible() {
        return true;
    }

    public void setSize(float f2, float f3) {
    }

    public float getAlignment(int n2) {
        return 0.5f;
    }

    public float getMaximumSpan(int n2) {
        int n3 = this.getResizeWeight(n2);
        if (n3 == 0) {
            return this.getPreferredSpan(n2);
        }
        return 2.1474836E9f;
    }

    public float getMinimumSpan(int n2) {
        int n3 = this.getResizeWeight(n2);
        if (n3 == 0) {
            return this.getPreferredSpan(n2);
        }
        return 0.0f;
    }

    public abstract float getPreferredSpan(int var1);

    public int getResizeWeight(int n2) {
        return 0;
    }

    public void remove(int n2) {
        this.replace(n2, 1, null);
    }

    public int getBreakWeight(int n2, float f2, float f3) {
        if (f3 > this.getPreferredSpan(n2)) {
            return 1000;
        }
        return 0;
    }

    public Container getContainer() {
        View view = this.getParent();
        return view != null ? view.getContainer() : null;
    }

    public Graphics getGraphics() {
        Container container = this.getContainer();
        return container.getGraphics();
    }

    public int getViewIndex(float f2, float f3, Shape shape) {
        int n2 = this.getViewCount() - 1;
        while (n2 >= 0) {
            Shape shape2 = this.getChildAllocation(n2, shape);
            if (shape2 != null) {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape.getBounds();
                if (rectangle.contains(f2, f3)) {
                    return n2;
                }
            }
            --n2;
        }
        return -1;
    }

    public int viewToModel(float f2, float f3, Shape shape) {
        View.sharedBiasReturn[0] = Position.Bias.Forward;
        return this.viewToModel(f2, f3, shape, sharedBiasReturn);
    }

    public AttributeSet getAttributes() {
        return this.elem.getAttributes();
    }

    public Document getDocument() {
        return this.elem.getDocument();
    }

    public Element getElement() {
        return this.elem;
    }

    public View(Element element) {
        this.elem = element;
    }

    public int getViewIndex(int n2, Position.Bias bias) {
        return -1;
    }

    public View getParent() {
        return this.parent;
    }

    public View getView(int n2) {
        return null;
    }

    public View createFragment(int n2, int n3) {
        return this;
    }

    public View breakView(int n2, int n3, float f2, float f3) {
        return this;
    }

    public void replace(int n2, int n3, View[] viewArray) {
    }

    public void insert(int n2, View view) {
        View[] viewArray = new View[]{view};
        this.replace(n2, 0, viewArray);
    }

    public void append(View view) {
        View[] viewArray = new View[]{view};
        this.replace(this.getViewCount(), 0, viewArray);
    }

    public void setParent(View view) {
        if (view == null) {
            int n2 = 0;
            while (n2 < this.getViewCount()) {
                if (this.getView(n2).getParent() == this) {
                    this.getView(n2).setParent(null);
                }
                ++n2;
            }
        }
        this.parent = view;
    }

    public void preferenceChanged(View view, boolean bl2, boolean bl3) {
        View view2 = this.getParent();
        if (view2 != null) {
            view2.preferenceChanged(this, bl2, bl3);
        }
    }

    public ViewFactory getViewFactory() {
        View view = this.getParent();
        return view != null ? view.getViewFactory() : null;
    }

    public abstract void paint(Graphics var1, Shape var2);

    public Shape getChildAllocation(int n2, Shape shape) {
        return null;
    }

    public Shape modelToView(int n2, Shape shape) throws BadLocationException {
        return this.modelToView(n2, shape, Position.Bias.Forward);
    }

    public String getToolTipText(float f2, float f3, Shape shape) {
        int n2 = this.getViewIndex(f2, f3, shape);
        if (n2 >= 0) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = (shape = this.getChildAllocation(n2, shape)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (rectangle.contains(f2, f3)) {
                return this.getView(n2).getToolTipText(f2, f3, shape);
            }
        }
        return null;
    }

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        if (elementChange != null && shape != null) {
            this.preferenceChanged(null, true, true);
            Container container = this.getContainer();
            if (container != null) {
                container.repaint();
            }
        }
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public int getNextVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        biasArray[0] = Position.Bias.Forward;
        switch (n3) {
            case 1: 
            case 5: {
                Rectangle rectangle;
                JTextComponent jTextComponent = (JTextComponent)this.getContainer();
                Caret caret = jTextComponent != null ? jTextComponent.getCaret() : null;
                Point point = caret != null ? caret.getMagicCaretPosition() : null;
                int n4 = point == null ? ((rectangle = jTextComponent.modelToView(n2)) == null ? 0 : rectangle.x) : point.x;
                if (n3 == 1) {
                    n2 = Utilities.getPositionAbove(jTextComponent, n2, n4);
                    break;
                }
                n2 = Utilities.getPositionBelow(jTextComponent, n2, n4);
                break;
            }
            case 7: {
                if (n2 == -1) {
                    n2 = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                n2 = Math.max(0, n2 - 1);
                break;
            }
            case 3: {
                if (n2 == -1) {
                    n2 = this.getStartOffset();
                    break;
                }
                n2 = Math.min(n2 + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n3);
            }
        }
        return n2;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.getViewCount() > 0) {
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
                elementChange = null;
            }
            this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
            this.updateLayout(elementChange, documentEvent, shape);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.getViewCount() > 0) {
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
                elementChange = null;
            }
            this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
            this.updateLayout(elementChange, documentEvent, shape);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.getViewCount() > 0) {
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
                elementChange = null;
            }
            this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
            this.updateLayout(elementChange, documentEvent, shape);
        }
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        int n2;
        Element[] elementArray = elementChange.getChildrenRemoved();
        Element[] elementArray2 = elementChange.getChildrenAdded();
        View[] viewArray = null;
        if (elementArray2 != null) {
            viewArray = new View[elementArray2.length];
            n2 = 0;
            while (n2 < elementArray2.length) {
                viewArray[n2] = viewFactory.create(elementArray2[n2]);
                ++n2;
            }
        }
        n2 = 0;
        int n3 = elementChange.getIndex();
        if (elementArray != null) {
            n2 = elementArray.length;
        }
        this.replace(n3, n2, viewArray);
        return true;
    }

    public Shape modelToView(int n2, Position.Bias bias, int n3, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        Rectangle rectangle2;
        Shape shape2;
        Shape shape3 = this.modelToView(n2, shape, bias);
        if (n3 == this.getEndOffset()) {
            try {
                shape2 = this.modelToView(n3, shape, bias2);
            }
            catch (BadLocationException badLocationException) {
                shape2 = null;
            }
            if (shape2 == null) {
                rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                shape2 = new Rectangle(rectangle2.x + rectangle2.width - 1, rectangle2.y, 1, rectangle2.height);
            }
        } else {
            shape2 = this.modelToView(n3, shape, bias2);
        }
        rectangle2 = shape3.getBounds();
        Rectangle rectangle3 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
        if (rectangle2.y != rectangle.y) {
            Rectangle rectangle4 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            rectangle2.x = rectangle4.x;
            rectangle2.width = rectangle4.width;
        }
        rectangle2.add(rectangle);
        return rectangle2;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element[] elementArray;
        int n2;
        View view;
        Element element = this.getElement();
        int n3 = documentEvent.getOffset();
        int n4 = this.getViewIndex(n3, Position.Bias.Forward);
        if (n4 == -1 && documentEvent.getType() == DocumentEvent.EventType.REMOVE && n3 >= this.getEndOffset()) {
            n4 = this.getViewCount() - 1;
        }
        int n5 = n4;
        View view2 = view = n4 >= 0 ? this.getView(n4) : null;
        if (view != null && view.getStartOffset() == n3 && n3 > 0) {
            n4 = Math.max(n4 - 1, 0);
        }
        if (documentEvent.getType() != DocumentEvent.EventType.REMOVE && (n5 = this.getViewIndex(n3 + documentEvent.getLength(), Position.Bias.Forward)) < 0) {
            n5 = this.getViewCount() - 1;
        }
        int n6 = n2 = n5 + 1;
        Element[] elementArray2 = elementArray = elementChange != null ? elementChange.getChildrenAdded() : null;
        if (elementArray != null && elementArray.length > 0) {
            n2 = elementChange.getIndex();
            n6 = n2 + elementArray.length - 1;
        }
        int n7 = n4 = Math.max(n4, 0);
        while (n7 <= n5) {
            if ((n7 < n2 || n7 > n6) && (view = this.getView(n7)) != null) {
                Shape shape2 = this.getChildAllocation(n7, shape);
                this.forwardUpdateToView(view, documentEvent, shape2, viewFactory);
            }
            ++n7;
        }
    }

    protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        DocumentEvent.EventType eventType = documentEvent.getType();
        if (eventType == DocumentEvent.EventType.INSERT) {
            view.insertUpdate(documentEvent, shape, viewFactory);
        } else if (eventType == DocumentEvent.EventType.REMOVE) {
            view.removeUpdate(documentEvent, shape, viewFactory);
        } else {
            view.changedUpdate(documentEvent, shape, viewFactory);
        }
    }
}

