/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static StyleContext defaultContext;
    public static final String DEFAULT_STYLE = "default";
    private static Hashtable freezeKeyMap;
    private static Hashtable thawKeyMap;
    private Style styles;
    private transient FontKey fontSearch = new FontKey(null, 0, 0);
    private transient Hashtable fontTable = new Hashtable();
    private transient Hashtable attributesPool = new Hashtable();
    private transient MutableAttributeSet search = new SimpleAttributeSet();
    private int unusedSets;
    static final int THRESHOLD = 9;
    static Class class$javax$swing$event$ChangeListener;

    protected int getCompressionThreshold() {
        return 9;
    }

    static {
        try {
            int n2 = StyleConstants.keys.length;
            int n3 = 0;
            while (n3 < n2) {
                StyleContext.registerStaticAttributeKey(StyleConstants.keys[n3]);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public StyleContext() {
        this.styles = new NamedStyle(this, null);
        this.addStyle(DEFAULT_STYLE, null);
    }

    synchronized void removeUnusedSets() {
        Vector vector = new Vector();
        Enumeration enumeration = this.attributesPool.keys();
        while (enumeration.hasMoreElements()) {
            SmallAttributeSet smallAttributeSet = (SmallAttributeSet)enumeration.nextElement();
            if (smallAttributeSet.nrefs > 0) continue;
            vector.addElement(smallAttributeSet);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.attributesPool.remove(enumeration.nextElement());
        }
        this.unusedSets = 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.fontSearch = new FontKey(null, 0, 0);
        this.fontTable = new Hashtable();
        this.search = new SimpleAttributeSet();
        this.attributesPool = new Hashtable();
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.removeUnusedSets();
        objectOutputStream.defaultWriteObject();
    }

    public static void registerStaticAttributeKey(Object object) {
        String string = object.getClass().getName() + "." + object.toString();
        if (freezeKeyMap == null) {
            freezeKeyMap = new Hashtable();
            thawKeyMap = new Hashtable();
        }
        freezeKeyMap.put(object, string);
        thawKeyMap.put(string, object);
    }

    public String toString() {
        this.removeUnusedSets();
        String string = "";
        Enumeration enumeration = this.attributesPool.keys();
        while (enumeration.hasMoreElements()) {
            SmallAttributeSet smallAttributeSet = (SmallAttributeSet)enumeration.nextElement();
            string = string + smallAttributeSet + "\n";
        }
        return string;
    }

    public void removeStyle(String string) {
        this.styles.removeAttribute(string);
    }

    public Enumeration getStyleNames() {
        return this.styles.getAttributeNames();
    }

    public ChangeListener[] getChangeListeners() {
        return ((NamedStyle)this.styles).getChangeListeners();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.styles.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.styles.removeChangeListener(changeListener);
    }

    public AttributeSet getEmptySet() {
        return SimpleAttributeSet.EMPTY;
    }

    AttributeSet getImmutableUniqueSet() {
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(this.search);
        SmallAttributeSet smallAttributeSet2 = (SmallAttributeSet)this.attributesPool.get(smallAttributeSet);
        if (smallAttributeSet2 == null) {
            smallAttributeSet2 = smallAttributeSet;
            this.attributesPool.put(smallAttributeSet2, smallAttributeSet2);
        }
        ++smallAttributeSet2.nrefs;
        return smallAttributeSet2;
    }

    public void reclaim(AttributeSet attributeSet) {
        if (attributeSet instanceof SmallAttributeSet) {
            SmallAttributeSet smallAttributeSet = (SmallAttributeSet)attributeSet;
            --smallAttributeSet.nrefs;
            if (smallAttributeSet.nrefs <= 0) {
                ++this.unusedSets;
                if (this.unusedSets > 10 && this.unusedSets > this.attributesPool.size() / 10) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.removeUnusedSets();
                    } else {
                        Runnable runnable = new Runnable(this){
                            private final StyleContext this$0;

                            public void run() {
                                this.this$0.removeUnusedSets();
                            }
                            {
                                this.this$0 = styleContext;
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            }
        }
    }

    public static final StyleContext getDefaultStyleContext() {
        if (defaultContext == null) {
            defaultContext = new StyleContext();
        }
        return defaultContext;
    }

    public Color getBackground(AttributeSet attributeSet) {
        return StyleConstants.getBackground(attributeSet);
    }

    public Color getForeground(AttributeSet attributeSet) {
        return StyleConstants.getForeground(attributeSet);
    }

    public Font getFont(String string, int n2, int n3) {
        this.fontSearch.setValue(string, n2, n3);
        Font font = (Font)this.fontTable.get(this.fontSearch);
        if (font == null) {
            font = new Font(string, n2, n3);
            FontKey fontKey = new FontKey(string, n2, n3);
            this.fontTable.put(fontKey, font);
        }
        return font;
    }

    public Font getFont(AttributeSet attributeSet) {
        int n2 = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n2 |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n2 |= 2;
        }
        String string = StyleConstants.getFontFamily(attributeSet);
        int n3 = StyleConstants.getFontSize(attributeSet);
        if (StyleConstants.isSuperscript(attributeSet) || StyleConstants.isSubscript(attributeSet)) {
            n3 -= 2;
        }
        return this.getFont(string, n2, n3);
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Object getStaticAttribute(Object object) {
        if (thawKeyMap == null || object == null) {
            return null;
        }
        return thawKeyMap.get(object);
    }

    public static Object getStaticAttributeKey(Object object) {
        return object.getClass().getName() + "." + object.toString();
    }

    public static void writeAttributeSet(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        int n2 = attributeSet.getAttributeCount();
        objectOutputStream.writeInt(n2);
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2 = enumeration.nextElement();
            if (object2 instanceof Serializable) {
                objectOutputStream.writeObject(object2);
            } else {
                object = freezeKeyMap.get(object2);
                if (object == null) {
                    throw new NotSerializableException(object2.getClass().getName() + " is not serializable as a key in an AttributeSet");
                }
                objectOutputStream.writeObject(object);
            }
            object = attributeSet.getAttribute(object2);
            if (object instanceof Serializable) {
                objectOutputStream.writeObject(object);
                continue;
            }
            Object object3 = freezeKeyMap.get(object);
            if (object3 == null) {
                throw new NotSerializableException(object.getClass().getName() + " is not serializable as a value in an AttributeSet");
            }
            objectOutputStream.writeObject(object3);
        }
    }

    public void writeAttributes(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        StyleContext.writeAttributeSet(objectOutputStream, attributeSet);
    }

    public static void readAttributeSet(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (thawKeyMap != null) {
                Object object3;
                Object object4 = thawKeyMap.get(object);
                if (object4 != null) {
                    object = object4;
                }
                if ((object3 = thawKeyMap.get(object2)) != null) {
                    object2 = object3;
                }
            }
            mutableAttributeSet.addAttribute(object, object2);
            ++n3;
        }
    }

    public void readAttributes(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        StyleContext.readAttributeSet(objectInputStream, mutableAttributeSet);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new SimpleAttributeSet(attributeSet);
    }

    MutableAttributeSet getMutableAttributeSet(AttributeSet attributeSet) {
        if (attributeSet instanceof MutableAttributeSet && attributeSet != SimpleAttributeSet.EMPTY) {
            return (MutableAttributeSet)attributeSet;
        }
        return this.createLargeAttributeSet(attributeSet);
    }

    public Style getStyle(String string) {
        return (Style)this.styles.getAttribute(string);
    }

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallAttributeSet(this, attributeSet);
    }

    public synchronized AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (attributeSet.getAttributeCount() - 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttribute(object);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttribute(object);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration enumeration) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(enumeration);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(enumeration);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() + attributeSet2.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    public Style addStyle(String string, Style style) {
        NamedStyle namedStyle = new NamedStyle(this, string, style);
        if (string != null) {
            this.styles.addAttribute(string, namedStyle);
        }
        return namedStyle;
    }

    public synchronized AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (attributeSet.getAttributeCount() + 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttribute(object, object2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttribute(object, object2);
        return mutableAttributeSet;
    }

    static class FontKey {
        private String family;
        private int style;
        private int size;

        public int hashCode() {
            int n2 = this.family != null ? this.family.hashCode() : 0;
            return n2 ^ this.style ^ this.size;
        }

        public boolean equals(Object object) {
            if (object instanceof FontKey) {
                FontKey fontKey = (FontKey)object;
                return this.size == fontKey.size && this.style == fontKey.style && this.family == fontKey.family;
            }
            return false;
        }

        public FontKey(String string, int n2, int n3) {
            this.setValue(string, n2, n3);
        }

        public void setValue(String string, int n2, int n3) {
            this.family = string != null ? string.intern() : null;
            this.style = n2;
            this.size = n3;
        }
    }

    class KeyBuilder {
        private Vector keys;
        private Vector data;
        private final StyleContext this$0;

        int getCount() {
            return this.keys.size();
        }

        public Object[] createTable() {
            int n2 = this.keys.size();
            Object[] objectArray = new Object[2 * n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 2 * n3;
                objectArray[n4] = this.keys.elementAt(n3);
                objectArray[n4 + 1] = this.data.elementAt(n3);
                ++n3;
            }
            return objectArray;
        }

        public void removeAttribute(Object object) {
            int n2 = this.keys.size();
            int n3 = 0;
            while (n3 < n2) {
                if (this.keys.elementAt(n3).equals(object)) {
                    this.keys.removeElementAt(n3);
                    this.data.removeElementAt(n3);
                    return;
                }
                ++n3;
            }
        }

        private void initialize(Object[] objectArray) {
            this.keys.removeAllElements();
            this.data.removeAllElements();
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.keys.addElement(objectArray[n3]);
                this.data.addElement(objectArray[n3 + 1]);
                n3 += 2;
            }
        }

        public void removeAttributes(Enumeration enumeration) {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                this.removeAttribute(object);
            }
        }

        public void addAttributes(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                Object[] objectArray = ((SmallAttributeSet)attributeSet).attributes;
                int n2 = objectArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.addAttribute(objectArray[n3], objectArray[n3 + 1]);
                    n3 += 2;
                }
            } else {
                Enumeration enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    this.addAttribute(object, attributeSet.getAttribute(object));
                }
            }
        }

        public void initialize(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                this.initialize(((SmallAttributeSet)attributeSet).attributes);
            } else {
                this.keys.removeAllElements();
                this.data.removeAllElements();
                Enumeration enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    this.addAttribute(object, attributeSet.getAttribute(object));
                }
            }
        }

        public void removeAttributes(AttributeSet attributeSet) {
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = attributeSet.getAttribute(object);
                this.removeSearchAttribute(object, object2);
            }
        }

        KeyBuilder(StyleContext styleContext) {
            this.this$0 = styleContext;
            this.keys = new Vector();
            this.data = new Vector();
        }

        public void addAttribute(Object object, Object object2) {
            this.keys.addElement(object);
            this.data.addElement(object2);
        }

        private void removeSearchAttribute(Object object, Object object2) {
            int n2 = this.keys.size();
            int n3 = 0;
            while (n3 < n2) {
                if (this.keys.elementAt(n3).equals(object)) {
                    if (this.data.elementAt(n3).equals(object2)) {
                        this.keys.removeElementAt(n3);
                        this.data.removeElementAt(n3);
                    }
                    return;
                }
                ++n3;
            }
        }
    }

    class KeyEnumeration
    implements Enumeration {
        Object[] attr;
        int i;
        private final StyleContext this$0;

        public boolean hasMoreElements() {
            return this.i < this.attr.length;
        }

        public Object nextElement() {
            if (this.i < this.attr.length) {
                Object object = this.attr[this.i];
                this.i += 2;
                return object;
            }
            throw new NoSuchElementException();
        }

        KeyEnumeration(StyleContext styleContext, Object[] objectArray) {
            this.this$0 = styleContext;
            this.attr = objectArray;
            this.i = 0;
        }
    }

    public class NamedStyle
    implements Style,
    Serializable {
        protected EventListenerList listenerList;
        protected transient ChangeEvent changeEvent;
        private transient AttributeSet attributes;
        private final StyleContext this$0;

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        protected void fireStateChanged() {
            Object[] objectArray = this.listenerList.getListenerList();
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$javax$swing$event$ChangeListener == null ? StyleContext.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((ChangeListener)objectArray[n2 + 1]).stateChanged(this.changeEvent);
                }
                n2 -= 2;
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.attributes = SimpleAttributeSet.EMPTY;
            StyleContext.readAttributeSet(objectInputStream, this);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            StyleContext.writeAttributeSet(objectOutputStream, this.attributes);
        }

        public void removeAttribute(Object object) {
            StyleContext styleContext = this.this$0;
            this.attributes = styleContext.removeAttribute(this.attributes, object);
            this.fireStateChanged();
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public String getName() {
            if (this.isDefined(StyleConstants.NameAttribute)) {
                return this.getAttribute(StyleConstants.NameAttribute).toString();
            }
            return null;
        }

        public String toString() {
            return "NamedStyle:" + this.getName() + " " + this.attributes;
        }

        public void setName(String string) {
            if (string != null) {
                this.addAttribute(StyleConstants.NameAttribute, string);
            }
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public void removeAttributes(Enumeration enumeration) {
            StyleContext styleContext = this.this$0;
            this.attributes = styleContext.removeAttributes(this.attributes, enumeration);
            this.fireStateChanged();
        }

        public ChangeListener[] getChangeListeners() {
            return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = StyleContext.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = StyleContext.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = StyleContext.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public AttributeSet copyAttributes() {
            NamedStyle namedStyle = new NamedStyle(this.this$0);
            namedStyle.attributes = this.attributes.copyAttributes();
            return namedStyle;
        }

        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        public void addAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = this.this$0;
            this.attributes = styleContext.addAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public void removeAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = this.this$0;
            this.attributes = attributeSet == this ? styleContext.getEmptySet() : styleContext.removeAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public void setResolveParent(AttributeSet attributeSet) {
            if (attributeSet != null) {
                this.addAttribute(StyleConstants.ResolveAttribute, attributeSet);
            } else {
                this.removeAttribute(StyleConstants.ResolveAttribute);
            }
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public NamedStyle(StyleContext styleContext) {
            this.this$0 = styleContext;
            this.listenerList = new EventListenerList();
            this.changeEvent = null;
            this.attributes = styleContext.getEmptySet();
        }

        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        public void addAttribute(Object object, Object object2) {
            StyleContext styleContext = this.this$0;
            this.attributes = styleContext.addAttribute(this.attributes, object, object2);
            this.fireStateChanged();
        }

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public EventListener[] getListeners(Class clazz) {
            return this.listenerList.getListeners(clazz);
        }

        public NamedStyle(StyleContext styleContext, Style style) {
            this(styleContext, null, style);
        }

        public NamedStyle(StyleContext styleContext, String string, Style style) {
            this.this$0 = styleContext;
            this.listenerList = new EventListenerList();
            this.changeEvent = null;
            this.attributes = styleContext.getEmptySet();
            if (string != null) {
                this.setName(string);
            }
            if (style != null) {
                this.setResolveParent(style);
            }
        }
    }

    public class SmallAttributeSet
    implements AttributeSet {
        Object[] attributes;
        int nrefs;
        AttributeSet resolveParent;
        private final StyleContext this$0;

        public int getAttributeCount() {
            return this.attributes.length / 2;
        }

        public int hashCode() {
            int n2 = 0;
            Object[] objectArray = this.attributes;
            int n3 = 1;
            while (n3 < objectArray.length) {
                n2 ^= objectArray[n3].hashCode();
                n3 += 2;
            }
            return n2;
        }

        private void updateResolveParent() {
            this.resolveParent = null;
            Object[] objectArray = this.attributes;
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] == StyleConstants.ResolveAttribute) {
                    this.resolveParent = (AttributeSet)objectArray[n2 + 1];
                    break;
                }
                n2 += 2;
            }
        }

        public Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof AttributeSet) {
                AttributeSet attributeSet = (AttributeSet)object;
                return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
            }
            return false;
        }

        public boolean isDefined(Object object) {
            Object[] objectArray = this.attributes;
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (object.equals(objectArray[n3])) {
                    return true;
                }
                n3 += 2;
            }
            return false;
        }

        public String toString() {
            String string = "{";
            Object[] objectArray = this.attributes;
            int n2 = 0;
            while (n2 < objectArray.length) {
                string = objectArray[n2 + 1] instanceof AttributeSet ? string + objectArray[n2] + "=" + "AttributeSet" + "," : string + objectArray[n2] + "=" + objectArray[n2 + 1] + ",";
                n2 += 2;
            }
            string = string + "nrefs=" + this.nrefs + "}";
            return string;
        }

        public Enumeration getAttributeNames() {
            return new KeyEnumeration(this.this$0, this.attributes);
        }

        public AttributeSet copyAttributes() {
            return this;
        }

        public AttributeSet getResolveParent() {
            return this.resolveParent;
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            boolean bl2 = true;
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (bl2 && enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                bl2 = attributeSet.getAttribute(object).equals(this.getAttribute(object));
            }
            return bl2;
        }

        public boolean isEqual(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                return attributeSet == this;
            }
            return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
        }

        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            Object object2 = this.getLocalAttribute(object);
            if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
                object2 = attributeSet.getAttribute(object);
            }
            return object2;
        }

        Object getLocalAttribute(Object object) {
            if (object == StyleConstants.ResolveAttribute) {
                return this.resolveParent;
            }
            Object[] objectArray = this.attributes;
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (object.equals(objectArray[n2])) {
                    return objectArray[n2 + 1];
                }
                n2 += 2;
            }
            return null;
        }

        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        public SmallAttributeSet(StyleContext styleContext, Object[] objectArray) {
            this.this$0 = styleContext;
            this.attributes = objectArray;
            this.updateResolveParent();
        }

        public SmallAttributeSet(StyleContext styleContext, AttributeSet attributeSet) {
            this.this$0 = styleContext;
            int n2 = attributeSet.getAttributeCount();
            Object[] objectArray = new Object[2 * n2];
            Enumeration enumeration = attributeSet.getAttributeNames();
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                objectArray[n3] = enumeration.nextElement();
                objectArray[n3 + 1] = attributeSet.getAttribute(objectArray[n3]);
                n3 += 2;
            }
            this.attributes = objectArray;
            this.updateResolveParent();
        }
    }
}

