/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboPopup
extends JPopupMenu
implements ComboPopup {
    static final ListModel EmptyListModel = new ListModel(){

        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n2) {
            return null;
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    };
    protected JComboBox comboBox;
    protected JList list;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting = false;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ListDataListener listDataListener;
    protected ItemListener itemListener;
    protected Timer autoscrollTimer;
    protected boolean hasEntered = false;
    protected boolean isAutoScrolling = false;
    protected int scrollDirection = 0;
    protected static final int SCROLL_UP = 0;
    protected static final int SCROLL_DOWN = 1;

    protected void autoScrollDown() {
        int n2;
        int n3 = this.list.getSelectedIndex();
        if (n3 < (n2 = this.list.getModel().getSize() - 1)) {
            this.list.setSelectedIndex(n3 + 1);
            this.list.ensureIndexIsVisible(n3 + 1);
        }
    }

    protected void autoScrollUp() {
        int n2 = this.list.getSelectedIndex();
        if (n2 > 0) {
            this.list.setSelectedIndex(n2 - 1);
            this.list.ensureIndexIsVisible(n2 - 1);
        }
    }

    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setForeground(this.comboBox.getForeground());
        this.list.setBackground(this.comboBox.getBackground());
        this.list.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
        this.list.setBorder(null);
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.setListSelection(this.comboBox.getSelectedIndex());
        this.installListListeners();
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    protected void configureScroller() {
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setBorder(null);
    }

    protected void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        this.comboBox.firePopupMenuCanceled();
    }

    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        this.comboBox.firePopupMenuWillBecomeInvisible();
    }

    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
        this.comboBox.firePopupMenuWillBecomeVisible();
    }

    public void hide() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        int n2 = 0;
        while (n2 < menuElementArray.length) {
            if (menuElementArray[n2] == this) {
                menuSelectionManager.clearSelectedPath();
                break;
            }
            ++n2;
        }
        if (menuElementArray.length > 0) {
            this.comboBox.repaint();
        }
    }

    protected void installComboBoxListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.itemListener = this.createItemListener()) != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        this.installComboBoxModelListeners(this.comboBox.getModel());
    }

    protected void installKeyboardActions() {
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        if (this.listMouseListener != null) {
            this.list.addMouseListener(this.listMouseListener);
        }
        if ((this.listMouseMotionListener = this.createListMouseMotionListener()) != null) {
            this.list.addMouseMotionListener(this.listMouseMotionListener);
        }
        if ((this.listSelectionListener = this.createListSelectionListener()) != null) {
            this.list.addListSelectionListener(this.listSelectionListener);
        }
    }

    public void show() {
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point point = this.getPopupLocation();
        this.show(this.comboBox, point.x, point.y);
    }

    protected void stopAutoScrolling() {
        this.isAutoScrolling = false;
        if (this.autoscrollTimer != null) {
            this.autoscrollTimer.stop();
            this.autoscrollTimer = null;
        }
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected void uninstallKeyboardActions() {
    }

    void uninstallListListeners() {
        if (this.listMouseListener != null) {
            this.list.removeMouseListener(this.listMouseListener);
            this.listMouseListener = null;
        }
        if (this.listMouseMotionListener != null) {
            this.list.removeMouseMotionListener(this.listMouseMotionListener);
            this.listMouseMotionListener = null;
        }
        if (this.listSelectionListener != null) {
            this.list.removeListSelectionListener(this.listSelectionListener);
            this.listSelectionListener = null;
        }
    }

    public void uninstallingUI() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallKeyboardActions();
        this.uninstallListListeners();
        this.list.setModel(EmptyListModel);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected int getPopupHeightForRowCount(int n2) {
        int n3 = Math.min(n2, this.comboBox.getItemCount());
        int n4 = 0;
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        Object object = null;
        int n5 = 0;
        while (n5 < n3) {
            object = this.list.getModel().getElementAt(n5);
            Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n5, false, false);
            n4 += component.getPreferredSize().height;
            ++n5;
        }
        return n4 == 0 ? 100 : n4;
    }

    private void setListSelection(int n2) {
        if (n2 == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n2);
            this.list.ensureIndexIsVisible(n2);
        }
    }

    protected void startAutoScrolling(int n2) {
        if (this.isAutoScrolling) {
            this.autoscrollTimer.stop();
        }
        this.isAutoScrolling = true;
        if (n2 == 0) {
            this.scrollDirection = 0;
            Point point = SwingUtilities.convertPoint(this.scroller, new Point(1, 1), this.list);
            int n3 = this.list.locationToIndex(point);
            this.list.setSelectedIndex(n3);
            ActionListener actionListener = new ActionListener(this){
                private final BasicComboPopup this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.autoScrollUp();
                }
                {
                    this.this$0 = basicComboPopup;
                }
            };
            this.autoscrollTimer = new Timer(100, actionListener);
        } else if (n2 == 1) {
            this.scrollDirection = 1;
            Dimension dimension = this.scroller.getSize();
            Point point = SwingUtilities.convertPoint(this.scroller, new Point(1, dimension.height - 1 - 2), this.list);
            int n4 = this.list.locationToIndex(point);
            this.list.setSelectedIndex(n4);
            ActionListener actionListener = new ActionListener(this){
                private final BasicComboPopup this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.autoScrollDown();
                }
                {
                    this.this$0 = basicComboPopup;
                }
            };
            this.autoscrollTimer = new Timer(100, actionListener);
        }
        this.autoscrollTimer.start();
    }

    private Point getPopupLocation() {
        Dimension dimension = this.comboBox.getSize();
        Insets insets = this.getInsets();
        dimension.setSize(dimension.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        Dimension dimension2 = rectangle.getSize();
        Point point = rectangle.getLocation();
        this.scroller.setMaximumSize(dimension2);
        this.scroller.setPreferredSize(dimension2);
        this.scroller.setMinimumSize(dimension2);
        this.list.revalidate();
        return point;
    }

    protected Rectangle computePopupBounds(int n2, int n3, int n4, int n5) {
        Rectangle rectangle;
        Cloneable cloneable;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.comboBox.getGraphicsConfiguration();
        Point point = new Point();
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        if (graphicsConfiguration != null) {
            cloneable = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
            rectangle.width -= cloneable.left + cloneable.right;
            rectangle.height -= cloneable.top + cloneable.bottom;
            rectangle.x += point.x + cloneable.left;
            rectangle.y += point.y + cloneable.top;
        } else {
            rectangle = new Rectangle(point, toolkit.getScreenSize());
        }
        cloneable = new Rectangle(n2, n3, n4, n5);
        if (n3 + n5 > rectangle.y + rectangle.height && n5 < rectangle.height) {
            ((Rectangle)cloneable).y = -((Rectangle)cloneable).height;
        }
        return cloneable;
    }

    protected ItemListener createItemListener() {
        return new ItemHandler(this);
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    public KeyListener getKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = this.createKeyListener();
        }
        return this.keyListener;
    }

    protected void delegateFocus(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            Component component = this.comboBox.getEditor().getEditorComponent();
            if (!(component instanceof JComponent) || ((JComponent)component).isRequestFocusEnabled()) {
                component.requestFocus();
            }
        } else if (this.comboBox.isRequestFocusEnabled()) {
            this.comboBox.requestFocus();
        }
    }

    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl2) {
        Point point = mouseEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int n2 = this.list.locationToIndex(point);
        if (n2 == -1) {
            n2 = point.y < 0 ? 0 : this.comboBox.getModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != n2) {
            this.list.setSelectedIndex(n2);
            if (bl2) {
                this.list.ensureIndexIsVisible(n2);
            }
        }
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler(this);
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler(this);
    }

    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = this.createMouseListener();
        }
        return this.mouseListener;
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler(this);
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler(this);
    }

    public MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = this.createMouseMotionListener();
        }
        return this.mouseMotionListener;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected void installComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        if (comboBoxModel != null && (this.listDataListener = this.createListDataListener()) != null) {
            comboBoxModel.addListDataListener(this.listDataListener);
        }
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        if (comboBoxModel != null && this.listDataListener != null) {
            comboBoxModel.removeListDataListener(this.listDataListener);
        }
    }

    public BasicComboPopup(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.installComboBoxListeners();
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.list = this.createList();
        this.configureList();
        this.scroller = this.createScroller();
        this.configureScroller();
        this.configurePopup();
        this.installKeyboardActions();
    }

    protected JList createList() {
        return new JList(this, this.comboBox.getModel()){
            private final BasicComboPopup this$0;

            public void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isControlDown()) {
                    mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ 2, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                }
                super.processMouseEvent(mouseEvent);
            }
            {
                this.this$0 = basicComboPopup;
                super(listModel);
            }
        };
    }

    public JList getList() {
        return this.list;
    }

    protected JScrollPane createScroller() {
        return new JScrollPane(this.list, 20, 31);
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected ListSelectionListener createListSelectionListener() {
        return null;
    }

    static void access$000(BasicComboPopup basicComboPopup, int n2) {
        basicComboPopup.setListSelection(n2);
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.list);
        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        return mouseEvent2;
    }

    public class InvocationKeyHandler
    extends KeyAdapter {
        private final BasicComboPopup this$0;

        public void keyReleased(KeyEvent keyEvent) {
        }

        public InvocationKeyHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        private final BasicComboPopup this$0;

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !this.this$0.comboBox.isEnabled()) {
                return;
            }
            if (this.this$0.comboBox.isEditable()) {
                Component component = this.this$0.comboBox.getEditor().getEditorComponent();
                if (!(component instanceof JComponent) || ((JComponent)component).isRequestFocusEnabled()) {
                    component.requestFocus();
                }
            } else if (this.this$0.comboBox.isRequestFocusEnabled()) {
                this.this$0.comboBox.requestFocus();
            }
            this.this$0.togglePopup();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = this.this$0.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                this.this$0.list.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point)) {
                    this.this$0.comboBox.setSelectedIndex(this.this$0.list.getSelectedIndex());
                }
                this.this$0.comboBox.setPopupVisible(false);
            }
            this.this$0.hasEntered = false;
            this.this$0.stopAutoScrolling();
        }

        protected InvocationMouseHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }
    }

    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        private final BasicComboPopup this$0;

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0.isVisible()) {
                MouseEvent mouseEvent2 = this.this$0.convertMouseEvent(mouseEvent);
                Rectangle rectangle = new Rectangle();
                this.this$0.list.computeVisibleRect(rectangle);
                if (mouseEvent2.getPoint().y >= rectangle.y && mouseEvent2.getPoint().y <= rectangle.y + rectangle.height - 1) {
                    Point point;
                    this.this$0.hasEntered = true;
                    if (this.this$0.isAutoScrolling) {
                        this.this$0.stopAutoScrolling();
                    }
                    if (rectangle.contains(point = mouseEvent2.getPoint())) {
                        this.this$0.updateListBoxSelectionForEvent(mouseEvent2, false);
                    }
                } else if (this.this$0.hasEntered) {
                    int n2;
                    int n3 = n2 = mouseEvent2.getPoint().y < rectangle.y ? 0 : 1;
                    if (this.this$0.isAutoScrolling && this.this$0.scrollDirection != n2) {
                        this.this$0.stopAutoScrolling();
                        this.this$0.startAutoScrolling(n2);
                    } else if (!this.this$0.isAutoScrolling) {
                        this.this$0.startAutoScrolling(n2);
                    }
                } else if (mouseEvent.getPoint().y < 0) {
                    this.this$0.hasEntered = true;
                    this.this$0.startAutoScrolling(0);
                }
            }
        }

        protected InvocationMouseMotionHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }
    }

    protected class ItemHandler
    implements ItemListener {
        private final BasicComboPopup this$0;

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                BasicComboPopup.access$000(this.this$0, jComboBox.getSelectedIndex());
            }
        }

        protected ItemHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private final BasicComboPopup this$0;

        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public ListDataHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        private final BasicComboPopup this$0;

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.this$0.comboBox.setSelectedIndex(this.this$0.list.getSelectedIndex());
            this.this$0.comboBox.setPopupVisible(false);
            if (this.this$0.comboBox.isEditable() && this.this$0.comboBox.getEditor() != null) {
                this.this$0.comboBox.configureEditor(this.this$0.comboBox.getEditor(), this.this$0.comboBox.getSelectedItem());
            }
        }

        protected ListMouseHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        private final BasicComboPopup this$0;

        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            this.this$0.list.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                this.this$0.updateListBoxSelectionForEvent(mouseEvent, false);
            }
        }

        protected ListMouseMotionHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        private final BasicComboPopup this$0;

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }

        protected ListSelectionHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private final BasicComboPopup this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getOldValue();
                ComboBoxModel comboBoxModel2 = (ComboBoxModel)propertyChangeEvent.getNewValue();
                this.this$0.uninstallComboBoxModelListeners(comboBoxModel);
                this.this$0.installComboBoxModelListeners(comboBoxModel2);
                this.this$0.list.setModel(comboBoxModel2);
                if (this.this$0.isVisible()) {
                    this.this$0.hide();
                }
            } else if (string.equals("renderer")) {
                this.this$0.list.setCellRenderer(jComboBox.getRenderer());
                if (this.this$0.isVisible()) {
                    this.this$0.hide();
                }
            } else if (string.equals("componentOrientation")) {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                JList jList = this.this$0.getList();
                if (jList != null && jList.getComponentOrientation() != componentOrientation) {
                    jList.setComponentOrientation(componentOrientation);
                }
                if (this.this$0.scroller != null && this.this$0.scroller.getComponentOrientation() != componentOrientation) {
                    this.this$0.scroller.setComponentOrientation(componentOrientation);
                }
                if (componentOrientation != this.this$0.getComponentOrientation()) {
                    this.this$0.setComponentOrientation(componentOrientation);
                }
            } else if (string.equals("lightWeightPopupEnabled")) {
                this.this$0.setLightWeightPopupEnabled(jComboBox.isLightWeightPopupEnabled());
            }
        }

        protected PropertyChangeHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }
    }
}

