/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractColorChooserPanel
extends JPanel {
    private JColorChooser chooser;
    private ChangeListener colorListener;
    private boolean dirty = true;

    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    public int getMnemonic() {
        return 0;
    }

    protected abstract void buildChooser();

    public abstract void updateChooser();

    protected Color getColorFromModel() {
        return this.getColorSelectionModel().getSelectedColor();
    }

    public void paint(Graphics graphics) {
        if (this.dirty) {
            this.updateChooser();
            this.dirty = false;
        }
        super.paint(graphics);
    }

    static int getInt(Object object, int n2) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return n2;
    }

    public abstract String getDisplayName();

    public abstract Icon getLargeDisplayIcon();

    public abstract Icon getSmallDisplayIcon();

    public void installChooserPanel(JColorChooser jColorChooser) {
        if (this.chooser != null) {
            throw new RuntimeException("This chooser panel is already installed");
        }
        this.chooser = jColorChooser;
        this.buildChooser();
        this.updateChooser();
        this.colorListener = new ModelListener(this);
        this.getColorSelectionModel().addChangeListener(this.colorListener);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        this.getColorSelectionModel().removeChangeListener(this.colorListener);
        this.chooser = null;
    }

    static boolean access$002(AbstractColorChooserPanel abstractColorChooserPanel, boolean bl2) {
        abstractColorChooserPanel.dirty = bl2;
        return abstractColorChooserPanel.dirty;
    }

    public ColorSelectionModel getColorSelectionModel() {
        return this.chooser.getSelectionModel();
    }

    class ModelListener
    implements ChangeListener,
    Serializable {
        private final AbstractColorChooserPanel this$0;

        ModelListener(AbstractColorChooserPanel abstractColorChooserPanel) {
            this.this$0 = abstractColorChooserPanel;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.this$0.isShowing()) {
                this.this$0.updateChooser();
                AbstractColorChooserPanel.access$002(this.this$0, false);
            } else {
                AbstractColorChooserPanel.access$002(this.this$0, true);
            }
        }
    }
}

