/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class OverlayLayout
implements LayoutManager2,
Serializable {
    private Container target;
    private SizeRequirements[] xChildren;
    private SizeRequirements[] yChildren;
    private SizeRequirements xTotal;
    private SizeRequirements yTotal;

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            int n2 = this.target.getComponentCount();
            this.xChildren = new SizeRequirements[n2];
            this.yChildren = new SizeRequirements[n2];
            int n3 = 0;
            while (n3 < n2) {
                Component component = this.target.getComponent(n3);
                Dimension dimension = component.getMinimumSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = component.getMaximumSize();
                this.xChildren[n3] = new SizeRequirements(dimension.width, dimension2.width, dimension3.width, component.getAlignmentX());
                this.yChildren[n3] = new SizeRequirements(dimension.height, dimension2.height, dimension3.height, component.getAlignmentY());
                ++n3;
            }
            this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
            this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
        }
    }

    public void removeLayoutComponent(Component component) {
        this.invalidateLayout(component.getParent());
    }

    public float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    public float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    public OverlayLayout(Container container) {
        this.target = container;
    }

    void checkContainer(Container container) {
        if (this.target != container) {
            throw new AWTError("OverlayLayout can't be shared");
        }
    }

    public void invalidateLayout(Container container) {
        this.checkContainer(container);
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    public void layoutContainer(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        int n2 = container.getComponentCount();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        SizeRequirements.calculateAlignedPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2);
        SizeRequirements.calculateAlignedPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
        int n3 = 0;
        while (n3 < n2) {
            Component component = container.getComponent(n3);
            component.setBounds(insets.left + nArray[n3], insets.top + nArray3[n3], nArray2[n3], nArray4[n3]);
            ++n3;
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.invalidateLayout(component.getParent());
    }

    public Dimension maximumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void addLayoutComponent(Component component, Object object) {
        this.invalidateLayout(component.getParent());
    }
}

