/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SpinnerUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NumberFormatter;

public class JSpinner
extends JComponent {
    private static final String uiClassID = "SpinnerUI";
    private static final Action DISABLED_ACTION = new DisabledAction(null);
    private transient SpinnerModel model;
    private JComponent editor;
    private ChangeListener modelListener;
    private transient ChangeEvent changeEvent;
    private boolean editorExplicitlySet = false;
    static Class class$javax$swing$event$ChangeListener;

    public JSpinner() {
        this(new SpinnerNumberModel());
    }

    public void commitEdit() throws ParseException {
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof DefaultEditor) {
            ((DefaultEditor)jComponent).commitEdit();
        }
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$ChangeListener == null ? JSpinner.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n2 + 1]).stateChanged(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    public void updateUI() {
        this.setUI((SpinnerUI)UIManager.getUI(this));
        this.invalidate();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Map map = (Map)objectInputStream.readObject();
        this.model = (SpinnerModel)map.get("model");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        HashMap hashMap = new HashMap(1);
        SpinnerModel spinnerModel = this.getModel();
        if (spinnerModel instanceof Serializable) {
            hashMap.put("model", spinnerModel);
        }
        objectOutputStream.writeObject(hashMap);
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public Object getNextValue() {
        return this.getModel().getNextValue();
    }

    public Object getPreviousValue() {
        return this.getModel().getPreviousValue();
    }

    public Object getValue() {
        return this.getModel().getValue();
    }

    public void setValue(Object object) {
        this.getModel().setValue(object);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    static Action access$200() {
        return DISABLED_ACTION;
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public void setEditor(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("null editor");
        }
        if (!jComponent.equals(this.editor)) {
            JComponent jComponent2 = this.editor;
            this.editor = jComponent;
            if (jComponent2 instanceof DefaultEditor) {
                ((DefaultEditor)jComponent2).dismiss(this);
            }
            this.editorExplicitlySet = true;
            this.firePropertyChange("editor", jComponent2, jComponent);
            this.revalidate();
            this.repaint();
        }
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public JSpinner(SpinnerModel spinnerModel) {
        this.model = spinnerModel;
        this.editor = this.createEditor(spinnerModel);
        this.updateUI();
    }

    public void setModel(SpinnerModel spinnerModel) {
        if (spinnerModel == null) {
            throw new IllegalArgumentException("null model");
        }
        if (!spinnerModel.equals(this.model)) {
            SpinnerModel spinnerModel2 = this.model;
            this.model = spinnerModel;
            if (this.modelListener != null) {
                this.model.addChangeListener(this.modelListener);
            }
            this.firePropertyChange("model", spinnerModel2, spinnerModel);
            if (!this.editorExplicitlySet) {
                this.setEditor(this.createEditor(spinnerModel));
                this.editorExplicitlySet = false;
            }
            this.repaint();
            this.revalidate();
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JSpinner.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.modelListener == null) {
            this.modelListener = new ModelListener(this, null);
            this.getModel().addChangeListener(this.modelListener);
        }
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JSpinner.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JSpinner.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.ui;
    }

    public void setUI(SpinnerUI spinnerUI) {
        super.setUI(spinnerUI);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected JComponent createEditor(SpinnerModel spinnerModel) {
        if (spinnerModel instanceof SpinnerDateModel) {
            return new DateEditor(this);
        }
        if (spinnerModel instanceof SpinnerListModel) {
            return new ListEditor(this);
        }
        if (spinnerModel instanceof SpinnerNumberModel) {
            return new NumberEditor(this);
        }
        return new DefaultEditor(this);
    }

    class 1 {
    }

    public static class DateEditor
    extends DefaultEditor {
        public SimpleDateFormat getFormat() {
            return (SimpleDateFormat)((DateFormatter)this.getTextField().getFormatter()).getFormat();
        }

        public DateEditor(JSpinner jSpinner) {
            this(jSpinner, new SimpleDateFormat());
        }

        public SpinnerDateModel getModel() {
            return (SpinnerDateModel)this.getSpinner().getModel();
        }

        public DateEditor(JSpinner jSpinner, String string) {
            this(jSpinner, new SimpleDateFormat(string));
        }

        private DateEditor(JSpinner jSpinner, DateFormat dateFormat) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerDateModel)) {
                throw new IllegalArgumentException("model not a SpinnerDateModel");
            }
            SpinnerDateModel spinnerDateModel = (SpinnerDateModel)jSpinner.getModel();
            DateEditorFormatter dateEditorFormatter = new DateEditorFormatter(spinnerDateModel, dateFormat);
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(dateEditorFormatter);
            JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.setEditable(true);
            jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
            try {
                String string = dateEditorFormatter.valueToString(spinnerDateModel.getStart());
                String string2 = dateEditorFormatter.valueToString(spinnerDateModel.getEnd());
                jFormattedTextField.setColumns(Math.max(string.length(), string2.length()));
            }
            catch (ParseException parseException) {}
        }
    }

    private static class DateEditorFormatter
    extends DateFormatter {
        private final SpinnerDateModel model;

        public Comparable getMaximum() {
            return this.model.getEnd();
        }

        public Comparable getMinimum() {
            return this.model.getStart();
        }

        public void setMaximum(Comparable comparable) {
            this.model.setEnd(comparable);
        }

        public void setMinimum(Comparable comparable) {
            this.model.setStart(comparable);
        }

        DateEditorFormatter(SpinnerDateModel spinnerDateModel, DateFormat dateFormat) {
            super(dateFormat);
            this.model = spinnerDateModel;
        }
    }

    public static class DefaultEditor
    extends JPanel
    implements ChangeListener,
    PropertyChangeListener,
    LayoutManager {
        public void commitEdit() throws ParseException {
            JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.commitEdit();
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            if (container.getComponentCount() > 0) {
                Insets insets = container.getInsets();
                int n2 = container.getWidth() - (insets.left + insets.right);
                int n3 = container.getHeight() - (insets.top + insets.bottom);
                this.getComponent(0).setBounds(insets.left, insets.top, n2, n3);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block5: {
                JSpinner jSpinner = this.getSpinner();
                if (jSpinner == null) {
                    return;
                }
                Object object = propertyChangeEvent.getSource();
                String string = propertyChangeEvent.getPropertyName();
                if (!(object instanceof JFormattedTextField) || !"value".equals(string)) break block5;
                Object object2 = jSpinner.getValue();
                try {
                    jSpinner.setValue(this.getTextField().getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        ((JFormattedTextField)object).setValue(object2);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {}
                }
            }
        }

        public JFormattedTextField getTextField() {
            return (JFormattedTextField)this.getComponent(0);
        }

        public JSpinner getSpinner() {
            Container container = this;
            while (container != null) {
                if (container instanceof JSpinner) {
                    return (JSpinner)container;
                }
                container = container.getParent();
            }
            return null;
        }

        public DefaultEditor(JSpinner jSpinner) {
            super(null);
            JFormattedTextField jFormattedTextField = new JFormattedTextField();
            jFormattedTextField.setValue(jSpinner.getValue());
            jFormattedTextField.addPropertyChangeListener(this);
            jFormattedTextField.setEditable(false);
            this.add(jFormattedTextField);
            this.setLayout(this);
            jSpinner.addChangeListener(this);
            ActionMap actionMap = jFormattedTextField.getActionMap();
            if (actionMap != null) {
                actionMap.put("increment", JSpinner.access$200());
                actionMap.put("decrement", JSpinner.access$200());
            }
        }

        public void dismiss(JSpinner jSpinner) {
            jSpinner.removeChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            this.getTextField().setValue(jSpinner.getValue());
        }

        public void addLayoutComponent(String string, Component component) {
        }

        private Dimension insetSize(Container container) {
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            return new Dimension(n2, n3);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = this.insetSize(container);
            if (container.getComponentCount() > 0) {
                Dimension dimension2 = this.getComponent(0).getMinimumSize();
                dimension.width += dimension2.width;
                dimension.height += dimension2.height;
            }
            return dimension;
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.insetSize(container);
            if (container.getComponentCount() > 0) {
                Dimension dimension2 = this.getComponent(0).getPreferredSize();
                dimension.width += dimension2.width;
                dimension.height += dimension2.height;
            }
            return dimension;
        }
    }

    private static class DisabledAction
    implements Action {
        private DisabledAction() {
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean bl2) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        DisabledAction(1 var1_1) {
            this();
        }

        public Object getValue(String string) {
            return null;
        }

        public void putValue(String string, Object object) {
        }
    }

    public static class ListEditor
    extends DefaultEditor {
        public ListEditor(JSpinner jSpinner) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerListModel)) {
                throw new IllegalArgumentException("model not a SpinnerListModel");
            }
            this.getTextField().setEditable(true);
            this.getTextField().setFormatterFactory(new DefaultFormatterFactory(new ListFormatter(this, null)));
        }

        public SpinnerListModel getModel() {
            return (SpinnerListModel)this.getSpinner().getModel();
        }

        private class ListFormatter
        extends JFormattedTextField.AbstractFormatter {
            private DocumentFilter filter;
            private final ListEditor this$0;

            private ListFormatter(ListEditor listEditor) {
                this.this$0 = listEditor;
            }

            protected DocumentFilter getDocumentFilter() {
                if (this.filter == null) {
                    this.filter = new Filter(this, null);
                }
                return this.filter;
            }

            public Object stringToValue(String string) throws ParseException {
                return string;
            }

            public String valueToString(Object object) throws ParseException {
                if (object == null) {
                    return "";
                }
                return object.toString();
            }

            ListFormatter(ListEditor listEditor, 1 var2_2) {
                this(listEditor);
            }

            static ListEditor access$500(ListFormatter listFormatter) {
                return listFormatter.this$0;
            }

            private class Filter
            extends DocumentFilter {
                private final ListFormatter this$1;

                private Filter(ListFormatter listFormatter) {
                    this.this$1 = listFormatter;
                }

                Filter(ListFormatter listFormatter, 1 var2_2) {
                    this(listFormatter);
                }

                public void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (string != null && n2 + n3 == filterBypass.getDocument().getLength()) {
                        String string2;
                        Object object = ListFormatter.access$500(this.this$1).getModel().findNextMatch(filterBypass.getDocument().getText(0, n2) + string);
                        String string3 = string2 = object != null ? object.toString() : null;
                        if (string2 != null) {
                            filterBypass.remove(0, n2 + n3);
                            filterBypass.insertString(0, string2, null);
                            this.this$1.getFormattedTextField().select(n2 + string.length(), string2.length());
                            return;
                        }
                    }
                    super.replace(filterBypass, n2, n3, string, attributeSet);
                }

                public void insertString(DocumentFilter.FilterBypass filterBypass, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    this.replace(filterBypass, n2, 0, string, attributeSet);
                }
            }
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private final JSpinner this$0;

        private ModelListener(JSpinner jSpinner) {
            this.this$0 = jSpinner;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.this$0.fireStateChanged();
        }

        ModelListener(JSpinner jSpinner, 1 var2_2) {
            this(jSpinner);
        }
    }

    public static class NumberEditor
    extends DefaultEditor {
        public DecimalFormat getFormat() {
            return (DecimalFormat)((NumberFormatter)this.getTextField().getFormatter()).getFormat();
        }

        public NumberEditor(JSpinner jSpinner) {
            this(jSpinner, new DecimalFormat());
        }

        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)this.getSpinner().getModel();
        }

        public NumberEditor(JSpinner jSpinner, String string) {
            this(jSpinner, new DecimalFormat(string));
        }

        private NumberEditor(JSpinner jSpinner, DecimalFormat decimalFormat) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerNumberModel)) {
                throw new IllegalArgumentException("model not a SpinnerNumberModel");
            }
            SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
            NumberEditorFormatter numberEditorFormatter = new NumberEditorFormatter(spinnerNumberModel, decimalFormat);
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(numberEditorFormatter);
            JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.setEditable(true);
            jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
            jFormattedTextField.setHorizontalAlignment(4);
            try {
                String string = numberEditorFormatter.valueToString(spinnerNumberModel.getMinimum());
                String string2 = numberEditorFormatter.valueToString(spinnerNumberModel.getMaximum());
                jFormattedTextField.setColumns(Math.max(string.length(), string2.length()));
            }
            catch (ParseException parseException) {}
        }
    }

    private static class NumberEditorFormatter
    extends NumberFormatter {
        private final SpinnerNumberModel model;

        public Comparable getMaximum() {
            return this.model.getMaximum();
        }

        public Comparable getMinimum() {
            return this.model.getMinimum();
        }

        public void setMaximum(Comparable comparable) {
            this.model.setMaximum(comparable);
        }

        public void setMinimum(Comparable comparable) {
            this.model.setMinimum(comparable);
        }

        NumberEditorFormatter(SpinnerNumberModel spinnerNumberModel, NumberFormat numberFormat) {
            super(numberFormat);
            this.model = spinnerNumberModel;
            this.setValueClass(spinnerNumberModel.getValue().getClass());
        }
    }
}

