/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuUI";
    private JPopupMenu popupMenu;
    private ChangeListener menuChangeListener = null;
    private MenuEvent menuEvent = null;
    private static Hashtable listenerRegistry = null;
    private int delay;
    private Point customMenuLocation = null;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    protected WinListener popupListener;
    static Class class$javax$swing$event$MenuListener;

    public int getDelay() {
        return this.delay;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public int getMenuComponentCount() {
        int n2 = 0;
        if (this.popupMenu != null) {
            n2 = this.popupMenu.getComponentCount();
        }
        return n2;
    }

    public JMenu() {
        this("");
    }

    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    private void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            JMenu jMenu = this;
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
            this.popupMenu.addPopupMenuListener(new PopupMenuListener(this){
                private final JMenu this$0;
                {
                    this.this$0 = jMenu;
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.this$0.fireMenuCanceled();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    protected void fireMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$MenuListener == null ? JMenu.class$("javax.swing.event.MenuListener") : class$javax$swing$event$MenuListener)) {
                if (objectArray[n2 + 1] == null) {
                    throw new Error(this.getText() + " has a NULL Listener!! " + n2);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n2 + 1]).menuCanceled(this.menuEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireMenuDeselected() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$MenuListener == null ? JMenu.class$("javax.swing.event.MenuListener") : class$javax$swing$event$MenuListener)) {
                if (objectArray[n2 + 1] == null) {
                    throw new Error(this.getText() + " has a NULL Listener!! " + n2);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n2 + 1]).menuDeselected(this.menuEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireMenuSelected() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$MenuListener == null ? JMenu.class$("javax.swing.event.MenuListener") : class$javax$swing$event$MenuListener)) {
                if (objectArray[n2 + 1] == null) {
                    throw new Error(this.getText() + " has a NULL Listener!! " + n2);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n2 + 1]).menuSelected(this.menuEvent);
            }
            n2 -= 2;
        }
    }

    void initFocusability() {
    }

    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public boolean isTearOff() {
        throw new Error("boolean isTearOff() {} not yet implemented");
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public void doClick(int n2) {
        MenuElement[] menuElementArray = this.buildMenuElementArray(this);
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
    }

    public void insertSeparator(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JPopupMenu.Separator(), n2);
    }

    public void remove(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n2 > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(n2);
        }
    }

    public void setDelay(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Delay must be a positive integer");
        }
        this.delay = n2;
    }

    public void setMenuLocation(int n2, int n3) {
        this.customMenuLocation = new Point(n2, n3);
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(n2, n3);
        }
    }

    public void menuSelectionChanged(boolean bl2) {
        this.setSelected(bl2);
    }

    public void setPopupMenuVisible(boolean bl2) {
        boolean bl3 = this.isPopupMenuVisible();
        if (bl2 != bl3 && (this.isEnabled() || !bl2)) {
            this.ensurePopupMenuCreated();
            if (bl2 && this.isShowing()) {
                Point point = this.getCustomMenuLocation();
                if (point == null) {
                    point = this.getPopupMenuOrigin();
                }
                this.getPopupMenu().show(this, point.x, point.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    public void setSelected(boolean bl2) {
        ButtonModel buttonModel = this.getModel();
        boolean bl3 = buttonModel.isSelected();
        if (this.accessibleContext != null && bl3 != bl2) {
            if (bl2) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        if (bl2 != buttonModel.isSelected()) {
            this.getModel().setSelected(bl2);
        }
    }

    public Component getComponent() {
        return this;
    }

    public Component[] getMenuComponents() {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponents();
        }
        return new Component[0];
    }

    public Component getMenuComponent(int n2) {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponent(n2);
        }
        return null;
    }

    public void remove(Component component) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(component);
        }
    }

    public boolean isMenuComponent(Component component) {
        JPopupMenu jPopupMenu;
        if (component == this) {
            return true;
        }
        if (component instanceof JPopupMenu && (jPopupMenu = (JPopupMenu)component) == this.getPopupMenu()) {
            return true;
        }
        int n2 = this.getMenuComponentCount();
        Component[] componentArray = this.getMenuComponents();
        int n3 = 0;
        while (n3 < n2) {
            JMenu jMenu;
            Component component2 = componentArray[n3];
            if (component2 == component) {
                return true;
            }
            if (component2 instanceof JMenu && (jMenu = (JMenu)component2).isMenuComponent(component)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        if (this.popupMenu != null) {
            int n2 = this.getMenuComponentCount();
            int n3 = 0;
            while (n3 < n2) {
                this.getMenuComponent(n3).applyComponentOrientation(componentOrientation);
                ++n3;
            }
            this.popupMenu.setComponentOrientation(componentOrientation);
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        if (this.popupMenu != null) {
            this.popupMenu.setComponentOrientation(componentOrientation);
        }
    }

    private Point getCustomMenuLocation() {
        return this.customMenuLocation;
    }

    protected Point getPopupMenuOrigin() {
        Object object;
        int n2 = 0;
        int n3 = 0;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Dimension dimension = this.getSize();
        Dimension dimension2 = jPopupMenu.getSize();
        if (dimension2.width == 0) {
            dimension2 = jPopupMenu.getPreferredSize();
        }
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Object object2 = this.getGraphicsConfiguration();
        Rectangle rectangle = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n4 = 0;
        while (n4 < graphicsDeviceArray.length) {
            if (graphicsDeviceArray[n4].getType() == 0 && ((GraphicsConfiguration)(object = graphicsDeviceArray[n4].getDefaultConfiguration())).getBounds().contains(point)) {
                object2 = object;
                break;
            }
            ++n4;
        }
        if (object2 != null) {
            rectangle = ((GraphicsConfiguration)object2).getBounds();
            object = toolkit.getScreenInsets((GraphicsConfiguration)object2);
            rectangle.width -= Math.abs(((Insets)object).left + ((Insets)object).right);
            rectangle.height -= Math.abs(((Insets)object).top + ((Insets)object).bottom);
            point.x -= Math.abs(((Insets)object).left);
            point.y -= Math.abs(((Insets)object).top);
        }
        if ((object = this.getParent()) instanceof JPopupMenu) {
            int n5 = UIManager.getInt("Menu.submenuPopupOffsetX");
            int n6 = UIManager.getInt("Menu.submenuPopupOffsetY");
            if (SwingUtilities.isLeftToRight(this)) {
                n2 = dimension.width + n5;
                if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                    n2 = 0 - n5 - dimension2.width;
                }
            } else {
                n2 = 0 - n5 - dimension2.width;
                if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n2 = dimension.width + n5;
                }
            }
            if (point.y + (n3 = n6) + dimension2.height >= rectangle.height + rectangle.y && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                n3 = dimension.height - n6 - dimension2.height;
            }
        } else {
            int n7 = UIManager.getInt("Menu.menuPopupOffsetX");
            int n8 = UIManager.getInt("Menu.menuPopupOffsetY");
            if (SwingUtilities.isLeftToRight(this)) {
                n2 = n7;
                if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                    n2 = dimension.width - n7 - dimension2.width;
                }
            } else {
                n2 = dimension.width - n7 - dimension2.width;
                if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n2 = n7;
                }
            }
            if (point.y + (n3 = dimension.height + n8) + dimension2.height >= rectangle.height && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                n3 = 0 - n8 - dimension2.height;
            }
        }
        return new Point(n2, n3);
    }

    private Point translateToPopupMenu(int n2, int n3) {
        int n4;
        int n5;
        if (this.getParent() instanceof JPopupMenu) {
            n5 = n2 - this.getSize().width;
            n4 = n3;
        } else {
            n5 = n2;
            n4 = n3 - this.getSize().height;
        }
        return new Point(n5, n4);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        return super.paramString();
    }

    public JMenu(String string) {
        super(string);
    }

    public void insert(String string, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(string), n2);
    }

    public JMenu(String string, boolean bl2) {
        this(string);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu(this);
        }
        return this.accessibleContext;
    }

    public JMenu(Action action) {
        this();
        this.setAction(action);
    }

    protected void configurePropertiesFromAction(Action action) {
        this.configurePropertiesFromAction(action, null);
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        super.setModel(buttonModel);
        if (buttonModel2 != null && this.menuChangeListener != null) {
            buttonModel2.removeChangeListener(this.menuChangeListener);
            this.menuChangeListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.menuChangeListener = this.createMenuChangeListener();
            buttonModel.addChangeListener(this.menuChangeListener);
        }
    }

    public JMenuItem getItem(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        Component component = this.getMenuComponent(n2);
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            return jMenuItem;
        }
        return null;
    }

    public void remove(JMenuItem jMenuItem) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(jMenuItem);
        }
    }

    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        MenuElement[] menuElementArray = new MenuElement[]{this.popupMenu};
        return menuElementArray;
    }

    private ChangeListener createMenuChangeListener() {
        return new MenuChangeListener(this);
    }

    public MenuListener[] getMenuListeners() {
        return (MenuListener[])this.listenerList.getListeners(class$javax$swing$event$MenuListener == null ? (class$javax$swing$event$MenuListener = JMenu.class$("javax.swing.event.MenuListener")) : class$javax$swing$event$MenuListener);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.listenerList.add(class$javax$swing$event$MenuListener == null ? (class$javax$swing$event$MenuListener = JMenu.class$("javax.swing.event.MenuListener")) : class$javax$swing$event$MenuListener, menuListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.listenerList.remove(class$javax$swing$event$MenuListener == null ? (class$javax$swing$event$MenuListener = JMenu.class$("javax.swing.event.MenuListener")) : class$javax$swing$event$MenuListener, menuListener);
    }

    public Component add(Component component) {
        AccessibleContext accessibleContext;
        if (component instanceof JComponent && (accessibleContext = ((JComponent)component).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component);
        return component;
    }

    public Component add(Component component, int n2) {
        AccessibleContext accessibleContext;
        if (component instanceof JComponent && (accessibleContext = ((JComponent)component).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component, n2);
        return component;
    }

    private Point translateToPopupMenu(Point point) {
        return this.translateToPopupMenu(point.x, point.y);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(this, jMenuItem);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new WinListener(this, jPopupMenu);
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add(jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem createActionComponent(Action action) {
        JMenuItem jMenuItem = new JMenuItem(this, (String)action.getValue("Name"), (Icon)action.getValue("SmallIcon")){
            private final JMenu this$0;

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = this.this$0.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
            {
                this.this$0 = jMenu;
                super(string, icon);
            }
        };
        jMenuItem.setHorizontalTextPosition(11);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jMenuItem.setHorizontalTextPosition(11);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        jMenuItem.setAction(action);
        this.popupMenu.insert(jMenuItem, n2);
        return jMenuItem;
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(jMenuItem);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(jMenuItem, n2);
        return jMenuItem;
    }

    private MenuElement[] buildMenuElementArray(JMenu jMenu) {
        Vector vector = new Vector();
        Component component = jMenu.getPopupMenu();
        while (true) {
            if (component instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = component;
                vector.insertElementAt(jPopupMenu, 0);
                component = jPopupMenu.getInvoker();
                continue;
            }
            if (component instanceof JMenu) {
                JMenu jMenu2 = (JMenu)component;
                vector.insertElementAt(jMenu2, 0);
                component = jMenu2.getParent();
                continue;
            }
            if (component instanceof JMenuBar) break;
        }
        JMenuBar jMenuBar = (JMenuBar)component;
        vector.insertElementAt(jMenuBar, 0);
        Object[] objectArray = new MenuElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static MenuElement[] access$000(JMenu jMenu, JMenu jMenu2) {
        return jMenu.buildMenuElementArray(jMenu2);
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        private final JMenu this$0;

        public int getAccessibleChildrenCount() {
            Component[] componentArray = this.this$0.getMenuComponents();
            int n2 = 0;
            int n3 = 0;
            while (n3 < componentArray.length) {
                if (componentArray[n3] instanceof Accessible) {
                    ++n2;
                }
                ++n3;
            }
            return n2;
        }

        public int getAccessibleSelectionCount() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n2 = 0;
                while (n2 < menuElementArray.length) {
                    if (menuElementArray[n2] == this.this$0 && n2 + 1 < menuElementArray.length) {
                        return 1;
                    }
                    ++n2;
                }
            }
            return 0;
        }

        public void clearAccessibleSelection() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n2 = 0;
                while (n2 < menuElementArray.length) {
                    if (menuElementArray[n2] == this.this$0) {
                        MenuElement[] menuElementArray2 = new MenuElement[n2 + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n2);
                        menuElementArray2[n2] = this.this$0.getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    }
                    ++n2;
                }
            }
        }

        public void selectAllAccessibleSelection() {
        }

        public void addAccessibleSelection(int n2) {
            if (n2 < 0 || n2 >= this.this$0.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = this.this$0.getItem(n2);
            if (jMenuItem != null) {
                if (jMenuItem instanceof JMenu) {
                    MenuElement[] menuElementArray = JMenu.access$000(this.this$0, (JMenu)jMenuItem);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                } else {
                    jMenuItem.doClick();
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
            }
        }

        public void removeAccessibleSelection(int n2) {
            if (n2 < 0 || n2 >= this.this$0.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = this.this$0.getItem(n2);
            if (jMenuItem != null && jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isSelected()) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                int n3 = 0;
                while (n3 < menuElementArray.length - 2) {
                    menuElementArray2[n3] = menuElementArray[n3];
                    ++n3;
                }
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            }
        }

        public boolean isAccessibleChildSelected(int n2) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                JMenuItem jMenuItem = this.this$0.getItem(n2);
                int n3 = 0;
                while (n3 < menuElementArray.length) {
                    if (menuElementArray[n3] == jMenuItem) {
                        return true;
                    }
                    ++n3;
                }
            }
            return false;
        }

        public Accessible getAccessibleChild(int n2) {
            Component[] componentArray = this.this$0.getMenuComponents();
            int n3 = 0;
            int n4 = 0;
            while (n4 < componentArray.length) {
                if (componentArray[n4] instanceof Accessible) {
                    if (n3 == n2) {
                        if (componentArray[n4] instanceof JComponent) {
                            AccessibleContext accessibleContext = ((Accessible)((Object)componentArray[n4])).getAccessibleContext();
                            accessibleContext.setAccessibleParent(this.this$0);
                        }
                        return (Accessible)((Object)componentArray[n4]);
                    }
                    ++n3;
                }
                ++n4;
            }
            return null;
        }

        public Accessible getAccessibleSelection(int n2) {
            if (n2 < 0 || n2 >= this.this$0.getItemCount()) {
                return null;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n3 = 0;
                while (n3 < menuElementArray.length) {
                    if (menuElementArray[n3] == this.this$0) {
                        while (++n3 < menuElementArray.length) {
                            if (!(menuElementArray[n3] instanceof JMenuItem)) continue;
                            return (Accessible)((Object)menuElementArray[n3]);
                        }
                    }
                    ++n3;
                }
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        protected AccessibleJMenu(JMenu jMenu) {
            this.this$0 = jMenu;
            super(jMenu);
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        WeakReference menuItem;
        private final JMenu this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JMenuItem jMenuItem = this.getTarget();
            if (jMenuItem == null) {
                Action action = (Action)propertyChangeEvent.getSource();
                action.removePropertyChangeListener(this);
            } else if (string.equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                jMenuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                jMenuItem.setEnabled(bl2);
            } else if (string.equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                jMenuItem.setIcon(icon);
                jMenuItem.invalidate();
                jMenuItem.repaint();
            } else if (string.equals("ActionCommandKey")) {
                jMenuItem.setActionCommand((String)propertyChangeEvent.getNewValue());
            }
        }

        public JMenuItem getTarget() {
            return (JMenuItem)this.menuItem.get();
        }

        public void setTarget(JMenuItem jMenuItem) {
            this.menuItem = new WeakReference(jMenuItem);
        }

        ActionChangedListener(JMenu jMenu, JMenuItem jMenuItem) {
            this.this$0 = jMenu;
            this.setTarget(jMenuItem);
        }
    }

    class MenuChangeListener
    implements ChangeListener,
    Serializable {
        boolean isSelected;
        private final JMenu this$0;

        MenuChangeListener(JMenu jMenu) {
            this.this$0 = jMenu;
            this.isSelected = false;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ButtonModel buttonModel = (ButtonModel)changeEvent.getSource();
            boolean bl2 = buttonModel.isSelected();
            if (bl2 != this.isSelected) {
                if (bl2) {
                    this.this$0.fireMenuSelected();
                } else {
                    this.this$0.fireMenuDeselected();
                }
                this.isSelected = bl2;
            }
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        JPopupMenu popupMenu;
        private final JMenu this$0;

        public void windowClosing(WindowEvent windowEvent) {
            this.this$0.setSelected(false);
        }

        public WinListener(JMenu jMenu, JPopupMenu jPopupMenu) {
            this.this$0 = jMenu;
            this.popupMenu = jPopupMenu;
        }
    }
}

