/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class InputMap
implements Serializable {
    private transient AbstractAction.ArrayTable arrayTable;
    private InputMap parent;

    public int size() {
        if (this.arrayTable == null) {
            return 0;
        }
        return this.arrayTable.size();
    }

    public void clear() {
        if (this.arrayTable != null) {
            this.arrayTable.clear();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt() - 1;
        while (n2 >= 0) {
            this.put((KeyStroke)objectInputStream.readObject(), objectInputStream.readObject());
            --n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AbstractAction.ArrayTable.writeArrayTable(objectOutputStream, this.arrayTable);
    }

    public InputMap getParent() {
        return this.parent;
    }

    public void setParent(InputMap inputMap) {
        this.parent = inputMap;
    }

    public KeyStroke[] allKeys() {
        int n2 = this.size();
        InputMap inputMap = this.getParent();
        if (n2 == 0) {
            if (inputMap != null) {
                return inputMap.allKeys();
            }
            return this.keys();
        }
        if (inputMap == null) {
            return this.keys();
        }
        KeyStroke[] keyStrokeArray = this.keys();
        KeyStroke[] keyStrokeArray2 = inputMap.allKeys();
        if (keyStrokeArray2 == null) {
            return keyStrokeArray;
        }
        if (keyStrokeArray == null) {
            return keyStrokeArray2;
        }
        HashMap hashMap = new HashMap();
        int n3 = keyStrokeArray.length - 1;
        while (n3 >= 0) {
            hashMap.put(keyStrokeArray[n3], keyStrokeArray[n3]);
            --n3;
        }
        n3 = keyStrokeArray2.length - 1;
        while (n3 >= 0) {
            hashMap.put(keyStrokeArray2[n3], keyStrokeArray2[n3]);
            --n3;
        }
        Object[] objectArray = new KeyStroke[hashMap.size()];
        return (KeyStroke[])hashMap.keySet().toArray(objectArray);
    }

    public KeyStroke[] keys() {
        if (this.arrayTable == null) {
            return null;
        }
        Object[] objectArray = new KeyStroke[this.arrayTable.size()];
        this.arrayTable.getKeys(objectArray);
        return objectArray;
    }

    public void remove(KeyStroke keyStroke) {
        if (this.arrayTable != null) {
            this.arrayTable.remove(keyStroke);
        }
    }

    public Object get(KeyStroke keyStroke) {
        InputMap inputMap;
        if (this.arrayTable == null) {
            InputMap inputMap2 = this.getParent();
            if (inputMap2 != null) {
                return inputMap2.get(keyStroke);
            }
            return null;
        }
        Object object = this.arrayTable.get(keyStroke);
        if (object == null && (inputMap = this.getParent()) != null) {
            return inputMap.get(keyStroke);
        }
        return object;
    }

    public void put(KeyStroke keyStroke, Object object) {
        if (keyStroke == null) {
            return;
        }
        if (object == null) {
            this.remove(keyStroke);
        } else {
            if (this.arrayTable == null) {
                this.arrayTable = new AbstractAction.ArrayTable();
            }
            this.arrayTable.put(keyStroke, object);
        }
    }
}

