/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

public class AudioFormat {
    protected Encoding encoding;
    protected float sampleRate;
    protected int sampleSizeInBits;
    protected int channels;
    protected int frameSize;
    protected float frameRate;
    protected boolean bigEndian;

    public float getFrameRate() {
        return this.frameRate;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public AudioFormat(float f2, int n2, int n3, boolean bl2, boolean bl3) {
        this(bl2 ? Encoding.PCM_SIGNED : Encoding.PCM_UNSIGNED, f2, n2, n3, n2 * n3 / 8, f2, bl3);
    }

    public String toString() {
        return this.getEncoding() + ", " + this.sampleRate + " Hz, " + this.sampleSizeInBits + " bit, " + (this.channels == 2 ? "stereo, " : "mono, ") + (this.sampleSizeInBits > 8 ? (this.bigEndian ? "big-endian, " : "little-endian, ") : "") + "audio data";
    }

    public boolean matches(AudioFormat audioFormat) {
        return !(audioFormat.getEncoding() != this.getEncoding() || audioFormat.getSampleRate() != -1.0f && audioFormat.getSampleRate() != this.getSampleRate() || audioFormat.getSampleSizeInBits() != this.getSampleSizeInBits() || audioFormat.getChannels() != this.getChannels() || audioFormat.getFrameSize() != this.getFrameSize() || audioFormat.getFrameRate() != -1.0f && audioFormat.getFrameRate() != this.getFrameRate() || audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != this.isBigEndian());
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public AudioFormat(Encoding encoding, float f2, int n2, int n3, int n4, float f3, boolean bl2) {
        this.encoding = encoding;
        this.sampleRate = f2;
        this.sampleSizeInBits = n2;
        this.channels = n3;
        this.frameSize = n4;
        this.frameRate = f3;
        this.bigEndian = bl2;
    }

    public static class Encoding {
        public static final Encoding PCM_SIGNED = new Encoding("PCM_SIGNED");
        public static final Encoding PCM_UNSIGNED = new Encoding("PCM_UNSIGNED");
        public static final Encoding ULAW = new Encoding("ULAW");
        public static final Encoding ALAW = new Encoding("ALAW");
        private String name;

        public final int hashCode() {
            return super.hashCode();
        }

        public final boolean equals(Object object) {
            return super.equals(object);
        }

        public final String toString() {
            return this.name;
        }

        protected Encoding(String string) {
            this.name = string;
        }
    }
}

