/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;

public class Track {
    protected Vector events = new Vector();

    public int size() {
        return this.events.size();
    }

    public long ticks() {
        return ((MidiEvent)this.events.lastElement()).getTick();
    }

    Track() {
        MetaMessage metaMessage = new MetaMessage();
        try {
            metaMessage.setMessage(47, new byte[0], 0);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        MidiEvent midiEvent = new MidiEvent(metaMessage, 0L);
        this.events.addElement(midiEvent);
    }

    public MidiEvent get(int n2) throws ArrayIndexOutOfBoundsException {
        return (MidiEvent)this.events.elementAt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(MidiEvent midiEvent) {
        Vector vector = this.events;
        synchronized (vector) {
            if (!this.events.contains(midiEvent)) {
                MetaMessage metaMessage;
                if (midiEvent.getMessage().getStatus() == 255 && (metaMessage = (MetaMessage)midiEvent.getMessage()).getType() == 47) {
                    MidiEvent midiEvent2 = (MidiEvent)this.events.elementAt(this.events.size() - 1);
                    if (midiEvent.getTick() > midiEvent2.getTick()) {
                        midiEvent2.setTick(midiEvent.getTick());
                    }
                    return true;
                }
                if (this.events.size() == 0) {
                    this.events.addElement(midiEvent);
                    return true;
                }
                int n2 = this.events.size();
                while (n2 > 0) {
                    if (midiEvent.getTick() >= ((MidiEvent)this.events.elementAt(n2 - 1)).getTick()) break;
                    --n2;
                }
                if (n2 == this.events.size()) {
                    ((MidiEvent)this.events.elementAt(n2 - 1)).setTick(midiEvent.getTick());
                    this.events.insertElementAt(midiEvent, n2 - 1);
                } else {
                    this.events.insertElementAt(midiEvent, n2);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(MidiEvent midiEvent) {
        Vector vector = this.events;
        synchronized (vector) {
            return this.events.removeElement(midiEvent);
        }
    }
}

