/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;

public abstract class MidiMessage
implements Cloneable {
    protected byte[] data;
    protected int length = 0;

    public int getLength() {
        return this.length;
    }

    public int getStatus() {
        if (this.length > 0) {
            return this.data[0] & 0xFF;
        }
        return 0;
    }

    public byte[] getMessage() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        return byArray;
    }

    protected MidiMessage(byte[] byArray) {
        this.data = byArray;
        this.length = byArray.length;
    }

    protected void setMessage(byte[] byArray, int n2) throws InvalidMidiDataException {
        if (n2 < 0 || n2 > byArray.length) {
            throw new IndexOutOfBoundsException("length out of bounds: " + n2);
        }
        this.length = n2;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        System.arraycopy(byArray, 0, this.data, 0, n2);
    }

    public abstract Object clone();
}

