/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import javax.imageio.stream.MemoryCache;

public class MemoryCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private MemoryCache cache = new MemoryCache();

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int n2 = this.cache.read(this.streamPos);
        if (n2 != -1) {
            ++this.streamPos;
        }
        return n2;
    }

    public long length() {
        return this.cache.getLength();
    }

    public void close() throws IOException {
        long l2 = this.cache.getLength();
        this.seek(l2);
        this.flushBefore(l2);
        super.close();
        this.cache.reset();
        this.stream = null;
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return true;
    }

    public void write(int n2) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.cache.write(n2, this.streamPos);
        ++this.streamPos;
    }

    public void flushBefore(long l2) throws IOException {
        long l3 = this.flushedPos;
        super.flushBefore(l2);
        long l4 = this.flushedPos - l3;
        this.cache.writeToStream(this.stream, l3, l4);
        this.cache.disposeBefore(this.flushedPos);
        this.stream.flush();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        this.bitOffset = 0;
        if (n3 == 0) {
            return 0;
        }
        long l2 = this.cache.getLength() - this.streamPos;
        if (l2 <= 0L) {
            return -1;
        }
        n3 = (int)Math.min(l2, (long)n3);
        this.cache.read(byArray, n2, n3, this.streamPos);
        this.streamPos += (long)n3;
        return n3;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.cache.write(byArray, n2, n3, this.streamPos);
        this.streamPos += (long)n3;
    }

    public MemoryCacheImageOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.stream = outputStream;
    }
}

