/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.io.Converters;

public class XMLFormatter
extends Formatter {
    private LogManager manager = LogManager.getLogManager();

    private void a2(StringBuffer stringBuffer, int n2) {
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
    }

    private void appendISO8601(StringBuffer stringBuffer, long l2) {
        Date date = new Date(l2);
        stringBuffer.append(date.getYear() + 1900);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getMonth() + 1);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getDate());
        stringBuffer.append('T');
        this.a2(stringBuffer, date.getHours());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getMinutes());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getSeconds());
    }

    private void escape(StringBuffer stringBuffer, String string) {
        if (string == null) {
            string = "<null>";
        }
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '<') {
                stringBuffer.append("&lt;");
            } else if (c2 == '>') {
                stringBuffer.append("&gt;");
            } else if (c2 == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
    }

    public String getHead(Handler handler) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"");
        String string = handler.getEncoding();
        if (string == null) {
            string = Converters.getDefaultEncodingName();
        }
        try {
            Charset charset = Charset.forName(string);
            string = charset.name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(" encoding=\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
        stringBuffer.append(" standalone=\"no\"?>\n");
        stringBuffer.append("<!DOCTYPE log SYSTEM \"logger.dtd\">\n");
        stringBuffer.append("<log>\n");
        return stringBuffer.toString();
    }

    public String getTail(Handler handler) {
        return "</log>\n";
    }

    public String format(LogRecord logRecord) {
        Object[] objectArray;
        StringBuffer stringBuffer;
        block12: {
            Object object;
            stringBuffer = new StringBuffer(500);
            stringBuffer.append("<record>\n");
            stringBuffer.append("  <date>");
            this.appendISO8601(stringBuffer, logRecord.getMillis());
            stringBuffer.append("</date>\n");
            stringBuffer.append("  <millis>");
            stringBuffer.append(logRecord.getMillis());
            stringBuffer.append("</millis>\n");
            stringBuffer.append("  <sequence>");
            stringBuffer.append(logRecord.getSequenceNumber());
            stringBuffer.append("</sequence>\n");
            String string = logRecord.getLoggerName();
            if (string != null) {
                stringBuffer.append("  <logger>");
                this.escape(stringBuffer, string);
                stringBuffer.append("</logger>\n");
            }
            stringBuffer.append("  <level>");
            this.escape(stringBuffer, logRecord.getLevel().toString());
            stringBuffer.append("</level>\n");
            if (logRecord.getSourceClassName() != null) {
                stringBuffer.append("  <class>");
                this.escape(stringBuffer, logRecord.getSourceClassName());
                stringBuffer.append("</class>\n");
            }
            if (logRecord.getSourceMethodName() != null) {
                stringBuffer.append("  <method>");
                this.escape(stringBuffer, logRecord.getSourceMethodName());
                stringBuffer.append("</method>\n");
            }
            stringBuffer.append("  <thread>");
            stringBuffer.append(logRecord.getThreadID());
            stringBuffer.append("</thread>\n");
            if (logRecord.getMessage() != null) {
                object = this.formatMessage(logRecord);
                stringBuffer.append("  <message>");
                this.escape(stringBuffer, (String)object);
                stringBuffer.append("</message>");
                stringBuffer.append("\n");
            }
            object = logRecord.getResourceBundle();
            try {
                if (object == null || ((ResourceBundle)object).getString(logRecord.getMessage()) == null) break block12;
                stringBuffer.append("  <key>");
                this.escape(stringBuffer, logRecord.getMessage());
                stringBuffer.append("</key>\n");
                stringBuffer.append("  <catalog>");
                this.escape(stringBuffer, logRecord.getResourceBundleName());
                stringBuffer.append("</catalog>\n");
                objectArray = logRecord.getParameters();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    stringBuffer.append("  <param>");
                    try {
                        this.escape(stringBuffer, objectArray[n2].toString());
                    }
                    catch (Exception exception) {
                        stringBuffer.append("???");
                    }
                    stringBuffer.append("</param>\n");
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (logRecord.getThrown() != null) {
            objectArray = logRecord.getThrown();
            stringBuffer.append("  <exception>\n");
            stringBuffer.append("    <message>");
            this.escape(stringBuffer, objectArray.toString());
            stringBuffer.append("</message>\n");
            StackTraceElement[] stackTraceElementArray = objectArray.getStackTrace();
            int n3 = 0;
            while (n3 < stackTraceElementArray.length) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n3];
                stringBuffer.append("    <frame>\n");
                stringBuffer.append("      <class>");
                this.escape(stringBuffer, stackTraceElement.getClassName());
                stringBuffer.append("</class>\n");
                stringBuffer.append("      <method>");
                this.escape(stringBuffer, stackTraceElement.getMethodName());
                stringBuffer.append("</method>\n");
                if (stackTraceElement.getLineNumber() >= 0) {
                    stringBuffer.append("      <line>");
                    stringBuffer.append(stackTraceElement.getLineNumber());
                    stringBuffer.append("</line>\n");
                }
                stringBuffer.append("    </frame>\n");
                ++n3;
            }
            stringBuffer.append("  </exception>\n");
        }
        stringBuffer.append("</record>\n");
        return stringBuffer.toString();
    }
}

