/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import sun.text.Utility;

public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private Locale locale;
    private String pattern = "";
    private static final int INITIAL_FORMATS = 10;
    private Format[] formats = new Format[10];
    private int[] offsets = new int[10];
    private int[] argumentNumbers = new int[10];
    private int maxOffset = -1;
    private static final String[] typeList = new String[]{"", "", "number", "", "date", "", "time", "", "choice"};
    private static final String[] modifierList = new String[]{"", "", "currency", "", "percent", "", "integer"};
    private static final String[] dateModifierList = new String[]{"", "", "short", "", "medium", "", "long", "", "full"};
    static Class class$java$text$MessageFormat$Field;

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl2;
        objectInputStream.defaultReadObject();
        boolean bl3 = bl2 = this.maxOffset >= -1 && this.formats.length > this.maxOffset && this.offsets.length > this.maxOffset && this.argumentNumbers.length > this.maxOffset;
        if (bl2) {
            int n2 = this.pattern.length() + 1;
            int n3 = this.maxOffset;
            while (n3 >= 0) {
                if (this.offsets[n3] < 0 || this.offsets[n3] > n2) {
                    bl2 = false;
                    break;
                }
                n2 = this.offsets[n3];
                --n3;
            }
        }
        if (!bl2) {
            throw new InvalidObjectException("Could not reconstruct MessageFormat from corrupt stream.");
        }
    }

    public Object clone() {
        MessageFormat messageFormat = (MessageFormat)super.clone();
        messageFormat.formats = (Format[])this.formats.clone();
        int n2 = 0;
        while (n2 < this.formats.length) {
            if (this.formats[n2] != null) {
                messageFormat.formats[n2] = (Format)this.formats[n2].clone();
            }
            ++n2;
        }
        messageFormat.offsets = (int[])this.offsets.clone();
        messageFormat.argumentNumbers = (int[])this.argumentNumbers.clone();
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MessageFormat messageFormat = (MessageFormat)object;
        return this.maxOffset == messageFormat.maxOffset && this.pattern.equals(messageFormat.pattern) && Utility.objectEquals(this.locale, messageFormat.locale) && Utility.arrayEquals(this.offsets, (Object)messageFormat.offsets) && Utility.arrayEquals(this.argumentNumbers, (Object)messageFormat.argumentNumbers) && Utility.arrayEquals(this.formats, (Object)messageFormat.formats);
    }

    public String toPattern() {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 <= this.maxOffset) {
            MessageFormat.copyAndFixQuotes(this.pattern, n2, this.offsets[n3], stringBuffer);
            n2 = this.offsets[n3];
            stringBuffer.append('{');
            stringBuffer.append(this.argumentNumbers[n3]);
            if (this.formats[n3] != null) {
                if (this.formats[n3] instanceof DecimalFormat) {
                    if (this.formats[n3].equals(NumberFormat.getInstance(this.locale))) {
                        stringBuffer.append(",number");
                    } else if (this.formats[n3].equals(NumberFormat.getCurrencyInstance(this.locale))) {
                        stringBuffer.append(",number,currency");
                    } else if (this.formats[n3].equals(NumberFormat.getPercentInstance(this.locale))) {
                        stringBuffer.append(",number,percent");
                    } else if (this.formats[n3].equals(NumberFormat.getIntegerInstance(this.locale))) {
                        stringBuffer.append(",number,integer");
                    } else {
                        stringBuffer.append(",number," + ((DecimalFormat)this.formats[n3]).toPattern());
                    }
                } else if (this.formats[n3] instanceof SimpleDateFormat) {
                    if (this.formats[n3].equals(DateFormat.getDateInstance(2, this.locale))) {
                        stringBuffer.append(",date");
                    } else if (this.formats[n3].equals(DateFormat.getDateInstance(3, this.locale))) {
                        stringBuffer.append(",date,short");
                    } else if (this.formats[n3].equals(DateFormat.getDateInstance(2, this.locale))) {
                        stringBuffer.append(",date,medium");
                    } else if (this.formats[n3].equals(DateFormat.getDateInstance(1, this.locale))) {
                        stringBuffer.append(",date,long");
                    } else if (this.formats[n3].equals(DateFormat.getDateInstance(0, this.locale))) {
                        stringBuffer.append(",date,full");
                    } else if (this.formats[n3].equals(DateFormat.getTimeInstance(2, this.locale))) {
                        stringBuffer.append(",time");
                    } else if (this.formats[n3].equals(DateFormat.getTimeInstance(3, this.locale))) {
                        stringBuffer.append(",time,short");
                    } else if (this.formats[n3].equals(DateFormat.getTimeInstance(2, this.locale))) {
                        stringBuffer.append(",time,medium");
                    } else if (this.formats[n3].equals(DateFormat.getTimeInstance(1, this.locale))) {
                        stringBuffer.append(",time,long");
                    } else if (this.formats[n3].equals(DateFormat.getTimeInstance(0, this.locale))) {
                        stringBuffer.append(",time,full");
                    } else {
                        stringBuffer.append(",date," + ((SimpleDateFormat)this.formats[n3]).toPattern());
                    }
                } else if (this.formats[n3] instanceof ChoiceFormat) {
                    stringBuffer.append(",choice," + ((ChoiceFormat)this.formats[n3]).toPattern());
                }
            }
            stringBuffer.append('}');
            ++n3;
        }
        MessageFormat.copyAndFixQuotes(this.pattern, n2, this.pattern.length(), stringBuffer);
        return stringBuffer.toString();
    }

    public MessageFormat(String string) {
        this.locale = Locale.getDefault();
        this.applyPattern(string);
    }

    public void applyPattern(String string) {
        StringBuffer[] stringBufferArray = new StringBuffer[4];
        int n2 = 0;
        while (n2 < stringBufferArray.length) {
            stringBufferArray[n2] = new StringBuffer();
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        this.maxOffset = -1;
        int n6 = 0;
        while (n6 < string.length()) {
            char c2 = string.charAt(n6);
            if (n3 == 0) {
                if (c2 == '\'') {
                    if (n6 + 1 < string.length() && string.charAt(n6 + 1) == '\'') {
                        stringBufferArray[n3].append(c2);
                        ++n6;
                    } else {
                        bl2 = !bl2;
                    }
                } else if (c2 == '{' && !bl2) {
                    n3 = 1;
                } else {
                    stringBufferArray[n3].append(c2);
                }
            } else if (bl2) {
                stringBufferArray[n3].append(c2);
                if (c2 == '\'') {
                    bl2 = false;
                }
            } else {
                switch (c2) {
                    case ',': {
                        if (n3 < 3) {
                            ++n3;
                            break;
                        }
                        stringBufferArray[n3].append(c2);
                        break;
                    }
                    case '{': {
                        ++n5;
                        stringBufferArray[n3].append(c2);
                        break;
                    }
                    case '}': {
                        if (n5 == 0) {
                            n3 = 0;
                            this.makeFormat(n6, n4, stringBufferArray);
                            ++n4;
                            break;
                        }
                        --n5;
                        stringBufferArray[n3].append(c2);
                        break;
                    }
                    case '\'': {
                        bl2 = true;
                    }
                    default: {
                        stringBufferArray[n3].append(c2);
                    }
                }
            }
            ++n6;
        }
        if (n5 == 0 && n3 != 0) {
            this.maxOffset = -1;
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        this.pattern = stringBufferArray[0].toString();
    }

    private void makeFormat(int n2, int n3, StringBuffer[] stringBufferArray) {
        Object object;
        int n4;
        int n5;
        try {
            n5 = Integer.parseInt(stringBufferArray[1].toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("can't parse argument number " + stringBufferArray[1]);
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("negative argument number " + n5);
        }
        if (n3 >= this.formats.length) {
            n4 = this.formats.length * 2;
            object = new Format[n4];
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            System.arraycopy(this.formats, 0, object, 0, this.maxOffset + 1);
            System.arraycopy(this.offsets, 0, nArray, 0, this.maxOffset + 1);
            System.arraycopy(this.argumentNumbers, 0, nArray2, 0, this.maxOffset + 1);
            this.formats = object;
            this.offsets = nArray;
            this.argumentNumbers = nArray2;
        }
        n4 = this.maxOffset;
        this.maxOffset = n3;
        this.offsets[n3] = stringBufferArray[0].length();
        this.argumentNumbers[n3] = n5;
        object = null;
        block2 : switch (MessageFormat.findKeyword(stringBufferArray[2].toString(), typeList)) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                switch (MessageFormat.findKeyword(stringBufferArray[3].toString(), modifierList)) {
                    case 0: {
                        object = NumberFormat.getInstance(this.locale);
                        break block2;
                    }
                    case 1: 
                    case 2: {
                        object = NumberFormat.getCurrencyInstance(this.locale);
                        break block2;
                    }
                    case 3: 
                    case 4: {
                        object = NumberFormat.getPercentInstance(this.locale);
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        object = NumberFormat.getIntegerInstance(this.locale);
                        break block2;
                    }
                }
                object = new DecimalFormat(stringBufferArray[3].toString(), new DecimalFormatSymbols(this.locale));
                break;
            }
            case 3: 
            case 4: {
                switch (MessageFormat.findKeyword(stringBufferArray[3].toString(), dateModifierList)) {
                    case 0: {
                        object = DateFormat.getDateInstance(2, this.locale);
                        break block2;
                    }
                    case 1: 
                    case 2: {
                        object = DateFormat.getDateInstance(3, this.locale);
                        break block2;
                    }
                    case 3: 
                    case 4: {
                        object = DateFormat.getDateInstance(2, this.locale);
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        object = DateFormat.getDateInstance(1, this.locale);
                        break block2;
                    }
                    case 7: 
                    case 8: {
                        object = DateFormat.getDateInstance(0, this.locale);
                        break block2;
                    }
                }
                object = new SimpleDateFormat(stringBufferArray[3].toString(), this.locale);
                break;
            }
            case 5: 
            case 6: {
                switch (MessageFormat.findKeyword(stringBufferArray[3].toString(), dateModifierList)) {
                    case 0: {
                        object = DateFormat.getTimeInstance(2, this.locale);
                        break block2;
                    }
                    case 1: 
                    case 2: {
                        object = DateFormat.getTimeInstance(3, this.locale);
                        break block2;
                    }
                    case 3: 
                    case 4: {
                        object = DateFormat.getTimeInstance(2, this.locale);
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        object = DateFormat.getTimeInstance(1, this.locale);
                        break block2;
                    }
                    case 7: 
                    case 8: {
                        object = DateFormat.getTimeInstance(0, this.locale);
                        break block2;
                    }
                }
                object = new SimpleDateFormat(stringBufferArray[3].toString(), this.locale);
                break;
            }
            case 7: 
            case 8: {
                try {
                    object = new ChoiceFormat(stringBufferArray[3].toString());
                    break;
                }
                catch (Exception exception) {
                    this.maxOffset = n4;
                    throw new IllegalArgumentException("Choice Pattern incorrect");
                }
            }
            default: {
                this.maxOffset = n4;
                throw new IllegalArgumentException("unknown format type at ");
            }
        }
        this.formats[n3] = object;
        stringBufferArray[1].setLength(0);
        stringBufferArray[2].setLength(0);
        stringBufferArray[3].setLength(0);
    }

    public Format[] getFormats() {
        Format[] formatArray = new Format[this.maxOffset + 1];
        System.arraycopy(this.formats, 0, formatArray, 0, this.maxOffset + 1);
        return formatArray;
    }

    public Format[] getFormatsByArgumentIndex() {
        int n2 = -1;
        int n3 = 0;
        while (n3 <= this.maxOffset) {
            if (this.argumentNumbers[n3] > n2) {
                n2 = this.argumentNumbers[n3];
            }
            ++n3;
        }
        Format[] formatArray = new Format[n2 + 1];
        int n4 = 0;
        while (n4 <= this.maxOffset) {
            formatArray[this.argumentNumbers[n4]] = this.formats[n4];
            ++n4;
        }
        return formatArray;
    }

    public void setFormat(int n2, Format format) {
        this.formats[n2] = format;
    }

    public void setFormatByArgumentIndex(int n2, Format format) {
        int n3 = 0;
        while (n3 <= this.maxOffset) {
            if (this.argumentNumbers[n3] == n2) {
                this.formats[n3] = format;
            }
            ++n3;
        }
    }

    public void setFormats(Format[] formatArray) {
        int n2 = formatArray.length;
        if (n2 > this.maxOffset + 1) {
            n2 = this.maxOffset + 1;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.formats[n3] = formatArray[n3];
            ++n3;
        }
    }

    public void setFormatsByArgumentIndex(Format[] formatArray) {
        int n2 = 0;
        while (n2 <= this.maxOffset) {
            int n3 = this.argumentNumbers[n2];
            if (n3 < formatArray.length) {
                this.formats[n2] = formatArray[n3];
            }
            ++n2;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.parse(string, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("MessageFormat parse error!", parsePosition.errorIndex);
        }
        return objectArray;
    }

    private static final int findKeyword(String string, String[] stringArray) {
        string = string.trim().toLowerCase();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static final void copyAndFixQuotes(String string, int n2, int n3, StringBuffer stringBuffer) {
        int n4 = n2;
        while (n4 < n3) {
            char c2 = string.charAt(n4);
            if (c2 == '{') {
                stringBuffer.append("'{'");
            } else if (c2 == '}') {
                stringBuffer.append("'}'");
            } else if (c2 == '\'') {
                stringBuffer.append("''");
            } else {
                stringBuffer.append(c2);
            }
            ++n4;
        }
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList();
        if (object == null) {
            throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
        }
        this.subformat((Object[])object, stringBuffer, null, arrayList);
        if (arrayList.size() == 0) {
            return this.createAttributedCharacterIterator("");
        }
        return this.createAttributedCharacterIterator((AttributedCharacterIterator[])arrayList.toArray(new AttributedCharacterIterator[arrayList.size()]));
    }

    private void append(StringBuffer stringBuffer, CharacterIterator characterIterator) {
        if (characterIterator.first() != '\uffff') {
            char c2;
            stringBuffer.append(characterIterator.first());
            while ((c2 = characterIterator.next()) != '\uffff') {
                stringBuffer.append(c2);
            }
        }
    }

    public MessageFormat(String string, Locale locale) {
        this.locale = locale;
        this.applyPattern(string);
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        int n2;
        if (string == null) {
            Object[] objectArray = new Object[]{};
            return objectArray;
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 <= this.maxOffset) {
            if (this.argumentNumbers[n4] > n3) {
                n3 = this.argumentNumbers[n4];
            }
            ++n4;
        }
        Object[] objectArray = new Object[n3 + 1];
        int n5 = 0;
        int n6 = parsePosition.index;
        ParsePosition parsePosition2 = new ParsePosition(0);
        int n7 = 0;
        while (n7 <= this.maxOffset) {
            n2 = this.offsets[n7] - n5;
            if (n2 == 0 || this.pattern.regionMatches(n5, string, n6, n2)) {
                n6 += n2;
                n5 += n2;
            } else {
                parsePosition.errorIndex = n6;
                return null;
            }
            if (this.formats[n7] == null) {
                int n8 = n7 != this.maxOffset ? this.offsets[n7 + 1] : this.pattern.length();
                int n9 = n5 >= n8 ? string.length() : string.indexOf(this.pattern.substring(n5, n8), n6);
                if (n9 < 0) {
                    parsePosition.errorIndex = n6;
                    return null;
                }
                String string2 = string.substring(n6, n9);
                if (!string2.equals("{" + this.argumentNumbers[n7] + "}")) {
                    objectArray[this.argumentNumbers[n7]] = string.substring(n6, n9);
                }
                n6 = n9;
            } else {
                parsePosition2.index = n6;
                objectArray[this.argumentNumbers[n7]] = this.formats[n7].parseObject(string, parsePosition2);
                if (parsePosition2.index == n6) {
                    parsePosition.errorIndex = n6;
                    return null;
                }
                n6 = parsePosition2.index;
            }
            ++n7;
        }
        n2 = this.pattern.length() - n5;
        if (n2 != 0 && !this.pattern.regionMatches(n5, string, n6, n2)) {
            parsePosition.errorIndex = n6;
            return null;
        }
        parsePosition.index = n6 + n2;
        return objectArray;
    }

    public static String format(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.subformat((Object[])object, stringBuffer, fieldPosition, null);
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.subformat(objectArray, stringBuffer, fieldPosition, null);
    }

    private StringBuffer subformat(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition, List list) {
        int n2 = 0;
        int n3 = stringBuffer.length();
        int n4 = 0;
        while (n4 <= this.maxOffset) {
            stringBuffer.append(this.pattern.substring(n2, this.offsets[n4]));
            n2 = this.offsets[n4];
            int n5 = this.argumentNumbers[n4];
            if (objectArray == null || n5 >= objectArray.length) {
                stringBuffer.append("{" + n5 + "}");
            } else {
                Object[] objectArray2 = objectArray[n5];
                String string = null;
                Format format = null;
                if (objectArray2 == null) {
                    string = "null";
                } else if (this.formats[n4] != null) {
                    format = this.formats[n4];
                    if (format instanceof ChoiceFormat && (string = this.formats[n4].format(objectArray2)).indexOf(123) >= 0) {
                        format = new MessageFormat(string, this.locale);
                        objectArray2 = objectArray;
                        string = null;
                    }
                } else if (objectArray2 instanceof Number) {
                    format = NumberFormat.getInstance(this.locale);
                } else if (objectArray2 instanceof Date) {
                    format = DateFormat.getDateTimeInstance(3, 3, this.locale);
                } else if (objectArray2 instanceof String) {
                    string = (String)objectArray2;
                } else {
                    string = objectArray2.toString();
                    if (string == null) {
                        string = "null";
                    }
                }
                if (list != null) {
                    if (n3 != stringBuffer.length()) {
                        list.add(this.createAttributedCharacterIterator(stringBuffer.substring(n3)));
                        n3 = stringBuffer.length();
                    }
                    if (format != null) {
                        AttributedCharacterIterator attributedCharacterIterator = format.formatToCharacterIterator(objectArray2);
                        this.append(stringBuffer, attributedCharacterIterator);
                        if (n3 != stringBuffer.length()) {
                            list.add(this.createAttributedCharacterIterator(attributedCharacterIterator, (AttributedCharacterIterator.Attribute)Field.ARGUMENT, (Object)new Integer(n5)));
                            n3 = stringBuffer.length();
                        }
                        string = null;
                    }
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(string);
                        list.add(this.createAttributedCharacterIterator(string, (AttributedCharacterIterator.Attribute)Field.ARGUMENT, (Object)new Integer(n5)));
                        n3 = stringBuffer.length();
                    }
                } else {
                    if (format != null) {
                        string = format.format(objectArray2);
                    }
                    n3 = stringBuffer.length();
                    stringBuffer.append(string);
                    if (n4 == 0 && fieldPosition != null && Field.ARGUMENT.equals(fieldPosition.getFieldAttribute())) {
                        fieldPosition.setBeginIndex(n3);
                        fieldPosition.setEndIndex(stringBuffer.length());
                    }
                    n3 = stringBuffer.length();
                }
            }
            ++n4;
        }
        stringBuffer.append(this.pattern.substring(n2, this.pattern.length()));
        if (list != null && n3 != stringBuffer.length()) {
            list.add(this.createAttributedCharacterIterator(stringBuffer.substring(n3)));
        }
        return stringBuffer;
    }

    public static class Field
    extends Format.Field {
        public static final Field ARGUMENT = new Field("message argument field");

        protected Object readResolve() throws InvalidObjectException {
            if (this.getClass() != (class$java$text$MessageFormat$Field == null ? (class$java$text$MessageFormat$Field = MessageFormat.class$("java.text.MessageFormat$Field")) : class$java$text$MessageFormat$Field)) {
                throw new InvalidObjectException("subclass didn't correctly implement readResolve");
            }
            return ARGUMENT;
        }

        protected Field(String string) {
            super(string);
        }
    }
}

