/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.RMIClassLoaderSpi;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import sun.misc.Service;
import sun.rmi.server.LoaderHandler;

public class RMIClassLoader {
    private static final RMIClassLoaderSpi defaultProvider = RMIClassLoader.newDefaultProviderInstance();
    private static final RMIClassLoaderSpi provider = (RMIClassLoaderSpi)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return RMIClassLoader.access$000();
        }
    });
    static Class class$java$rmi$server$RMIClassLoaderSpi;

    private RMIClassLoader() {
    }

    static RMIClassLoaderSpi access$000() {
        return RMIClassLoader.initializeProvider();
    }

    public static RMIClassLoaderSpi getDefaultProviderInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setFactory"));
        }
        return defaultProvider;
    }

    private static RMIClassLoaderSpi initializeProvider() {
        String string = System.getProperty("java.rmi.server.RMIClassLoaderSpi");
        if (string != null) {
            if (string.equals("default")) {
                return defaultProvider;
            }
            try {
                Class clazz = Class.forName(string, false, ClassLoader.getSystemClassLoader());
                return (RMIClassLoaderSpi)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new InstantiationError(instantiationException.getMessage());
            }
            catch (ClassCastException classCastException) {
                LinkageError linkageError = new LinkageError("provider class not assignable to RMIClassLoaderSpi");
                linkageError.initCause(classCastException);
                throw linkageError;
            }
        }
        Iterator iterator = Service.providers(class$java$rmi$server$RMIClassLoaderSpi == null ? (class$java$rmi$server$RMIClassLoaderSpi = RMIClassLoader.class$("java.rmi.server.RMIClassLoaderSpi")) : class$java$rmi$server$RMIClassLoaderSpi, ClassLoader.getSystemClassLoader());
        if (iterator.hasNext()) {
            try {
                return (RMIClassLoaderSpi)iterator.next();
            }
            catch (ClassCastException classCastException) {
                LinkageError linkageError = new LinkageError("provider class not assignable to RMIClassLoaderSpi");
                linkageError.initCause(classCastException);
                throw linkageError;
            }
        }
        return defaultProvider;
    }

    private static RMIClassLoaderSpi newDefaultProviderInstance() {
        return new RMIClassLoaderSpi(){

            public ClassLoader getClassLoader(String string) throws MalformedURLException {
                return LoaderHandler.getClassLoader(string);
            }

            public String getClassAnnotation(Class clazz) {
                return LoaderHandler.getClassAnnotation(clazz);
            }

            public Class loadClass(String string, String string2, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
                return LoaderHandler.loadClass(string, string2, classLoader);
            }

            public Class loadProxyClass(String string, String[] stringArray, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
                return LoaderHandler.loadProxyClass(string, stringArray, classLoader);
            }
        };
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Class loadClass(String string) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.loadClass((String)null, string);
    }

    public static ClassLoader getClassLoader(String string) throws MalformedURLException, SecurityException {
        return provider.getClassLoader(string);
    }

    public static Object getSecurityContext(ClassLoader classLoader) {
        return LoaderHandler.getSecurityContext(classLoader);
    }

    public static String getClassAnnotation(Class clazz) {
        return provider.getClassAnnotation(clazz);
    }

    public static Class loadClass(String string, String string2) throws MalformedURLException, ClassNotFoundException {
        return provider.loadClass(string, string2, null);
    }

    public static Class loadClass(URL uRL, String string) throws MalformedURLException, ClassNotFoundException {
        return provider.loadClass(uRL != null ? uRL.toString() : null, string, null);
    }

    public static Class loadClass(String string, String string2, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
        return provider.loadClass(string, string2, classLoader);
    }

    public static Class loadProxyClass(String string, String[] stringArray, ClassLoader classLoader) throws ClassNotFoundException, MalformedURLException {
        return provider.loadProxyClass(string, stringArray, classLoader);
    }
}

